/****************************************************************************
/*****************************************************************************
* FILE 			: InterService.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: Intercom
*
* DESCRIPTION 	: This class creates the interfacing between HMI and Intercom App
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/06/2020     Initial version
*
****************************************************************************/
#if !defined(INTERCOM_SERVICE_H)
#define INTERCOM_SERVICE_H

#include "IntercomAudioServiceStub.h"
#include "IntercomNanoMessageClientHandler.h"
#include <dlt/dlt.h>
#include <IntercomErrorHandlerConstant.h>



using namespace ::asf::core;
using namespace ::bosch::cm::ai::IntercomAudioService;

namespace IntercomApp
{
/*!
 * \page Intercom Audio DBUS service

   \brief   The DBUS service to start and stop Intercom Audio.
    - Service Name\n
         Intercom.DBusServer.IntercomAudioService \n
    - Service Path\n
         /bosch/cm/ai/IntercomAudioService \n
    - package\n
         bosch.cm.ai.Intercom \n
    - Interface\n
         IntercomAudioService \n
 */



class IntercomService : public IntercomAudioServiceStub
{
public:
    // Create the instance of IntercomService.
    static IntercomService* createInstance ( );

    // Destroy the instance of IntercomService.
    static void destroyInstance ( );

    // Initialize the dbus service
    void initialize ( );

    void initialize_dlt ();

    // Deinitialize the dbus service
    void deinitialize ( );


    // Update the Intercom Audio Route Status to all the registered dbus client.
    void vUpdateIntercomRouteStatus ( const uint8 u8Status );

    // outgoing call from driver to intercom
    virtual void onOutgoingCallRequest (const ::boost::shared_ptr< OutgoingCallRequest >& request);

    // incoming call response with accept / reject
    virtual void onCallActionRequest (const ::boost::shared_ptr< CallActionRequest >& request);

    //PhoneStatus
    virtual void onGetPhoneStatusRequest (const ::boost::shared_ptr< GetPhoneStatusRequest >& request);
	
	//get Intercom Availablity Status
	virtual void onGetAvailabilityRequest (const ::boost::shared_ptr< GetAvailabilityRequest >& request) ;


    // incoming call notification to hmi with phoneNo
    void sendIncomingCall ( int32 PhoneNumber );

    // nanomessage error

    void sendNanoMessageError ( eNanoMessageError ErrorCode );


    // config error

    void sendConfigError ( eConfigError ErrorCode );


    // RTP Error

    void sendRTPError ( eRTPError ErrorCode );
	
	//send Response of Intercom Availability
	
	void SendResponseAvailability ( uint8 available );
	
	//send Event of Intercom Availability

    void SendEventAvailability ( uint8 available );
	
	void sendEventCanCellCall (); 


    // this method is used for cancelling outgoing call
    //virtual void onCancelOutgoingCallRequest (const ::boost::shared_ptr< CancelOutgoingCallRequest >& request);

private:
    // Constructor.
    IntercomService ( );

    // Destructor.
    virtual ~IntercomService ( );

    static IntercomService* s_pInstance;
};
}

#endif // INTERCOM_SERVICE_H
