/****************************************************************************
/*****************************************************************************
* FILE 			: IntercomService.cpp
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: Intercom
*
* DESCRIPTION 	: This class creates the interfacing between HMI and Intercom App
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/06/2020     Initial version
*
****************************************************************************/

#include <IntercomComponent.h>
#include "IntercomService.h"
#include "Trace/IntercomApp_Trace.h"
#include "AudioSourceHandler/IntercomAudioClientHandler.h"



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_INTERCOM_DBUS_SERVICE
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_INTERCOM
#define ETG_I_TTFIS_CMD_PREFIX            "INTERCOM_SERVICE_"
#define ETG_I_FILE_PREFIX                 Intercom::DBusServer::IntercomService::IntercomService
#include "trcGenProj/Header/IntercomService.cpp.trc.h"
#endif


DLT_IMPORT_CONTEXT(INTERCOM_SERVICE);

namespace IntercomApp
{

IntercomService* IntercomService::s_pInstance = NULL;

IntercomService::IntercomService():IntercomAudioServiceStub("IntercomServerPort")
{


    ETG_I_REGISTER_FILE();


    //DLT_UNREGISTER_CONTEXT(INTERCOM_SERVICE);
    //DLT_UNREGISTER_APP();



    initialize();
    //ETG_TRACE_USR4(("IntercomService Constructor"));
}


IntercomService::~IntercomService()
{
    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("destructor of IntercomService"));
    this->destroyInstance();
}


IntercomService* IntercomService::createInstance()
{
    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : createInstance"));
    if (s_pInstance == NULL)
    {
        s_pInstance = OSAL_NEW IntercomService();
    }

    return s_pInstance;
}



void IntercomService::destroyInstance()
{
    if (NULL != s_pInstance)
    {
        OSAL_DELETE s_pInstance;

        s_pInstance = NULL;
    }
}

/*!
 *
 * \brief   Initialize the dbus service.
 *
 * \author  Neil Mao (CM/ESW21-CN)
 *
 */
void IntercomService::initialize()
{
    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : initialize"));
    //LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);
    //todo
}


void IntercomService::deinitialize()
{
    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : initialize"));
    //todo
}




void IntercomService::vUpdateIntercomRouteStatus(const uint8 u8Status)
{
    ETG_TRACE_USR4(("vUpdateIntercomRouteStatus(): IntercomAudioRouteStatus=%u.", u8Status));

    //sendNaviSigNaviAnnouncementStatusSignal(static_cast<NaviAnnouncementStatus>(u8Status));

}


void IntercomService::onOutgoingCallRequest (const ::boost::shared_ptr< OutgoingCallRequest >& request)
{
    int32 phoneNo_ = request->getPhoneNo ();

    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : Outgoing call PhoneNo with nano framework "), DLT_UINT( phoneNo_ ) );
	DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("onOffTriggerRequest SWITCH ON "));
	IntercomComponent::getInstance()->onOffTriggerRequest( true );
    IntercomNanoMessageClientHandler::createInstance()->makeOutGoingCall( phoneNo_ );
    bool status = IntercomAudioClientHandler::poGetIntercomAudioClientInstance()->acceptIntercomSource ();
    DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("acceptIntercomSource and sendActiveCallStatusSignal"));
    this->sendActiveCallStatusSignal();
  
	
	
}

void IntercomService::onGetPhoneStatusRequest (const ::boost::shared_ptr< GetPhoneStatusRequest >& request)
{

    if ( IntercomNanoMessageClientHandler::createInstance()->getPhoneStatus () == true )
    {
        DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService :onGetPhoneStatusRequest successfully processed"));

    }
}



void IntercomService::onCallActionRequest (const ::boost::shared_ptr< CallActionRequest >& request)
{

    int32 CallAction = request->getAction ();

    if ( CallAction == 1 ) // ACCEPT
    {
        DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : ACCEPT request "));
        //packdata ( 0x0105 );

        IntercomNanoMessageClientHandler::createInstance()->CallAction ( ACCEPT );

    }
    else if ( CallAction == 2 ) // REJECT
    {
        DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : REJECT request and sending audio off "));
        //packdata ( 0x0107 );
        IntercomNanoMessageClientHandler::createInstance()->CallAction ( REJECT );
        bool status = IntercomAudioClientHandler::poGetIntercomAudioClientInstance()->rejectIntercomAudioSource();
        DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("bsetRouteRequest off status"), DLT_BOOL ( status ));
		DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("onOffTriggerRequest SWITCH OFF request"));
		IntercomComponent::getInstance()->onOffTriggerRequest( false );
    }
}

void IntercomService::onGetAvailabilityRequest (const ::boost::shared_ptr< GetAvailabilityRequest >& request) 
{
	DLT_LOG(INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("IntercomService : onGetAvailabilityRequest "));
	IntercomNanoMessageClientHandler::createInstance()->getAvailabilityStatus ();
}

void IntercomService::sendIncomingCall ( int32 PhoneNumber )
{
    DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("sendIncomingCall to HMI with phoneNumber "), DLT_UINT ( (uint32_t)PhoneNumber ));
	
	DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING(" onOffTriggerRequest SWITCH ON request "));
	IntercomComponent::getInstance()->onOffTriggerRequest( true );
	
    sendIncomingCallSignal( PhoneNumber);
}

void IntercomService::sendNanoMessageError ( eNanoMessageError ErrorCode )
{
    DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("sendNanoMessageError to HMI with ErrorCode "), DLT_UINT ( (uint8_t) ErrorCode ));
    this->sendEventNanoMessageErrorStatusSignal ( (uint8_t) ErrorCode );
}

// config error

void IntercomService::sendConfigError ( eConfigError ErrorCode )
{
    DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("sendConfigError to HMI with ErrorCode "), DLT_UINT ( (uint8_t) ErrorCode ));
    this->sendEventInterComConfigErrorSignal ( ( uint8_t ) ErrorCode );
}

// RTP Error

void IntercomService::sendRTPError ( eRTPError ErrorCode )
{
    DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("sendRTPError to HMI with ErrorCode "), DLT_UINT ( (uint8_t) ErrorCode ));
    this->sendEventRTPErrorStatusSignal ( ( uint8_t ) ErrorCode );
}



void IntercomService::SendResponseAvailability ( uint8 available )
{
    DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("send Response Availibility "), DLT_UINT (  available ));
    this->sendRspIntercomAvailableSignal ( available );
}


void IntercomService::SendEventAvailability ( uint8 available )
{
	DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING("send Event Availibility "), DLT_UINT (  available ));
	this->sendEventIntercomAvailableSignal ( available );
}

void IntercomService::sendEventCanCellCall ()
{
	DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING(" sendEventCanCellCall "));
	IntercomComponent::getInstance()->onOffTriggerRequest( false );
	DLT_LOG( INTERCOM_SERVICE, DLT_LOG_INFO, DLT_CSTRING(" onOffTriggerRequest SWITCH OFF request "));
	this->sendCancelCallSignal ();
}



}//IntercomApp

