/****************************************************************************
/*****************************************************************************
* FILE 			: InterService.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: Intercom
*
* DESCRIPTION 	: This class creates the interfacing between HMI and Intercom App
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/06/2020     Initial version
*
****************************************************************************/
#if !defined(INTERCOM_ERROR_HANDLER_H)
#define INTERCOM_ERROR_HANDLER_H


typedef enum NanoMessageError
{
    No_ERROR_NANOMESSAGE,
    NANOMESSAGE_COMMUNICATION_ERROR,
    NANOMESSAGE_SENDMESSAGE_ERROR,
    NANOMESSAGE_RECEIVEMESSAGE_ERROR,
    NANOMESSAGE_UNAVAILABLE_ERROR,
    NANOMESSAGE_COMMUNICATION_LOST_ERROR
} eNanoMessageError;

typedef enum RTPError
{
    No_ERROR_RTP,
    RTP_FACTORY_FAILURE_ERROR,
    RTP_MAINLOOP_FAILURE_ERROR,
    RTP_RECEIVE_PLAYBACK_FAILURE_ERROR,
    RTP_SEND_PLAYBACK_FAILURE_ERROR,
    RTP_THREAD_FAILURE_ERROR,
    RTP_CLEAR_PIPELINE_ERROR,
    RTP_SEND_PIPELINE_PAUSED_ERROR,
    RTP_RECEIVE_PIPELINE_PAUSED_ERROR,
    RTP_SEND_PIPELINE_BUFFER_ERROR,
    RTP_RECEIVE_PIPELINE_BUFFER_ERROR,
    RTP_SEND_PIPELINE_EOS_ERROR,
    RTP_RECEIVE_PIPELINE_EOS_ERROR,
    RTP_SEND_PIPELINE_HOST_NOT_FOUND_ERROR,
    RTP_RECEIVE_PIPELINE_HOST_NOT_FOUND_ERROR,
    RTP_SEND_PIPELINE_ELEMENT_LINK_ERROR,
    RTP_RECEIVE_PIPELINE_ELEMENT_LINK_ERROR,
    RTP_SEND_PIPELINE_PARSE_ERROR,
    RTP_RECEIVE_PIPELINE_PARSE_ERROR,
    RTP_SEND_PIPELINE_STATE_CHANGE_ERROR,
    RTP_RECEIVE_PIPELINE_STATE_CHANGE_ERROR
} eRTPError;

typedef enum ConfigError
{
    No_ERROR_CONFIG,
    INTERCOM_CONFIG_OSAL_REGISTRY_READ_ERROR,
    INTERCOM_CONFIG_OSAL_REGISTRY_PARSE_ERROR,
    INTERCOM_CONFIG_AVROUTING_ADAPTER_PARSE_ERROR,
    INTERCOM_CONFIG_AVROUTING_ADAPTER_CMA_IP_NOT_FOUND_ERROR,
    INTERCOM_CONFIG_CCA_APP_REGISTRATION_ERROR,
    INTERCOM_CONFIG_AHL_APP_CREATION_ERROR,
    INTERCOM_CONFIG_OSAL_THREAD_FAILURE_ERROR
} eConfigError;


#endif // INTERCOM_ERROR_HANDLER_H
