
/*****************************************************************************
* FILE 			: IntercomAudioClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: Intercom
*
* DESCRIPTION 	: This class provides the client handler for ARL.
*
* AUTHOR 		: Monojit Chatterjee(CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 08/06/2016
****************************************************************************/
#ifndef _INTERCOM_AUDIO_CLIENT_HANDER_H
#define _INTERCOM_AUDIO_CLIENT_HANDER_H

#include "ARLService/AhlApp.h"
#include "AudioRouting.h"
#include <cstring>
#include <cstdlib>
#include <string>
#include <vector>
#include <queue>
#include <thread>
#include <memory>
#include <mutex>
#include <functional>
#include <condition_variable>

using namespace std;



namespace IntercomApp
{
class IntercomService;


class IntercomAudioClientHandler : public asf::core::ServiceAvailableIF
{
public:
    // Constructor
    IntercomAudioClientHandler ( );

    // Destructor
    virtual ~IntercomAudioClientHandler ( );

    //This method is used to load registry.
    void buildRegistry ( );

    // Get the instance of VDVoiceClientHandler.
    static IntercomAudioClientHandler* poGetIntercomAudioClientInstance();

    //Initial the DBUS service pointer for communicating with external third party navigation.
    void vInitDBUSServicePointer ( IntercomService* pDbusService );

    // Request to play Intercom Audio.
    tBool bPlayIntercomAudio ();

    // Request to abort Intercom Audio.
    tBool bStopIntercomAudio ( );

    //Test play or abort Intercom Audio via TTFis command.
    static void TraceCmd_vHandlerIntercomAudio (unsigned int uTTSActionType);

    virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);// {};

    virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);// {};

    static int injection_callback(uint32_t service_id, void *data, uint32_t length);

    bool getAudioChannelStatus ()
    {
        return _pARLHandler->getAudioChannelStatus ();
    }





    //reject audio allocation

    bool rejectIntercomAudioSource();

    bool acceptIntercomSource ();

private:
    // Static pointer of self-referential
    static IntercomAudioClientHandler* m_poIntercomAudioClient;
    bool initARL();

    AhlApp* _pAhlApp;
    AudioRouting* _pARLHandler;

    IntercomService* mIntercomService = nullptr;





};
}
#endif // _INTERCOM_AUDIO_CLIENT_HANDER_H
