
/*****************************************************************************
* FILE 			: IntercomAudioClientHandler.cpp
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: Intercom
*
* DESCRIPTION 	: This class provides the client handler for ARL.
*
* AUTHOR 		: Monojit Chatterjee(CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 08/06/2016
****************************************************************************/
//#include "sys_std_if.h"

#include "IntercomAudioClientHandler.h"
#include "DBusServer/IntercomService.h"
#include "Trace/IntercomApp_Trace.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		  TR_CLASS_INTERCOM_AUDIO_CLIENTHANDLER
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_INTERCOM
#define ETG_I_TTFIS_CMD_PREFIX            "INTERCOM_AUDIO_CLIENTHANDLER_"
#define ETG_I_FILE_PREFIX 				  Intercom::IntercomAudioClientHandler::
#include "trcGenProj/Header/IntercomAudioClientHandler.cpp.trc.h"
#endif

DLT_IMPORT_CONTEXT (INTERCOM_AUDIO_HANDLER);



using namespace placeholders ;

namespace IntercomApp
{

IntercomAudioClientHandler* IntercomAudioClientHandler::m_poIntercomAudioClient = NULL;


/*!
 *
 * \brief   Constructor
 *
 * \author  Monojit Chatterjee (CM/ECG5)
 *
 * \date    8/6/2016
 */
IntercomAudioClientHandler::IntercomAudioClientHandler()
{
    ETG_TRACE_USR4(("Constructor"));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler"));
    DLT_REGISTER_INJECTION_CALLBACK(INTERCOM_AUDIO_HANDLER, 4099 , IntercomAudioClientHandler::injection_callback );

    // ETG_I_REGISTER_FILE();
    ETG_I_REGISTER_FILE();
    m_poIntercomAudioClient = this;

    mIntercomService = IntercomService::createInstance();
    //m_poIntercomService = NULL;

    buildRegistry();

    amt_bInit();

    scd_init();

    _pAhlApp = new AhlApp(APP_INTERCOM);

    if (OSAL_NULL == _pAhlApp)
    {
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler OSAL_NULL"));

        ETG_TRACE_USR4(("_pAhlApp creation Failed."));
        mIntercomService->sendConfigError (  INTERCOM_CONFIG_OSAL_THREAD_FAILURE_ERROR) ;
    }
    else
    {

        bool status = _pAhlApp->bInitInstance(0, APP_INTERCOM, OSAL_ThreadWhoAmI());
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler bInitInstance status "), DLT_BOOL (status ));

        /*if (_pAhlApp->bInitInstance(0, APP_INTERCOM, OSAL_ThreadWhoAmI()) == FALSE)
        {
        	DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler bInitInstance failed"));
        	ETG_TRACE_USR4(("_pAhlApp InitInstance Failed."));
        }*/
    }

    if(OSAL_NULL != _pAhlApp)
    {

        _pARLHandler = OSAL_NEW AudioRouting(_pAhlApp);
        if (OSAL_NULL == _pARLHandler)
        {
            DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler AudioRouting failed"));
            ETG_TRACE_USR4(("_pARLHandler creation Failed."));
            mIntercomService->sendConfigError ( INTERCOM_CONFIG_AHL_APP_CREATION_ERROR ) ;
        }
    }




}


IntercomAudioClientHandler::~IntercomAudioClientHandler()
{
    ETG_TRACE_USR4(("~Destructor"));

    m_poIntercomAudioClient = NULL;
    //m_poIntercomService = NULL;

    if(NULL != _pAhlApp)
    {
        OSAL_DELETE _pAhlApp;
        _pAhlApp = NULL;
    }

    if(NULL != _pARLHandler)
    {
        OSAL_DELETE _pARLHandler;
        _pARLHandler = NULL;
    }

}
#if 1
/*!
* \brief   This method is used to load registry
*
* \param   void
*
* \retval  void
*
* \author  Monojit Chatterjee(CM/ECG5)
*
* \date    8/6/2016
*/
void IntercomAudioClientHandler::buildRegistry()
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("buildRegistry"));
    OSAL_tIODescriptor regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY, OSAL_EN_READWRITE);
    if (regHandle != OSAL_ERROR)
    {
        const char regFileName[] =  "/dev/root/opt/bosch/base/registry/procIntercom.reg";
        if ((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG, (tS32) regFileName)) == OSAL_OK)
        {
            DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("REGISTRY loaded "), DLT_CSTRING(regFileName) );
            ETG_TRACE_USR1(("REGISTRY loaded '%s'", regFileName));
        }
        else
        {
            DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("REGISTRY loading failed "), DLT_CSTRING(regFileName) );
            ETG_TRACE_ERR(("FAILED to load REGISTRY '%s'", regFileName));
            mIntercomService->sendConfigError ( INTERCOM_CONFIG_OSAL_REGISTRY_READ_ERROR ) ;
        }

        OSAL_s32IOClose(regHandle);
    }
}
#endif
/*!
*
* \brief   Get the instance of IntercomAudioClientHandler.
*
* \retval  IntercomAudioClientHandler*: The pointer of the IntercomAudioClientHandler.
*
* \author  Monojit Chatterjee (CM/ECG5)
*
* \date    8/6/2016
*/
IntercomAudioClientHandler* IntercomAudioClientHandler::poGetIntercomAudioClientInstance()
{
    return m_poIntercomAudioClient;
}

bool IntercomAudioClientHandler::rejectIntercomAudioSource()
{

    bool status =false ;
    if ( _pARLHandler->getAudioChannelStatus () == true )
    {
        status = _pARLHandler->bSetAudioRouteRequest(ARL_SRC_INTERCOM, ARL_EN_ISRC_ACT_OFF);
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bsetRouteRequest off status"), DLT_BOOL ( status ));
    }
    return status;
}


bool IntercomAudioClientHandler::acceptIntercomSource ()
{
    bool status =false ;
    if ( _pARLHandler->getAudioChannelStatus () == false  )
    {
        status = _pARLHandler->bSetAudioRouteRequest(ARL_SRC_INTERCOM, ARL_EN_ISRC_ACT_ON );
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("acceptIntercomSource bsetRouteRequest on status"), DLT_BOOL ( status ));
    }
    return status;
}

int IntercomAudioClientHandler::injection_callback(uint32_t service_id, void *data, uint32_t length)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback of vSetIntercomRouteRequest"));
    bool* info = (bool*)  data;
    ETG_TRACE_USR4(("IntercomAudioClientHandler::injection_callback() entered: "));
    IntercomAudioClientHandler *poClientTest = IntercomAudioClientHandler::poGetIntercomAudioClientInstance();
    AudioRouting *poAudioRoutingTest = AudioRouting::poGetAudioRoutingInstance();

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback") , DLT_BOOL (*info) );

    bool status = false;
	
    if ( service_id == 4099 )
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("service id 4099 intercom audioHandler") );

    if ( *info == true )
    {
        ETG_TRACE_USR4(("AudioRouting::injection_callback() bSetSourceAvailability: data"));
        status =  poAudioRoutingTest->bSetAudioRouteRequest(ARL_SRC_INTERCOM, ARL_EN_ISRC_ACT_ON);
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback of vSetIntercomRouteRequest ARL_EN_ISRC_ACT_ON"), DLT_BOOL ( status ));
    }
    else
    {

        status =  poAudioRoutingTest->bSetAudioRouteRequest(ARL_SRC_INTERCOM, ARL_EN_ISRC_ACT_OFF);
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback of vSetIntercomRouteRequest ARL_EN_ISRC_ACT_ON"), DLT_BOOL ( status ));
    }
	
	return (int)status ;

}

void IntercomAudioClientHandler::vInitDBUSServicePointer(IntercomService* pDbusService)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vInitDBUSServicePointer"));
    if(NULL == _pARLHandler)
    {
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vInitDBUSServicePointer null"));
        ETG_TRACE_USR4(("_pARLHandler is NULL."));
        return ;
    }

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("_pARLHandler->vInitDBUSServicePointer"));
    _pARLHandler->vInitDBUSServicePointer(pDbusService);


}



//ETG_I_CMD_DEFINE((TraceCmd_vHandlerIntercomAudio, "TraceCmd_vHandlerIntercomAudio %u %u", unsigned int))
void IntercomAudioClientHandler::TraceCmd_vHandlerIntercomAudio(unsigned int uTTSActionType)
{
    ETG_TRACE_USR4(("TraceCmd_vHandlerIntercomAudio: uTTSActionType=%u", uTTSActionType));

    IntercomAudioClientHandler *poIntercomAudioClientTest = IntercomAudioClientHandler::poGetIntercomAudioClientInstance();
    if (NULL == poIntercomAudioClientTest)
    {
        ETG_TRACE_USR4(("poIntercomAudioClientTest = NULL."));
        return;
    }
}

void IntercomAudioClientHandler::onAvailable(const boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange& state )
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler::onAvailable"));

}

void IntercomAudioClientHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange& state)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler::onUnavailable"));
}




bool IntercomAudioClientHandler::initARL()
{

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler::initARL"));
    bool status = _pAhlApp->bInitInstance(0, APP_INTERCOM, OSAL_ThreadWhoAmI());
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler::bInitInstance"));
    _pARLHandler = OSAL_NEW AudioRouting(_pAhlApp);
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("IntercomAudioClientHandler::AudioRouting"));
	return status;
}



}
