/****************************************************************************
/*****************************************************************************
* FILE 			: IntercomNanoMessageClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	:
*
* DESCRIPTION 	:
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/02/2020     Initial version
*
****************************************************************************/

#ifndef _AUDIO_ROUTING_H_
#define _AUDIO_ROUTING_H_

#include "DBusServer/IntercomService.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#define ARL_S_IMPORT_INTERFACE_ASF_STR
#include "audio_routing_asf_lib.h"
#include "application/intercom_gstreamer_app.hpp"
#include "IntercomService.h"

namespace IntercomApp
{
class IntercomService;

class AudioRouting : public arl_tclISource_ASF
{
public:
    //Constructor
    AudioRouting(ahl_tclBaseOneThreadApp* ahlApp);

    //Destructor
    virtual ~AudioRouting();

    //Get the instance of AudioRouting.
    static AudioRouting* poGetAudioRoutingInstance();

    //Initial the DBUS service pointer for communicating with external third party navigation.
    void vInitDBUSServicePointer(IntercomService* pDbusService);

    //Requests a new audio route without timer.
    virtual void vSetIntercomRouteRequest(bool bOpenChannel);

    //CALLED BY AUDIO-ROUTING-LIB: Application specific function on Source Activity start.
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum,  tU16 SubSource, const arl_tSrcActivity& rfcoSrcActivity);

    //CALLED BY AUDIO-ROUTING-LIB: Application specific function after Allocate is processed.
    virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);

    //CALLED BY AUDIO-ROUTING-LIB: Application specific function after DeAllocate is processed.
    virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);

    //CALLED BY AUDIO-ROUTING-LIB: Application specific function on mute start.
    virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState muteState);
	
		// This interface is used for BT priority handling , This callback happens when ARL reject RouteRequest
	virtual tBool bOnAudioRouteRequestReject(arl_tenSource enSource, tU16 SubSource);

    //This method is used to notify the activity off result to ARL.
    void vNotifyActivityOffResult();

    // set Audio channel
    void setAudioChannelStatus ( bool AudioChannelStatus_ )
    {
        AudioChannelStatus =     AudioChannelStatus_;
    }

    // get the channel status
    bool getAudioChannelStatus ()
    {
        return AudioChannelStatus;
    }

    //virtual tBool bSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource = 0);

    //Request a new audio route for navigation announcement via TTFis command.
    static void TraceCmd_SetIntercomRouteRequest(bool bOpenChannel);

    static int injection_callback(uint32_t service_id, void *data, uint32_t length);

    virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);

    //Audio channel Status flag
    bool _bAudioChannelStatus = false ;

protected:
    //Audio channel block flag
    bool _bChannelBlocked;

    bool AudioChannelStatus = false;

private:

    //This method is used to inform the Intercom Routerequest result.
    void InformIntercomRouteStatus(const uint8 u8NaviVoiceStatus);
    //Static pointer of self-referential
    static AudioRouting* m_poAudioRouting;

    //True : audio channel is closed by Wrapper itself
    //False: the audio channel is off, due to high priority APP comes, such as BTPhone.
    bool m_isChannelClosedByWrapper;

    //The DBUS service for third party navigation
    IntercomService* mIntercomService = nullptr;

    InterComAudioProcessing* m_InterComAudioProcessing;


};
}
#endif // _AUDIO_ROUTING_H_
