/**************************************************************************//**
* \file     clServerProperty.h
*
*           See .cpp file for description.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clServerProperty_h
#define clServerProperty_h


#include "clFunction.h"

#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
#include "stl_pif.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "fi_msgfw_if.h"


class clServerProperty : public clFunction
{
   public:
      virtual ~clServerProperty();
      clServerProperty(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler);
      virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg);

   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg) = 0;
      virtual tVoid vSet(amt_tclServiceData* poInMsg) = 0;
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg) = 0;
      tVoid vStatus(fi_tclTypeBase& oPayload);

   private:
      /* +++ Enter your internal Data here */
      ahl_tclNotificationTable* m_poNotificationTable;
      tU16 m_u16DestAppID;
      tU16 m_u16RegisterID;
      tU16 m_u16RequestCmdCtr;
      tU32 m_u32RequestType;
      tVoid vAddToNotificationTable(amt_tclServiceData* poInMessage);
      tVoid vRemoveFromNotificationTable(amt_tclServiceData* poInMessage);
      tVoid vStatusToRegisteredClients(fi_tclTypeBase& oOutData);
      tVoid vSaveResponseParameters(amt_tclServiceData* poInMessage);

};


#endif
