/**************************************************************************//**
* \file     clServerProperty.cpp
*
*           Base class for CCA property implementations.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "clServerProperty.h"
//#include "SdsHmi_Trace.h"

/*#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define //ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCA_FW
#include "trcGenProj/Header/clServerProperty.cpp.trc.h"
#endif*/


/**************************************************************************//**
* Destructor
******************************************************************************/
clServerProperty::~clServerProperty()
{
   m_poNotificationTable = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clServerProperty::clServerProperty(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler)
   : clFunction(u16FunctionID, poCCAhandler)
   , m_u16DestAppID(AMT_C_U32_BASEMSG_SOURCEAPPID)
   , m_u16RegisterID(0)
   , m_u16RequestCmdCtr(0)
   , m_u32RequestType(AMT_C_U8_CCAMSG_OPCODE_UPREG)
{
   m_poNotificationTable = OSAL_NEW ahl_tclNotificationTable(1);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vHandleMessage(amt_tclServiceData* poInMsg)
{
   if (poInMsg != NULL)
   {
      //ETG_TRACE_USR1(("rx appid=%04x function=%04x regid=%d opcode=%d cmdctr=%d ", poInMsg->u16GetSourceAppID(), poInMsg->u16GetFunctionID(), poInMsg->u16GetRegisterID(), poInMsg->u8GetOpCode(), poInMsg->u16GetCmdCounter()));
      switch (poInMsg->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_SET:
            vSaveResponseParameters(poInMsg);
            vSet(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_GET:
            vSaveResponseParameters(poInMsg);
            vGet(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
            vAddToNotificationTable(poInMsg);
            vUpreg(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
            vRemoveFromNotificationTable(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
// TODO: jnd2hi activate code again
//            m_poCCAhandler->vSendErrorMessage(
//               poInMsg->u16GetFunctionID(),
//               m_poCCAhandler->m_u16InvalidOpCodeError);
            break;

         default:
            break;
      }
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vAddToNotificationTable(amt_tclServiceData* poInMessage)
{
   if ((poInMessage != NULL) && (m_poNotificationTable != NULL))
   {
      (tVoid)m_poNotificationTable->bAddNotification(
         poInMessage->u16GetFunctionID(),
         poInMessage->u16GetSourceAppID(),
         poInMessage->u16GetRegisterID(),
         TRUE,
         poInMessage->u16GetCmdCounter(),
         poInMessage->u16GetSourceSubID());
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vRemoveFromNotificationTable(amt_tclServiceData* poInMessage)
{
   if ((poInMessage != NULL) && (m_poNotificationTable != NULL))
   {
      (tVoid)m_poNotificationTable->bRemoveNotification(
         poInMessage->u16GetFunctionID(),
         poInMessage->u16GetSourceAppID(),
         poInMessage->u16GetRegisterID(),
         TRUE,
         poInMessage->u16GetCmdCounter(),
         poInMessage->u16GetSourceSubID());
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vSaveResponseParameters(amt_tclServiceData* poInMessage)
{
   if (poInMessage != NULL)
   {
      m_u16DestAppID = poInMessage->u16GetSourceAppID();
      m_u16RegisterID = poInMessage->u16GetRegisterID();
      m_u32RequestType = poInMessage->u8GetOpCode();
      m_u16RequestCmdCtr = poInMessage->u16GetCmdCounter();
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatus(fi_tclTypeBase& oOutData)
{
   if (m_u32RequestType == AMT_C_U8_CCAMSG_OPCODE_GET)
   {
      vSendMessage(
         m_u16DestAppID,
         m_u16RequestCmdCtr,
         m_u16RegisterID,
         oOutData,
         u16GetFunctionID(),
         AMT_C_U8_CCAMSG_OPCODE_STATUS);
      m_u32RequestType = AMT_C_U8_CCAMSG_OPCODE_UPREG;
   }
   else if (m_u32RequestType == AMT_C_U8_CCAMSG_OPCODE_SET)
   {
      vSendMessage(
         m_u16DestAppID,
         m_u16RequestCmdCtr,
         m_u16RegisterID,
         oOutData,
         u16GetFunctionID(),
         AMT_C_U8_CCAMSG_OPCODE_STATUS);
      m_u32RequestType = AMT_C_U8_CCAMSG_OPCODE_UPREG;
      vStatusToRegisteredClients(oOutData);
   }
   else
   {
      vStatusToRegisteredClients(oOutData);
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatusToRegisteredClients(fi_tclTypeBase& oOutData)
{
   if (m_poNotificationTable != NULL)
   {
      ahl_tNotification* pNotify = m_poNotificationTable->poGetNotificationList(u16GetFunctionID());
      for ( ; pNotify != OSAL_NULL; pNotify = pNotify->pNext)
      {
         vSendMessage(
            pNotify->u16AppID,
            pNotify->u16CmdCounter,
            pNotify->u16RegisterID,
            oOutData,
            u16GetFunctionID(),
            AMT_C_U8_CCAMSG_OPCODE_STATUS);
      }
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}
