/**************************************************************************//**
* \file     clFunction.h
*
*           Base class for CCA functions.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clFunction_h
#define clFunction_h


#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_msgfw_if.h"


class clFunction
{
   public:
      virtual ~clFunction();
      clFunction(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler);
      virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg) = 0;
      tU16 u16GetFunctionID(tVoid);

   protected:
      ahl_tclBaseOneThreadService* m_poCCAhandler;
      tVoid vSendMessage(tU16 u16DestAppID, tU16 u16CmdCtr, tU16 u16RegisterId, fi_tclTypeBase& oOutData, tU16 u16Fid, tU8 u8OpCode);
      tVoid vSendEmptyMessage(tU16 u16DestAppID, tU16 u16CmdCtr, tU16 u16RegisterId, tU16 u16Fid, tU8 u8Opcode);
      tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData);
      tVoid vSendErrorMessage(tU16 u16DestAppID, tU16 u16CmdCtr, tU16 u16RegisterId, tU16 u16Errorcode);

   private:
      tU16 m_u16FunctionID;
      tU16 getMajorVersion();
};


#endif
