/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
***************************************************************************/
#include "AhlService.h"


//DEFINE_CLASS_LOGGER_AND_LEVEL("sdshmi/Sds2HmiServer/framework", AhlService, Info);


AhlService::AhlService(ahl_tclBaseOneThreadApp* app, tU16 serviceId, tU16 majorVersion, tU16 minorVersion)
: ahl_tclBaseOneThreadService(app, serviceId, majorVersion, minorVersion)
{
    //LOG_INFO("ahl service created");
}


AhlService::~AhlService()
{
}


tVoid AhlService::vMyDispatchMessage(amt_tclServiceData* message)
{
    std::list<clFunction*>::iterator iter = _functions.begin();
    while (iter != _functions.end())
    {
        clFunction* function = *iter;
        if (message->u16GetFunctionID() == function->u16GetFunctionID())
        {
            //LOG_INFO("service data message dispatched to function 0x%04x", function->u16GetFunctionID());
            function->vHandleMessage(message);
            return;
        }
        iter++;
    }
    //LOG_WARN("service data message not handled");
}


void  AhlService::vAddFunction(clFunction* function)
{
    _functions.push_back(function);
}
