/*!
*******************************************************************************
* \file              ihl_tclThreadable.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Thread Utility Class - Threads as objects
*                    Command Object Model Thread class
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 06.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLTHREADABLE_H_
#define IHL_TCLTHREADABLE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace thread {

/*! 
 * \class ihl_tclThreadable
 * \brief Abtract Command Class based consisting of pure virtual functions.
 * @TODO - fill in details 
 *
 */

class ihl_tclThreadable
{   
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclThreadable::ihl_tclThreadable()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclThreadable() {};
   
   /***************************************************************************
   ** FUNCTION:  virtual ihl_tclThreadable::~ihl_tclThreadable()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclThreadable() {};

   /***************************************************************************
   ** FUNCTION:  virtual tVoid ihl_tclThreadable::vExecute(OSAL_tEventMask ev..
   ***************************************************************************/
   /*!
    * \brief   Command interface to execute the commands/ perform action on 
    *          event
    * \param   [cevtEvent]: (I) Event mask required for execution of the command
    * \retval  NONE
    * \note    This is a pure virtual function which has to be overloaded in the
    *          derived class where the implementation will reside.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vExecute(const OSAL_tEventMask cevtEvent) = 0;
   
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclThreadable::ihl_tclThreadable(const ihl_tclThreadable..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoThreadable]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared private to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclThreadable(const ihl_tclThreadable &rfcoThreadable);

   /***************************************************************************
   ** FUNCTION:  ihl_tclThreadable& ihl_tclThreadable::operator=(const ihl_tc..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoThreadable]: (I) Const reference to object to be copied
    * \retval  [ihl_tclThreadable&]: Reference to this pointer.
    * \note    Assignment operator is declared private to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclThreadable& operator=(const ihl_tclThreadable &rfcoThreadable);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/  

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ihl_tclThreadable

   }  // namespace thread
}  // namespace ihl

#endif   // #ifndef IHL_TCLTHREADABLE_H_

// <EOF>
