/*!
*******************************************************************************
* \file              ihl_tclMsgQThreadable.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Thread Utility Class - Threads as objects
*                    Command Object Model Thread class
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 23.06.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLMSGQTHREADABLE_H_
#define IHL_TCLMSGQTHREADABLE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#include "ihl_tclThreadable.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace thread {

/*! 
 * \struct ihl_rMessage 
 * \brief Data structure to hold the message - contains message buffer + size
 */

typedef struct ihl_rMessage
{
   tPU8 m_pu8Buffer;    ///< Message Buffer
   tU32 m_u32Length;    ///< Message Buffer length
}ihl_tMessage;

/*! 
 * \class ihl_tclMsgQThreadable
 * \brief Abtract Command Class based consisting of pure virtual functions.
 * @TODO - fill in details 
 *
 */

class ihl_tclMsgQThreadable : public ihl_tclThreadable
{   
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /// Using the "Name injection" to enable the compiler's overload resolution 
   /// algorithm to see the base class methods.
   using ihl_tclThreadable::vExecute;

   /***************************************************************************
   ** FUNCTION:  ihl_tclMsgQThreadable::ihl_tclMsgQThreadable()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclMsgQThreadable() {};
   
   /***************************************************************************
   ** FUNCTION:  virtual ihl_tclMsgQThreadable::~ihl_tclMsgQThreadable()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclMsgQThreadable() {};

   /***************************************************************************
   ** FUNCTION:  virtual tVoid ihl_tclMsgQThreadable::vExecute(tPCU8 pcou8Msg..
   ***************************************************************************/
   /*!
    * \brief   Command interface to execute the commands/ perform action on 
    *          message from the message queue
    * \param   [poMessage]:    (->I) IHL Message
    * \retval  NONE
    * \note    - This is a pure virtual function which has to be overloaded in 
    *          the derived class where the implementation will reside.
    *          - Along with message processing the application overriding this 
    *          function should make sure to free the memory allocated for the 
    *          message.
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   /*lint ! -e1411 PQM_authorized_256
   Warning: Member with different signature hides virtual member 'ihl::thread::ihl_tclThreadable::vExecute(unsigned long)' 
   (line 90, file components\infotainment\ihl\thread\include\ihl_tclThreadable.h)*/
   virtual tVoid vExecute(ihl_tMessage* poMessage) = 0;
   
   /***************************************************************************
   ** FUNCTION:  virtual tPVoid ihl_tclMsgQThreadable::poGetMsgBuffer() const
   ***************************************************************************/
   /*!
    * \brief   Get pointer to the message buffer.
    * \param   NONE
    * \retval  [ihl_tMessage*] Pointer to message buffer.
    * \note    This is a pure virtual function which has to be overloaded in the
    *          derived class where the implementation will reside.
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ihl_tMessage* poGetMsgBuffer() const = 0;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclMsgQThreadable::ihl_tclMsgQThreadable(const ihl_tclMs..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoThreadable]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared private to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclMsgQThreadable(const ihl_tclMsgQThreadable &rfcoThreadable);

   /***************************************************************************
   ** FUNCTION:  ihl_tclMsgQThreadable& ihl_tclMsgQThreadable::operator=(con..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoThreadable]: (I) Const reference to object to be copied
    * \retval  [ihl_tclMsgQThreadable&]: Reference to this pointer.
    * \note    Assignment operator is declared private to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 23.06.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclMsgQThreadable& operator=(const ihl_tclMsgQThreadable &rfcoThreadable);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/  

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ihl_tclMsgQThreadable : public ihl_tclThreadable

   }  // namespace thread
}  // namespace ihl

#endif   // #ifndef IHL_TCLMSGQTHREADABLE_H_

// <EOF>
