/*!
*******************************************************************************
* \file              ihl_tclDevHandler.cpp
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Device Handler - Exception safe Device handler
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 06.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ihl_tclDevHandler.h"

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace io {

/******************************************************************************
** FUNCTION:  ihl_tclDevHandler::ihl_tclDevHandler(tCString szDevice)
******************************************************************************/

ihl_tclDevHandler::ihl_tclDevHandler(tCString szDevice)
:ihl_tclDirHandler(szDevice)
{} // ihl_tclDevHandler::ihl_tclDevHandler(tCString szDevice)

/******************************************************************************
** FUNCTION:  virtual ihl_tclDevHandler::~ihl_tclDevHandler()
******************************************************************************/

/*virtual*/
ihl_tclDevHandler::~ihl_tclDevHandler()
{} // ihl_tclDevHandler::~ihl_tclDevHandler()

/******************************************************************************
** FUNCTION:  virtual tU32 ihl_tclDevHandler::u32GetFreeSize()
******************************************************************************/

/*virtual*/
tU32 ihl_tclDevHandler::u32GetFreeSize()
{
   OSAL_trIOCtrlDeviceSize oFreeDevSize   =  {0, 0};

   if(OSAL_NULL != m_pioCtrlDir)
   {
      m_u32ErrorCode =  OSAL_E_NOERROR;

      if(OSAL_ERROR == OSAL_s32IOControl(m_pioCtrlDir->fd, OSAL_C_S32_IOCTRL_FIOFREESIZE, (intptr_t)(&oFreeDevSize)))
      {
         // Query & Set the error code.
         m_u32ErrorCode =  OSAL_u32ErrorCode(); 
      }  // if(OSAL_ERROR == OSAL_s32IOControl(m_pioCtrlDir->fd, OSAL_C_S32_I..
   }  // if(OSAL_NULL != m_pioCtrlDir)
   
   return oFreeDevSize.u32Low;
}  // tU32 ihl_tclDevHandler::u32GetFreeSize()

/******************************************************************************
** FUNCTION:  virtual tU32 ihl_tclDevHandler::u32GetTotalSize() const
******************************************************************************/

/*virtual*/
tU32 ihl_tclDevHandler::u32GetTotalSize()
{
   OSAL_trIOCtrlDeviceSize oTotalDevSize   =  {0, 0};

   if(OSAL_NULL != m_pioCtrlDir)
   {
      m_u32ErrorCode =  OSAL_E_NOERROR;
      
      if(OSAL_ERROR == OSAL_s32IOControl(m_pioCtrlDir->fd, OSAL_C_S32_IOCTRL_FIOTOTALSIZE, (intptr_t)(&oTotalDevSize)))
      {
         // Query & Set the error code.
         m_u32ErrorCode =  OSAL_u32ErrorCode();
      }  // if(OSAL_ERROR == OSAL_s32IOControl(m_pioCtrlDir->fd, OSAL_C_S32_I..
   }  // if(OSAL_NULL != m_pioCtrlDir)

   return oTotalDevSize.u32Low;

}  // tU32 ihl_tclDevHandler::u32GetTotalSize()

   }  // namespace io
}  // namespace ihl

///////////////////////////////////////////////////////////////////////////////

// <EOF>
