/*!
********************************************************************************
* \file              ihl_if.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Interface header
*  - NOTE:           DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE
*  - COPYRIGHT:      &copy; 2010 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 30.06.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - New namespace exported.
*
* \date 17.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifdef IHL_S_IMPORT_INTERFACE_GENERIC
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_GENERIC
      #define IHL_S_ALREADY_INCLUDE_GENERIC

      // All Includes required for IHL
      #define IHL_S_IMPORT_INTERFACE_BUFFER
      #define IHL_S_IMPORT_INTERFACE_FI_HELPERS
      #define IHL_S_IMPORT_INTERFACE_LOOPBACK
      #define IHL_S_IMPORT_INTERFACE_THREAD
      #define IHL_S_IMPORT_INTERFACE_IO
      #define IHL_S_IMPORT_INTERFACE_TASK
      #define IHL_S_IMPORT_INTERFACE_FG
      #define IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES
      #define IHL_S_IMPORT_INTERFACE_XML

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_GENERIC
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_GENERIC


#ifdef IHL_S_IMPORT_INTERFACE_BUFFER
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_BUFFER
      #define IHL_S_ALREADY_INCLUDE_BUFFER
      
      // Includes for the classes in namespace ihl::buffer
      #include "../../infotainment/ihl/buffer/include/ihl_tclRawData.h"

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_BUFFER
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_BUFFER

#ifdef IHL_S_IMPORT_INTERFACE_FI_HELPERS
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_FI_HELPERS
      #define IHL_S_ALREADY_INCLUDE_FI_HELPERS
      
      // Includes for the classes in namespace ihl::fi_helpers
      #include "../../infotainment/ihl/fi_helpers/include/ihl_tclFiObjHandler.h"
      #include "../../infotainment/ihl/fi_helpers/include/ihl_tclFIVisitorMsgExtractor.h"
      #include "../../infotainment/ihl/fi_helpers/include/ihl_tclXFiObjHandler.h"
      #include "../../infotainment/ihl/fi_helpers/include/ihl_tclFiString.h"

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_FI_HELPERS
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_FI_HELPERS


#ifdef IHL_S_IMPORT_INTERFACE_LOOPBACK
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_LOOPBACK
      #define IHL_S_ALREADY_INCLUDE_LOOPBACK
      
      // Includes for the classes in namespace ihl::loopback
      #include "../../infotainment/ihl/loopback/include/ihl_tclTraceCmdFunctor.h"
      #include "../../infotainment/ihl/loopback/include/ihl_tclTraceStreamable.h"

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_LOOPBACK
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_LOOPBACK

#ifdef IHL_S_IMPORT_INTERFACE_IO
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_IO
      #define IHL_S_ALREADY_INCLUDE_IO
      
      // Includes for the classes in namespace ihl::io
      #include "../../infotainment/ihl/io/include/ihl_tclDevHandler.h"
      #include "../../infotainment/ihl/io/include/ihl_tclDirHandler.h"
      #include "../../infotainment/ihl/io/include/ihl_tclFileHandler.h"

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_IO
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_IO

#ifdef IHL_S_IMPORT_INTERFACE_FG
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_FG
      #define IHL_S_ALREADY_INCLUDE_FG
      
      #if (OSAL_OS == OSAL_TENGINE)

         #ifndef IHL_S_IMPORT_INTERFACE_TASK
         #define IHL_S_IMPORT_INTERFACE_TASK
         #endif

         #ifndef IHL_S_IMPORT_INTERFACE_THREAD
         #define IHL_S_IMPORT_INTERFACE_THREAD
         #endif

         #ifndef IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES
         #define IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES
         #endif

          // Includes for the classes in namespace ihl::filtergraph
         #include "../../infotainment/ihl/filtergraph/include/ihl_tclFgTaskable.h"
         #include "../../infotainment/ihl/filtergraph/include/ihl_tclFgThreadable.h"

      #endif   // #if (OSAL_OS == OSAL_TENGINE)

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_FG
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_FG

#ifdef IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_FG_MESSAGE_FI_TYPES
      #define IHL_S_ALREADY_INCLUDE_FG_MESSAGE_FI_TYPES
      
      #if (OSAL_OS == OSAL_TENGINE)

         // Includes for the classes in namespace ihl::filtergraph
         #include "../../infotainment/ihl/filtergraph/include/ihl_FGMsgTypes.h"

      #endif   // #if (OSAL_OS == OSAL_TENGINE)

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_FG_MESSAGE_FI_TYPES
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES

#ifdef IHL_S_IMPORT_INTERFACE_TASK
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_TASK
      #define IHL_S_ALREADY_INCLUDE_TASK
      
      #if (OSAL_OS == OSAL_TENGINE)

         // Includes for the classes in namespace ihl::task
         #include "../../infotainment/ihl/task/include/ihl_tclTask.h"
         #include "../../infotainment/ihl/task/include/ihl_tclTaskable.h"

      #endif   // #if (OSAL_OS == OSAL_TENGINE)

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_TASK
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_TASK

#ifdef IHL_S_IMPORT_INTERFACE_XML
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_XML
      #define IHL_S_ALREADY_INCLUDE_XML
      
      #if (OSAL_OS == OSAL_TENGINE)

         // Includes for the classes in namespace ihl::xml
         #include "../../infotainment/ihl/xml/include/ihl_tclXmlable.h"
         #include "../../infotainment/ihl/xml/include/ihl_tclXmlDocument.h"
         #include "../../infotainment/ihl/xml/include/ihl_tclXmlReader.h"

      #endif   // #if (OSAL_OS == OSAL_TENGINE)

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_XML
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_XML

#ifdef IHL_S_IMPORT_INTERFACE_THREAD
   // Protection against double include of the interface.
   #ifndef IHL_S_ALREADY_INCLUDE_THREAD
      #define IHL_S_ALREADY_INCLUDE_THREAD
      
      // Includes for the classes in namespace ihl::thread
      #include "../../infotainment/ihl/thread/include/ihl_tclThreadable.h"
      #include "../../infotainment/ihl/thread/include/ihl_tclMsgQThreadable.h"
      #include "../../infotainment/ihl/thread/include/ihl_tclThreader.h"
      #include "../../infotainment/ihl/thread/include/ihl_tclMsgQThreader.h"

   #endif   // #ifndef IHL_S_ALREADY_INCLUDE_THREAD
#endif   // #ifdef IHL_S_IMPORT_INTERFACE_THREAD

#if !(defined IHL_S_IMPORT_INTERFACE_GENERIC || \
      defined IHL_S_IMPORT_INTERFACE_BUFFER || \
      defined IHL_S_IMPORT_INTERFACE_FI_HELPERS || \
      defined IHL_S_IMPORT_INTERFACE_LOOPBACK || \
      defined IHL_S_IMPORT_INTERFACE_IO || \
      defined IHL_S_IMPORT_INTERFACE_THREAD || \
      defined IHL_S_IMPORT_INTERFACE_TASK || \
      defined IHL_S_IMPORT_INTERFACE_FG || \
      defined IHL_S_IMPORT_INTERFACE_FG_MESSAGE_FI_TYPES || \
      defined IHL_S_IMPORT_INTERFACE_XML)
   #pragma message ( "You have to define an interface for the component: IHL." ) 
#endif

////////////////////////////////////////////////////////////////////////////////
// <EOF>
