/*!
*******************************************************************************
* \file              ihl_tclFiString.cpp
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Extended Fi string class, with extended deep copy 
*                    capabilities.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 06.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ihl_tclFiString.h"

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {


      namespace midw_fi {

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString()
******************************************************************************/

ihl_tclFiString::ihl_tclFiString()
:midw_fi_tclString()
{} // ihl_tclFiString::ihl_tclFiString()

/******************************************************************************
** FUNCTION:  ihl_tclFiString::~ihl_tclFiString()
******************************************************************************/

/*virtual*/
ihl_tclFiString::~ihl_tclFiString()
{
   if(OSAL_NULL != szValue)
   {
   OSAL_DELETE[] szValue;
   szValue = OSAL_NULL;
   }

} // ihl_tclFiString::~ihl_tclFiString()

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &c..
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &rfcoFiString)
:midw_fi_tclString()
{
   tBool bRetVal = bSet(rfcoFiString.szValue, midw_fi_tclString::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &rfcoFiString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const midw_fi_tclString &c..
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(const midw_fi_tclString &rfcoFiString)
:midw_fi_tclString()
{
   tBool bRetVal = bSet(rfcoFiString, midw_fi_tclString::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(const midw_fi_tclString &rfcoFiString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(tCString coszString)
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(tCString coszString)
:midw_fi_tclString()
{
   tBool bRetVal = bSet(coszString, midw_fi_tclString::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(tCString coszString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclFiS...)
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclFiString &rfcoFiString)
{
   // Identity Test - Self assignment test.
   if (this != &rfcoFiString)
   {
      tBool bRetVal = bSet(rfcoFiString.szValue, midw_fi_tclString::FI_EN_UTF8);
      NORMAL_M_ASSERT(TRUE == bRetVal);
   }  // if (this != &rfcoFiString)
   // Return reference to the this pointer
   return *this;

}  // ihl_tclFiString& ihl_tclFiString::operator =(const ihl_tclFiString &cr..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tc..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tclFiString &rfcoFiString)
{
   vStringConCat(rfcoFiString.szValue);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tclFiString &cr..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const midw_tc..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(const midw_fi_tclString &rfcoFiString)
{
   vStringConCat(rfcoFiString.szValue);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(const midw_fi_tclString &r..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszS..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszString)
{
   vStringConCat(coszString);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszString)

/******************************************************************************
** FUNCTION:  tVoid ihl_tclFiString::vStringConCat(tCString coszString)
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vStringConCat(tCString coszString)
{
   tU32 u32StrLen = 1;     // Null character length.

   if(OSAL_NULL != szValue)
   {
      u32StrLen += OSAL_u32StringLength(szValue);
   }  // if(OSAL_NULL != szValue)
   
   if(OSAL_NULL != coszString)
   {
     u32StrLen += OSAL_u32StringLength(coszString);
   }  // if(OSAL_NULL != coszString)

   tString szString = OSAL_NEW tChar[u32StrLen];

   if(OSAL_NULL != szString)
   {
      // Memset the string.
      (tVoid)OSAL_pvMemorySet(szString, 0, u32StrLen);

      if(OSAL_NULL != szValue)
      {
         // Copy the existing string to temporary string.
         (tVoid)OSAL_szStringNCopy(szString, szValue, OSAL_u32StringLength(szValue));
      }  // if(OSAL_NULL != szValue)
      
      if(OSAL_NULL != coszString)
      {
         // Concatenate the existing and incoming string.
         (tVoid)OSAL_szStringNConcat(szString, coszString, OSAL_u32StringLength(coszString));
      }  // if(OSAL_NULL != coszString)

      // Free the existing string and assign the pointer
      OSAL_DELETE [] szValue;
      
      // Assign the concatenated string.
      szValue  =  szString;
   }  // if(OSAL_NULL != szValue)
}  // tVoid ihl_tclFiString::vStringConCat(tCString coszString)

/******************************************************************************
** FUNCTION: tVoid ihl_tclFiString::vClone(midw_fi_tclString &rfoString...)
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vClone(midw_fi_tclString &rfoString) const
{
   // Free the existing FI string if any, to avoid mem leaks ;-)
   rfoString.vDestroy();
   
   // Get the string by cloning the tCString 
   vClone(rfoString.szValue);

}  // tVoid ihl_tclFiString::vClone(midw_fi_tclString &rfoString) const

/******************************************************************************
** FUNCTION: tVoid ihl_tclFiString::vClone(tString &rfszString) const
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vClone(tString &rfszString) const
{
   if(OSAL_NULL != rfszString)
   {
      OSAL_DELETE [] rfszString;
      rfszString  =  OSAL_NULL;
   }  // if(OSAL_NULL != rfszString)

   rfszString  =  szGet(midw_fi_tclString::FI_EN_UTF8);  // Use fi string get

}  // tVoid ihl_tclFiString::vClone(tString &rfszString) const

/******************************************************************************
** FUNCTION: tVoid ihl_tclFiString::vClone(tCString &rfszString) const
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vClone(tCString &rfszString) const
{
   if(OSAL_NULL != rfszString)
   {
      OSAL_DELETE [] rfszString;
      rfszString  =  OSAL_NULL;
   }  // if(OSAL_NULL != rfszString)

   rfszString  =  szGet(midw_fi_tclString::FI_EN_UTF8);  // Use fi string get

}  // tVoid ihl_tclFiString::vClone(tString &rfszString) const

      }  // namespace midw_fi

      namespace most_fi {

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString()
******************************************************************************/

ihl_tclFiString::ihl_tclFiString()
:most_fi_tcl_String()
{} // ihl_tclFiString::ihl_tclFiString()

/******************************************************************************
** FUNCTION:  ihl_tclFiString::~ihl_tclFiString()
******************************************************************************/

/*virtual*/
ihl_tclFiString::~ihl_tclFiString()
{
   if(OSAL_NULL != szValue)
   {
      OSAL_DELETE [] szValue;
	  szValue     =     OSAL_NULL;
   }

} // ihl_tclFiString::~ihl_tclFiString()

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &c..
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &rfcoFiString)
:most_fi_tcl_String()
{
   tBool bRetVal = bSet(rfcoFiString.szValue, most_fi_tcl_String::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &rfcoFiString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const most_fi_tcl_String &c..
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(const most_fi_tcl_String &rfcoFiString)
:most_fi_tcl_String()
{
   tBool bRetVal = bSet(rfcoFiString.szValue, most_fi_tcl_String::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(const most_fi_tcl_String &rfcoFiString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString::ihl_tclFiString(tCString coszString)
******************************************************************************/

ihl_tclFiString::ihl_tclFiString(tCString coszString)
:most_fi_tcl_String()
{
   tBool bRetVal = bSet(coszString, most_fi_tcl_String::FI_EN_UTF8);
   NORMAL_M_ASSERT(TRUE == bRetVal);
}  // ihl_tclFiString::ihl_tclFiString(tCString coszString)

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclFiS...)
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclFiString &rfcoFiString)
{
   // Identity Test - Self assignment test.
   if (this != &rfcoFiString)
   {
      tBool bRetVal = bSet(rfcoFiString.szValue, most_fi_tcl_String::FI_EN_UTF8);
      NORMAL_M_ASSERT(TRUE == bRetVal);
   }  // if (this != &rfcoFiString)
   // Return reference to the this pointer
   return *this;

}  // ihl_tclFiString& ihl_tclFiString::operator =(const ihl_tclFiString &cr..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tc..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tclFiString &rfcoFiString)
{
   vStringConCat(rfcoFiString.szValue);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tclFiString &cr..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const midw_tc..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(const most_fi_tcl_String &rfcoFiString)
{
   vStringConCat(rfcoFiString.szValue);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(const most_fi_tcl_String &r..

/******************************************************************************
** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszS..
******************************************************************************/

ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszString)
{
   vStringConCat(coszString);
   return (*this);
}  // ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszString)

/******************************************************************************
** FUNCTION:  tBool ihl_tclFiString::operator !=(const most_fi_tcl_String &rf..
******************************************************************************/

tBool ihl_tclFiString::operator !=(const most_fi_tcl_String &rfcoFiString) const
{
   return(!(*this == rfcoFiString));
}  // tBool ihl_tclFiString::operator !=(const most_fi_tcl_String &rfcoFiStrin..

/******************************************************************************
** FUNCTION:  tVoid ihl_tclFiString::vStringConCat(tCString coszString)
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vStringConCat(tCString coszString)
{
   tU32 u32StrLen = 1;     // Null character length.

   if(OSAL_NULL != szValue)
   {
      u32StrLen += OSAL_u32StringLength(szValue);
   }  // if(OSAL_NULL != szValue)
   
   if(OSAL_NULL != coszString)
   {
     u32StrLen += OSAL_u32StringLength(coszString);
   }  // if(OSAL_NULL != coszString)

   tString szString = OSAL_NEW tChar[u32StrLen];

   if(OSAL_NULL != szString)
   {
      // Memset the string.
      (tVoid)OSAL_pvMemorySet(szString, 0, u32StrLen);

      if(OSAL_NULL != szValue)
      {
         // Copy the existing string to temporary string.
         (tVoid)OSAL_szStringNCopy(szString, szValue, OSAL_u32StringLength(szValue));
      }  // if(OSAL_NULL != szValue)
      
      if(OSAL_NULL != coszString)
      {
         // Concatenate the existing and incoming string.
         (tVoid)OSAL_szStringNConcat(szString, coszString, OSAL_u32StringLength(coszString));
      }  // if(OSAL_NULL != coszString)

      // Free the existing string and assign the pointer
      OSAL_DELETE [] szValue;
      
      // Assign the concatenated string.
      szValue  =  szString;
   }  // if(OSAL_NULL != szValue)
}  // tVoid ihl_tclFiString::vStringConCat(tCString coszString)

/******************************************************************************
** FUNCTION: tVoid ihl_tclFiString::vClone(most_fi_tcl_String &rfoString...)
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vClone(most_fi_tcl_String &rfoString) const
{
   // Free the existing FI string if any, to avoid mem leaks ;-)
   rfoString.vDestroy();
   
   // Get the string by cloning the tCString 
   vClone(rfoString.szValue);

}  // tVoid ihl_tclFiString::vClone(most_fi_tcl_String &rfoString) const

/******************************************************************************
** FUNCTION: tVoid ihl_tclFiString::vClone(tString &rfszString) const
******************************************************************************/

/*virtual*/
tVoid ihl_tclFiString::vClone(tString &rfszString) const
{
   if(OSAL_NULL != rfszString)
   {
      OSAL_DELETE [] rfszString;
      rfszString  =  OSAL_NULL;
   }  // if(OSAL_NULL != rfszString)

   rfszString  =  szGet(most_fi_tcl_String::FI_EN_UTF8);  // Use fi string get

}  // tVoid ihl_tclFiString::vClone(tString &rfszString) const

      }  // namespace most_fi

   }  // namespace fi_helpers
}  // namespace ihl

///////////////////////////////////////////////////////////////////////////////

// <EOF>
