/*!
*******************************************************************************
* \file              ihl_tclFiObjHandler.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Template library for Fi Object Handling
*                    Internally uses the concept of Executing around sequences.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 17.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLFIOBJHANDLER_H_
#define IHL_TCLFIOBJHANDLER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include <common_fi_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {

/*! 
 * \brief Template library for Fi Object Handling using Execute around seqs.
 *
 * C++ Pattern - Executing Around Sequences.
 * Pre- and Post-Sequence Actions - 
 * - Paired actions where a function is called before some statement sequence 
 * and a corresponding function afterwards are commonly associated with resource
 * acquisition and release
 * - Pre- and post-sequence actions are a common feature of block-scoped 
 * resource management e.g. allocate memory, use it, deallocate it and this 
 * programming cliche can be found time and time again across many programs.
 *
 * References:
 * - The Design and Evolution of C++, by Bjarne Stroustrup, Addison-Wesley
 * - Wrapping C++ Member Function Calls, by Bjarne Stroustrup, AT&T Labs - 
 * Research, Florham Park, New Jersey, USA
 * - Exceptional C++, by Herb Sutter, Addison-Wesley
 */

template <class ihl_tclGenericClass = fi_tclTypeBase>
class ihl_tclFiObjHandler : public ihl_tclGenericClass
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiObjHandler::ihl_tclFiObjHandler()
   ***************************************************************************/
   /*!
    * \brief   Constructor
    * \param   NONE
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiObjHandler():ihl_tclGenericClass(){};

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiObjHandler::~ihl_tclFiObjHandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclFiObjHandler(){this->vDestroy();};
   
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ihl_tclFiObjHandler

   }  // namespace fi_helpers
}  // namespace ihl

#endif   // #ifndef IHL_TCLFIOBJHANDLER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
