/*****************************************************************************
* FILE:         speaud_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef _FC_SPEECH_AUDIOMAIN_H_
#define _FC_SPEECH_AUDIOMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_SET
#include "stl_pif.h"

#include "speaud_AppMain_Trace.h"

// speaud_tclAppMainIncludes: user specific code start
// speaud_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define SPEAUD_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define SPEAUD_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// speaud_tclAppMainDefine: user specific code start
// speaud_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define SPEAUDINTERNAL_MSG_LEN    4       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class speaud_tclAppMain;

// speaud_tclAppMainForwardDecl: user specific code start
// speaud_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class speaud_tclBaseIf
{
protected:
   const speaud_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages

      // speaud_tclAppMainIMsgDef: user specific code start
      // speaud_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[50];
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[SPEAUDINTERNAL_MSG_LEN];

         // speaud_tclAppMainIMsgUnion: user specific code start
         // speaud_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   speaud_tclBaseIf(const speaud_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~speaud_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // speaud_tclAppMainBaseIfDecl: user specific code start
   // speaud_tclAppMainBaseIfDecl: user specific code end

};


class speaud_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static speaud_tclAppMain*   _poMainAppInstance;

public:
   static speaud_tclAppMain* theServer();    


   speaud_tclAppMain(tVoid);
   virtual ~speaud_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'speaud_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   speaud_tclAppMain& operator= (const speaud_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'speaud_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   speaud_tclAppMain(const speaud_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(speaud_tclBaseIf::TMsg* pInternalMsg);
   virtual tVoid vPostInternalMessage(speaud_tclBaseIf::TMsg* pInternalMsg);

   tVoid vAddObj(speaud_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(speaud_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();

   //reference handling for __ created objects
private:
   bpstl::set<speaud_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      bpstl::set<speaud_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      bpstl::set<speaud_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   speaud_tclBaseIf*  getHandler(const tChar* cName) const{
      bpstl::set<speaud_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:


   // speaud_tclAppMainDecl: user specific code start
   // speaud_tclAppMainDecl: user specific code end
}; 

#endif // _FC_SPEECH_AUDIOMAIN_H_

