/*****************************************************************************
* FILE:         speaud_AppMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     applMain.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "speaud_AppMain.h"

// speaud_tclAppMainIncludes: user specific code start
// speaud_tclAppMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_APPLICATION
#include "trcGenProj/Header/speaud_AppMain.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
speaud_tclAppMain* speaud_tclAppMain::_poMainAppInstance = NULL;

tUChar  speaud_tclAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : speaud_tclAppMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
speaud_tclAppMain* speaud_tclAppMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new speaud_tclAppMain();
   }
   return _poMainAppInstance;
}


/*******************************************************************************
*
* FUNCTION: speaud_tclAppMain::speaud_tclAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclAppMain::speaud_tclAppMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_FC_SPEECH_AUDIO)
{
   ETG_TRACE_USR4(("speaud_tclAppMain() entered."));

   speaud_tclAppMain::_poMainAppInstance   = this;

   // speaud_tclAppMainConstructor: user specific code start
   // speaud_tclAppMainConstructor: user specific code end

   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: speaud_tclAppMain::~speaud_tclAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclAppMain::~speaud_tclAppMain()
{
   ETG_TRACE_USR4(("~speaud_tclAppMain() entered."));

   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // speaud_tclAppMainDestructor: user specific code start
   // speaud_tclAppMainDestructor: user specific code end

   speaud_tclAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool speaud_tclAppMain::vStart()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid speaud_tclAppMain::vStart(tVoid)
{

   // speaud_tclAppMainvStart: user specific code start
   // speaud_tclAppMainvStart: user specific code end

   vGetReferences();
   vStartCommunication();
}

/*******************************************************************************
*
* FUNCTION: tBool speaud_tclAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool speaud_tclAppMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

   // speaud_tclAppMainbOnInit: user specific code start
   // speaud_tclAppMainbOnInit: user specific code end

   
   return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid speaud_tclAppMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   // speaud_tclAppMainvOnApplicationClose: user specific code start
   // speaud_tclAppMainvOnApplicationClose: user specific code end

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid speaud_tclAppMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer(id: %d) entered.", u16TimerId ));

   // speaud_tclAppMainvOnTimer: user specific code start
   // speaud_tclAppMainvOnTimer: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid speaud_tclAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));

   gm_tclStreamMessage oVisitorMsg(poMessage);

   speaud_tclBaseIf::TMsg oMsg;

   if (oVisitorMsg.u32GetDataSize() <= sizeof(oMsg)) {
      memcpy((tVoid*)&oMsg, oVisitorMsg.pcocGetData(), sizeof(oMsg));
	  
	  if (oMsg.eCmd != (speaud_tclBaseIf::ECmdTypes)poMessage->u16GetFunctionID()) {
         ETG_TRACE_FATAL(("vOnLoopbackService() failed. iFID = 0x%04x, cmd = 0x%04x.", (tU32)poMessage->u16GetFunctionID(), (tU32)oMsg.eCmd));
//         NORMAL_M_ASSERT_ALWAYS();
	  }
      else {
         ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%04x, u32MsgContent = %u.", (tU32)oMsg.eCmd, oMsg.u.u32Data));
         //post message
         vDispatchInternalMsg(&oMsg);
      }
   }
   else {
      ETG_TRACE_FATAL(("vOnLoopbackService() failed. message data size = %d, internal message size = %d.", (tU32)oVisitorMsg.u32GetDataSize(), (tU32)sizeof(oMsg) ));
      NORMAL_M_ASSERT_ALWAYS();
   }

}


tVoid speaud_tclAppMain::vDispatchInternalMsg(speaud_tclBaseIf::TMsg* pInternalMsg)
{
   if (pInternalMsg->eCmd == speaud_tclBaseIf::eCmdTraceCmdReceived) {
      //vHandleTraceMessageGen(_auchTraceInputBuffer);
       vHandleTraceMessage(_auchTraceInputBuffer);
 
       bpstl::set<speaud_tclBaseIf*>::iterator iter;
       for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
            (*iter)->vHandleTraceMessage(_auchTraceInputBuffer);
       }
   }
   else {
      bpstl::set<speaud_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (pInternalMsg->strClassName[0] != 0) 
         {
            if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
            if (0 == OSAL_s32StringCompare((*iter)->getName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
         } else {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      }
   }
}

tVoid speaud_tclAppMain::vPostInternalMessage(speaud_tclBaseIf::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("speaud_tclAppMain::vPostInternalMessage(): post internal message '%d'.", ETG_CENUM(speaud_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
   
   // speaud_tclAppMainPostInternStartUserSpecificClassCode: user specific code start
   // speaud_tclAppMainPostInternStartUserSpecificClassCode: user specific code end

   gm_tclStreamMessage oStreamMsg(u16GetAppId(), u16GetAppId(), 0, 0, 623, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_SET, sizeof(speaud_tclBaseIf::TMsg) );
   if (OSAL_NULL != oStreamMsg.pu8GetSharedMemBase()) {
       oStreamMsg.vSetData((const tChar*)pInternalMsg);
       if ( oStreamMsg.bIsValid() ) {
          if (enPostMessage(&oStreamMsg, TRUE) != AIL_EN_N_NO_ERROR) {
             NORMAL_M_ASSERT_ALWAYS();
          }
       } else {
          NORMAL_M_ASSERT_ALWAYS();
       }
   } else {
	   ETG_TRACE_ERRMEM(("speaud_tclAppMain::vPostInternalMessage(): message %d with data size %d bytes could not create! No shared memory.",
			   ETG_CENUM(speaud_tclBaseIf::ECmdTypes, pInternalMsg->eCmd), sizeof(speaud_tclBaseIf::TMsg) ));
   }
   // speaud_tclAppMainPostInternEndUserSpecificClassCode: user specific code start
   // speaud_tclAppMainPostInternEndUserSpecificClassCode: user specific code end

}

/*******************************************************************************
* FUNCTION   : speaud_tclAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for fc_speech_audio
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid speaud_tclAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_SPEECH_AUDIO;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)speaud_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}

/*******************************************************************************
* FUNCTION   : speaud_tclAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for fc_speech_audio
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid speaud_tclAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_SPEECH_AUDIO;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)speaud_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}

/*******************************************************************************
* FUNCTION   : speaud_tclAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid speaud_tclAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
#ifdef VARIANT_S_FTR_ENABLE_TRACE_CMD_DIRECT
   //speaud_tclAppMain::vHandleTraceMessageGen(puchData);
   speaud_tclAppMain::vHandleTraceMessage(puchData);
#else
   if (puchData[0] < TRACE_BUFFER_MAXSIZE) {
      ETG_TRACE_USR4(("vTraceCallbackFunction(), length of TTFis message=%u\n Data: %02x",puchData[0],ETG_LIST_LEN(puchData[0]), ETG_LIST_PTR_T8(&(puchData[1]))));
      memcpy(_auchTraceInputBuffer, puchData, puchData[0]+1);

      if (NULL != _poMainAppInstance) {
         speaud_tclBaseIf::TMsg oMsg;

         oMsg.eCmd = speaud_tclBaseIf::eCmdTraceCmdReceived;
         oMsg.strClassName[0]=0;
         oMsg.u.u32Data = 0;

         _poMainAppInstance->vPostInternalMessage(&oMsg);
      }
   } else {
      ETG_TRACE_ERR(("MAIN :: Input trace command too long"));
   }
#endif // VARIANT_S_FTR_ENABLE_TRACE_CMD_DIRECT
}

tVoid speaud_tclAppMain::vLoadRegistry() 
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procspeaud.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procspeaud.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procspeaud.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);
}


// speaud_tclAppMainUserSpecificClassCode: user specific code start
// speaud_tclAppMainUserSpecificClassCode: user specific code end


/*******************************************************************************
*                                       E O F
*******************************************************************************/
