
/*****************************************************************************
* FILE:         speaud_ServiceSpeaud.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// speaud_tclServiceSpeaudIncludes: user specific code start
// speaud_tclServiceSpeaudIncludes: user specific code end

#include "speaud_ServiceSpeaud.h"
#include "speaud_ServiceSpeaudCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_SERVER_SPEAUD
#include "trcGenProj/Header/speaud_ServiceSpeaud.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SPEAUD_SERVICE_ID              623
#define SPEAUD_FI_MAJOR_VERSION        1
#define SPEAUD_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(speaud_tclServiceSpeaud, ahl_tclBaseWork)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: speaud_tclServiceSpeaud::
*             speaud_tclServiceSpeaud(speaud_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclServiceSpeaud::speaud_tclServiceSpeaud(speaud_tclAppMain* poMainAppl) : 
Ispeaud_tclServiceSpeaud(poMainAppl, SPEAUD_SERVICE_ID, SPEAUD_FI_MAJOR_VERSION, SPEAUD_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaud() entered."));
   _poCallbackIf = OSAL_NULL;


   // speaud_tclServiceSpeaudConstructor: user specific code start
   // speaud_tclServiceSpeaudConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: speaud_tclServiceSpeaud::
*             ~speaud_tclServiceSpeaud(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclServiceSpeaud::~speaud_tclServiceSpeaud(tVoid)
{
   ETG_TRACE_USR4(("~speaud_tclServiceSpeaud() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // speaud_tclServiceSpeaudDestructor: user specific code start
   // speaud_tclServiceSpeaudDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'speaud_ServiceSpeaud.h':
*     Add forward declaration:
*         class Ifc_speech_audio_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_speech_audio_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_speech_audio_tclObject2Get*>(_cpoMain->getHandler("Ifc_speech_audio_tclObject2Get"));
*     SPEAUD_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaud::vGetReferences() entered."));
   // speaud_tclServiceSpeaudvGetReferences: user specific code start
   // speaud_tclServiceSpeaudvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaud::vStartCommunication() entered."));
   // speaud_tclServiceSpeaudvStartCommunication: user specific code start
   // speaud_tclServiceSpeaudvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   speaud_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vHandleMessage(speaud_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaud::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(speaud_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // speaud_tclServiceSpeaudvHandleMessage: user specific code start
   // speaud_tclServiceSpeaudvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vHandleTraceMessage(const tUChar* puchData)
{
   SPEAUD_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("speaud_tclServiceSpeaud::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // speaud_tclServiceSpeaudvHandleTraceMessage: user specific code start
   // speaud_tclServiceSpeaudvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      InternMsg (SPEAUD_MAINFI_C_U16_INTERNMSG) -> Opcode: UpReg, RelUpReg, Status, "));

   // speaud_tclServiceSpeaudvTraceInfo: user specific code start
   // speaud_tclServiceSpeaudvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // speaud_tclServiceSpeaudvOnServiceAvailable: user specific code start
   // speaud_tclServiceSpeaudvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaud::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid speaud_tclServiceSpeaud::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // speaud_tclServiceSpeaudvOnServiceUnavailable: user specific code start
   // speaud_tclServiceSpeaudvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool speaud_tclServiceSpeaud
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool speaud_tclServiceSpeaud
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("speaud_tclServiceSpeaud:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case SPEAUD_MAINFI_C_U16_INTERNMSG:
      {
         speaud_mainfi_tclMsgInternMsgStatus oStatus;

         oStatus.eTest = _tInternMsg_eTest;


         fi_tclVisitorMessage oVisitor(oStatus, SPEAUD_FI_MAJOR_VERSION);

         // CaseInternMsgStatus: user specific code start
         // CaseInternMsgStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
	  }
	  break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool speaud_tclServiceSpeaud
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool speaud_tclServiceSpeaud
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("speaud_tclServiceSpeaud:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
	  }
	  break;
   }
   return bSuccess;
} // bProcessSet

tVoid speaud_tclServiceSpeaud::sendInternMsgStatus(speaud_fi_tcl_e8_SPEAUD_TEST eTest)
{

   _tInternMsg_eTest = eTest;


   ETG_TRACE_USR4(("sendInternMsgStatus() called."));
   eUpdateClients(SPEAUD_MAINFI_C_U16_INTERNMSG);
}







// speaud_tclServiceSpeaudspeaud_ServiceSpeaud: user specific code start
// speaud_tclServiceSpeaudspeaud_ServiceSpeaud: user specific code end

//EOF
