/*****************************************************************************
* FILE:         speaud_ClientAcr.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __speaud_ClientAcr_H_
#define __speaud_ClientAcr_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ispeaud_ClientAcr.h"
#include "speaud_AppMain.h"

// speaud_tclClientAcr_Include: user specific code start
// speaud_tclClientAcr_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class speaud_tclClientAcrCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class speaud_tclClientAcr : public Ispeaud_tclClientAcr
{

public:
   virtual const tChar* getName() const { return "speaud_tclClientAcr"; };
   
   virtual tVoid vHandleMessage(speaud_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   speaud_tclClientAcr(tVoid); 
   speaud_tclClientAcr(speaud_tclAppMain* poMainAppl);
   virtual ~speaud_tclClientAcr();

   virtual tVoid vSetCallbackIf(speaud_tclClientAcrCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // speaud_tclClientAcrDeclarations: user specific code start
   // speaud_tclClientAcrDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'speaud_tclClientAcr' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   speaud_tclClientAcr& operator = (const speaud_tclClientAcr &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   speaud_tclClientAcrCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendChannelRequestGet();
   virtual tVoid getChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList& rChannelRequestStatusList) {
      rChannelRequestStatusList = _ChannelRequestStatusList_ChannelRequestStatus;
   }

   virtual tBool sendVoiceAdviceMStart(cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleChannelRequestOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleVoiceAdviceOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList ChannelRequestStatusList);

   virtual tVoid onVoiceAdviceMResult();

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   cmb_fi_tcl_ChannelRequestStatusList      _ChannelRequestStatusList_ChannelRequestStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(speaud_tclClientAcr) 

// speaud_tclClientAcrDeclarationsPart2: user specific code start
// speaud_tclClientAcrDeclarationsPart2: user specific code end

};

#endif // __speaud_ClientAcr_H_


