

/*****************************************************************************
* FILE:         speaud_ClientAcr.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// speaud_tclClientAcrIncludes: user specific code start
// speaud_tclClientAcrIncludes: user specific code end

#include "speaud_ClientAcr.h"
#include "speaud_ClientAcrCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_CLIENT_ACR
#include "trcGenProj/Header/speaud_ClientAcr.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define ACR_SERVICE_ID              520
#define ACR_FI_MAJOR_VERSION        2
#define ACR_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(speaud_tclClientAcr, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(CMB_ACRFI_C_U16_CHANNELREQUEST, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleChannelRequestOpStatus)
   ON_MESSAGE_SVCDATA(CMB_ACRFI_C_U16_VOICEADVICE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleVoiceAdviceOpMResult)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: speaud_tclClientAcr::
*             speaud_tclClientAcr(speaud_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclClientAcr::speaud_tclClientAcr(speaud_tclAppMain* poMainAppl) : 
Ispeaud_tclClientAcr(poMainAppl, ACR_SERVICE_ID, ACR_FI_MAJOR_VERSION, ACR_FI_MINOR_VERSION, CCA_C_U16_APP_NAVI )
{
   ETG_TRACE_USR4(("speaud_tclClientAcr() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // speaud_tclClientAcrConstructor: user specific code start
   // speaud_tclClientAcrConstructor: user specific code end
   vAddAutoRegisterForProperty(CMB_ACRFI_C_U16_CHANNELREQUEST);
}

/*******************************************************************************
*
* FUNCTION: speaud_tclClientAcr::
*             ~speaud_tclClientAcr(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclClientAcr::~speaud_tclClientAcr(tVoid)
{
   ETG_TRACE_USR4(("~speaud_tclClientAcr() entered."));
   _poCallbackIf = OSAL_NULL;

   // speaud_tclClientAcrDestructor: user specific code start
   // speaud_tclClientAcrDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'speaud_ClientAcr.h':
*     Add forward declaration:
*         class Ifc_speech_audio_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_speech_audio_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_speech_audio_tclObject2Get*>(_cpoMain->getHandler("Ifc_speech_audio_tclObject2Get"));
*     ACR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcr::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclClientAcr::vGetReferences() entered."));
   
   // speaud_tclClientAcrvGetReferences: user specific code start
   // speaud_tclClientAcrvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcr::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclClientAcr::vStartCommunication() entered."));
   // speaud_tclClientAcrvStartCommunication: user specific code start
   // speaud_tclClientAcrvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   speaud_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcr::vHandleMessage(speaud_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("speaud_tclClientAcr::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(speaud_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // speaud_tclClientAcrvHandleMessage: user specific code start
   // speaud_tclClientAcrvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcr::vHandleTraceMessage(const tUChar* puchData)
{
   SPEAUD_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("speaud_tclClientAcr::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // speaud_tclClientAcrvHandleTraceMessage: user specific code start
   // speaud_tclClientAcrvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcr::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      ChannelRequest (CMB_ACRFI_C_U16_CHANNELREQUEST) -> Opcode: Get, Status, UpReg, RelUpReg, Error, "));
   ETG_TRACE_FATAL(("Method   support:      VoiceAdvice (CMB_ACRFI_C_U16_VOICEADVICE) -> Opcode: MethodStart, MethodResult, Error, "));

   // speaud_tclClientAcrvTraceInfo: user specific code start
   // speaud_tclClientAcrvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid speaud_tclClientAcr::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // speaud_tclClientAcrvOnServiceAvailable: user specific code start
   // speaud_tclClientAcrvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcr::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid speaud_tclClientAcr::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // speaud_tclClientAcrvOnServiceUnavailable: user specific code start
   // speaud_tclClientAcrvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property CMB_ACRFI_C_U16_CHANNELREQUEST
*******************************************************************************/

tVoid speaud_tclClientAcr::vHandleChannelRequestOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         cmb_acrfi_tclMsgChannelRequestStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, ACR_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ChannelRequestStatusList_ChannelRequestStatus = oStatus.ChannelRequestStatusList;

            ETG_TRACE_USR1(("speaud_tclClientAcr::vHandleChannelRequestOpStatus(): Status update message received for 'CMB_ACRFI_C_U16_CHANNELREQUEST' (FID: 0x0201)!"));

            onChannelRequestStatus(oStatus.ChannelRequestStatusList);

            // vHandleChannelRequestOpStatus: user specific code start
            // vHandleChannelRequestOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("speaud_tclClientAcr::vHandleChannelRequestOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid speaud_tclClientAcr::onChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList ChannelRequestStatusList) {

   if (_poCallbackIf) _poCallbackIf->onChannelRequestStatus(ChannelRequestStatusList); 

   // onChannelRequestStatus: user specific code start
   // onChannelRequestStatus: user specific code end

}



/*******************************************************************************
* Handling of property CMB_ACRFI_C_U16_VOICEADVICE
*******************************************************************************/

tVoid speaud_tclClientAcr::vHandleVoiceAdviceOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
	   ETG_TRACE_USR4(("speaud_tclClientAcr::vHandleVoiceAdviceOpMResult() entered"));
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         cmb_acrfi_tclMsgVoiceAdviceMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, ACR_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("speaud_tclClientAcr::vHandleVoiceAdviceOpMResult(): Method result update message received for 'CMB_ACRFI_C_U16_VOICEADVICE' (FID: 0x0101)!"));

            onVoiceAdviceMResult();

            // vHandleVoiceAdviceOpMResult: user specific code start
            // vHandleVoiceAdviceOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("speaud_tclClientAcr::vHandleVoiceAdviceOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid speaud_tclClientAcr::onVoiceAdviceMResult() {

   if (_poCallbackIf) _poCallbackIf->onVoiceAdviceMResult(); 

   // onVoiceAdviceMResult: user specific code start
   // onVoiceAdviceMResult: user specific code end

}




tBool speaud_tclClientAcr::sendChannelRequestGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      cmb_acrfi_tclMsgChannelRequestGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) CMB_ACRFI_C_U16_CHANNELREQUEST, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "speaud_tclClientAcr::sendChannelRequestGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CMB_ACRFI_C_U16_CHANNELREQUEST, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool speaud_tclClientAcr::sendVoiceAdviceMStart(cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
	   ETG_TRACE_USR4(("speaud_tclClientAcr::sendVoiceAdviceMStart() entered"));
      cmb_acrfi_tclMsgVoiceAdviceMethodStart  oMStart;
      //the data content
      oMStart.AudioChannelAdvice = AudioChannelAdvice;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) CMB_ACRFI_C_U16_VOICEADVICE, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "speaud_tclClientAcr::sendVoiceAdviceMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CMB_ACRFI_C_U16_VOICEADVICE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// speaud_tclClientAcrspeaud_ClientAcr: user specific code start
// speaud_tclClientAcrspeaud_ClientAcr: user specific code end

//EOF
