
/*****************************************************************************
* FILE:         speaud_ClientAcrIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// speaud_tclClientAcrIfIncludes: user specific code start
#include "I_audioRouting.h"
// speaud_tclClientAcrIfIncludes: user specific code end

#include "speaud_ClientAcrIf.h"
#include "Ispeaud_ClientAcr.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_CLIENT_ACR
#include "trcGenProj/Header/speaud_ClientAcrIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: speaud_tclClientAcrIf::
*             speaud_tclClientAcrIf(speaud_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclClientAcrIf::speaud_tclClientAcrIf(speaud_tclAppMain* poMainAppl) : 
Ispeaud_tclClientAcrIf(poMainAppl)
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf() entered."));
   _poClientRef = OSAL_NULL;

   // speaud_tclClientAcrIfConstructor: user specific code start
   // speaud_tclClientAcrIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: speaud_tclClientAcrIf::
*             ~speaud_tclClientAcrIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclClientAcrIf::~speaud_tclClientAcrIf(tVoid)
{
   ETG_TRACE_USR4(("~speaud_tclClientAcrIf() entered."));
   _poClientRef = OSAL_NULL;

   // speaud_tclClientAcrIfDestructor: user specific code start
   // speaud_tclClientAcrIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'speaud_ClientAcrIf.h':
*     Add forward declaration:
*         class Ifc_speech_audio_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_speech_audio_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_speech_audio_tclObject2Get*>(_cpoMain->getHandler("Ifc_speech_audio_tclObject2Get"));
*     ACR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcrIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ispeaud_tclClientAcr*>(_cpoMain->getHandler("Ispeaud_tclClientAcr"));
   SPEAUD_NULL_POINTER_CHECK(_poClientRef);
   _poClientRef->vSetCallbackIf(this);

   // speaud_tclClientAcrIfvGetReferences: user specific code start
   // speaud_tclClientAcrIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcrIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::vStartCommunication() entered."));
   // speaud_tclClientAcrIfvStartCommunication: user specific code start
   // speaud_tclClientAcrIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   speaud_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcrIf::vHandleMessage(speaud_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(speaud_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // speaud_tclClientAcrIfvHandleMessage: user specific code start
   // speaud_tclClientAcrIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcrIf::vHandleTraceMessage(const tUChar* puchData)
{
   SPEAUD_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // speaud_tclClientAcrIfvHandleTraceMessage: user specific code start
   // speaud_tclClientAcrIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclClientAcrIf::vTraceInfo()
{
   // speaud_tclClientAcrIfvTraceInfo: user specific code start
   // speaud_tclClientAcrIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid speaud_tclClientAcrIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::onServiceAvailable() entered."));

   // speaud_tclClientAcrIfvOnServiceAvailable: user specific code start
   // speaud_tclClientAcrIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclClientAcrIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid speaud_tclClientAcrIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("speaud_tclClientAcrIf::onServiceUnavailable() entered."));

   // speaud_tclClientAcrIfvOnServiceUnavailable: user specific code start
   // speaud_tclClientAcrIfvOnServiceUnavailable: user specific code end
}

tVoid speaud_tclClientAcrIf::onChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList ChannelRequestStatusList)
{
   ETG_TRACE_USR1( ( "speaud_tclClientAcrIf::onChannelRequestStatus() entered" ) );

   // onChannelRequestStatus: user specific code start
   tU8 index = 0;

   cmb_fi_tcl_ChannelRequestStatusList requestList = ChannelRequestStatusList;

   I_speaudAudioRouting* _audio = dynamic_cast<I_speaudAudioRouting*>(_cpoMain->getHandler("I_speaudAudioRouting"));
   SPEAUD_NULL_POINTER_CHECK(_audio);

   bpstl::vector<cmb_fi_tcl_ChannelRequestStatus, bpstl::allocator<cmb_fi_tcl_ChannelRequestStatus> >::iterator iter;

   for(iter = requestList.ChannelRequestStatusList.begin(); iter != requestList.ChannelRequestStatusList.end(); iter++)
   {
	   /*
	                  cmb_fi_tcl_e8_VoiceCategory Category;  |  cmb_fi_tcl_e8_CatStatus Status;  |  cmb_fi_tcl_b16_RequestAddInfo
                                                             |                                   |
	                  FI_EN_DRIVINGRECOMMENDATION = 0UL,     |  FI_EN_SILENT = 0UL,              |  bUser() = true / false
	                  FI_EN_GENERALINFOAHEAD = 1UL,          |  FI_EN_NEEDCHANNEL = 1UL,         |
					  FI_EN_GENERALINFOROUTE = 2UL,          |  FI_EN_PLAYING = 2UL
					  FI_EN_GENERALINFOHORIZON = 3UL,        |
					  FI_EN_ROUTEINFO = 4UL,
					  FI_EN_DESTINFO = 5UL,
					  FI_EN_HMIMESSAGE = 6UL,
					  FI_EN_DEBUGMESSAGE = 7UL,
					  FI_EN_DIALOGPROMPT = 8UL,
					  FI_EN_EMAIL = 9UL,
					  FI_EN_SMS = 10UL,
					  FI_EN_MICAUDIO = 11UL
	   */

	   // If false, "normal" Navigation is used. If true, SDS will be cancelled by navigation to repeat last instruction
	   if(iter->RequestAddInfo.bUser() == false)
	   {
		   ETG_TRACE_USR4(("NORMAL NAVI ANNOUNCEMENT FOR INDEX %d",iter->Index));

		   // open channel if channel is requested
		   if((iter->Category.enType <= 5) && (iter->Status.enType == 1))
		   {
			   ETG_TRACE_USR4(("REQUEST::NEED CHANNEL | source = navi | index = %d",iter->Index));

			   _audio->indexVector.push_back(iter->Index);

			   for (int i=0 ; i<_audio->indexVector.size() ; i++)
			   {
				   ETG_TRACE_USR4(("CONTENT INDEXVECTOR at entry %d is index %d",i,iter->Index));
			   }

			   // if there is only one request at a time
			   if (_audio->indexVector.size() == 1)
			   {
				   ETG_TRACE_USR4(("REQUEST::NEED CHANNEL | source = navi | vectorsize() = 1 for index %d | request channel by ARL",iter->Index));
				   _audio->vSetNaviSpeechRequest(true,iter->Index,false);
			   }
			   // if there is more than one request at a time
			   else if (_audio->indexVector.size() > 1)
			   {
				   if(_audio->_bRouteIsAllocated == false)
				   {
				      ETG_TRACE_USR4(("Streaming into non open channel !!!!"));
				   }
				   ETG_TRACE_USR4(("REQUEST::NEED CHANNEL | source = navi | vectorsize() = %d | for index %d | streaming directly",_audio->indexVector.size(), iter->Index));

				   cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
				   AudioChannelAdvice.Device = OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH;
				   AudioChannelAdvice.Index = iter->Index;
				   cmb_fi_tcl_e8_AudioChannelAdvice advice;
				   advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_START;
				   AudioChannelAdvice.ChannelAdvice = advice;

				   sendVoiceAdviceMStart(AudioChannelAdvice);
			   }
		   }
		   // close channel when announcement has made
		   else if((iter->Category.enType <= 5) && (iter->Status.enType == 0))
		   {
			   ETG_TRACE_USR4(("REQUEST::SILENT | source = navi | Index = %d",iter->Index));

			   if(_audio->_bRouteIsAllocated == false)
			   {
				   for(int i=0 ; i<_audio->indexVector.size() ; i++)
				   {
					  ETG_TRACE_USR4(("NO ROUTE ALLOCATED. DELETING VECTOR ENTRY is index %d",_audio->indexVector[i]));
					  if(_audio->indexVector[i] == iter->Index)
					  {
						 cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
						 AudioChannelAdvice.Device = OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH;
						 AudioChannelAdvice.Index = _audio->indexVector[i];
						 cmb_fi_tcl_e8_AudioChannelAdvice advice;
						 advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_STOPIMMEDIATELY;
						 AudioChannelAdvice.ChannelAdvice = advice;
						 sendVoiceAdviceMStart(AudioChannelAdvice);
						 _audio->indexVector.erase(_audio->indexVector.begin() + i);
					  }
				   }
			   }
			   else // if route has been allocated
			   {
				   // if there is only one entry in index vector
				   if(_audio->indexVector.size() == 1)
				   {
					   ETG_TRACE_USR4(("REQUEST::CLOSE CHANNEL FOR SINGLE REQUEST, INDEX IS %d",_audio->indexVector[0]));
					   _audio->vSetNaviSpeechRequest(false, iter->Index,false);
					   // solution for ncg3-24748 (do not erase vector content -> will be done after audio is finished !!!)
					   if(_audio->_bRouteIsAllocated == false)
					   {
						   ETG_TRACE_USR4(("CHANNELREQUEST::ROUTE NOT ALLOCATED"));
						   cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
						   AudioChannelAdvice.Device = OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH;
						   AudioChannelAdvice.Index = iter->Index;
						   cmb_fi_tcl_e8_AudioChannelAdvice advice;
						   advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_STOPIMMEDIATELY;
						   AudioChannelAdvice.ChannelAdvice = advice;
						   sendVoiceAdviceMStart(AudioChannelAdvice);
						   _audio->indexVector.erase(_audio->indexVector.begin());
						}
				   }
				   // if there are more requests in index vector
				   else if (_audio->indexVector.size() > 1)
				   {
					   ETG_TRACE_USR4(("CHANNELREQUEST::CLOSE CHANNEL FOR MULTI REQUEST"));
					   for(int i=0 ; i<_audio->indexVector.size() ; i++)
					   {
						   ETG_TRACE_USR4(("SEARCHING FOR INDEX %d, found %d",iter->Index,_audio->indexVector[i]));
						   if(_audio->indexVector[i] == iter->Index)
						   {
								ETG_TRACE_USR4(("VOICE ADVICE (STOP) for index %d",_audio->indexVector[i]));
								cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
								AudioChannelAdvice.Device = OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH;
								AudioChannelAdvice.Index = _audio->indexVector[i];
								cmb_fi_tcl_e8_AudioChannelAdvice advice;
								advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_STOPIMMEDIATELY;
								AudioChannelAdvice.ChannelAdvice = advice;

								sendVoiceAdviceMStart(AudioChannelAdvice);

								_audio->indexVector.erase(_audio->indexVector.begin() + i);
								break;
							}
						 }
					 }
			     }
		      }
		   else if((iter->Category.enType <= 5) && (iter->Status.enType == 2))
		   {
			   ETG_TRACE_USR4(("REQUEST::PLAYING | source = navi | Index = %d", iter->Index));
		   }
	   } // end if RequestAddInfo.bUser is false

	   // here we need to close SDS by navigation
	   else if(iter->RequestAddInfo.bUser() == true)
	   {
		   ETG_TRACE_USR4(("SPECIAL NAVI ANNOUNCEMENT FOR INDEX %d",iter->Index));

		   // if the channel is to be opened
		   if((iter->Category.enType <= 5) && (iter->Status.enType == 1))
		   {
			   ETG_TRACE_USR4(("REQUEST::NEED CHANNEL | source = special | index %d | request channel by ARL",iter->Index));

			   _audio->indexVector.push_back(iter->Index);

			   for (int i=0 ; i<_audio->indexVector.size() ; i++)
			   {
			      ETG_TRACE_USR4(("CONTENT INDEXVECTOR at entry %d is index %d",i,iter->Index));
			   }
			   _audio->vSetNaviSpeechRequest(true,iter->Index,true);
		   }
		   // if the channel is to be closed
		   else if ((iter->Category.enType <= 5) && (iter->Status.enType == 0))
		   {
			   ETG_TRACE_USR4(("REQUEST::CLOSE CHANNEL | source = special | index %d",iter->Index));
			   _audio->vSetNaviSpeechRequest(false,iter->Index,true);
		   }
		   // if the channel is to be played
		   else if ((iter->Category.enType <= 5) && (iter->Status.enType == 2))
		   {
			   ETG_TRACE_USR4(("REQUEST::PLAYING INDEX %d",iter->Index));
		   }
	   }
   }// for(iter...)
   // onChannelRequestStatus: user specific code end
}

tVoid speaud_tclClientAcrIf::onVoiceAdviceMResult() {
   ETG_TRACE_USR1( ( "speaud_tclClientAcrIf::onVoiceAdviceMResult(): CALLED" ) );

   // onVoiceAdviceMResult: user specific code start
   // onVoiceAdviceMResult: user specific code end
}
// speaud_tclClientAcrIfspeaud_ClientAcrIf: user specific code start
// speaud_tclClientAcrIfspeaud_ClientAcrIf: user specific code end

//EOF
