/************************************************************************
* FILE:        	speaudAudioRouting.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	speaud
*----------------------------------------------------------------------
*
* DESCRIPTION: class for audio routing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date       | Author                 | Modification
* 27.05.2015 | CM-AI/EPB2 Schurig     | initial version
* 27.04.2016 | CM-CI1/ERN4-E Schurig  | Bugfix for overlapping messages
*
*************************************************************************/

#ifndef _SPEAUDAUDIOROUTING_H_
#define _SPEAUDAUDIOROUTING_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// include base class
#include "I_speaud_ClientAcrIf.h"
#include "I_audioRouting.h"

#include "../../../../../../ai_audio/components/audio_routing_lib/include/arl_tclISource.h"

#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#include "../../../../../../ai_audio/components/audio_routing_lib/audio_routing_lib.h"

class speaudAudioRouting : public I_speaudAudioRouting, public arl_tclISource
{
public:
	speaudAudioRouting(void){;};
	speaudAudioRouting(const speaud_tclAppMain* poMainAppl);
	virtual ~speaudAudioRouting();

	virtual const tChar* getName() const {return "speaudAudioRouting";};

	// To be implemented by I_speaudAudioRouting
	virtual void vHandleMessage(speaud_tclBaseIf::TMsg* pMsg);
	virtual void vHandleTraceMessage(const tUChar* puchData);
	virtual void vGetReferences();
	virtual void vStartCommunication();
	virtual void vTraceInfo();

	// To be implemented by audio_routing_lib( arl_tclISource )
    virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
    virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
    virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);

	virtual void vSetNaviSpeechRequest(bool bOpenChannel, tU8 index, tBool isSDSTriggered);


private:
	Ispeaud_tclClientAcr* _client;
};

#endif // _SPEAUDAUDIOROUTING_H_
