/*****************************************************************************
* FILE:         hc_ServiceHeatIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ServiceHeatIf__IF__H_
#define __hc_ServiceHeatIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ServiceHeatIf.h"
#include "hc_AppMain.h"
#include "hc_ServiceHeatCallbackIf.h"

// hc_tclServiceHeatIf_Include: user specific code start
// hc_tclServiceHeatIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclServiceHeat;

class hc_tclServiceHeatIf : public Ihc_tclServiceHeatIf, public hc_tclServiceHeatCallbackIF
{
public:

   hc_tclServiceHeatIf(tVoid); 
   hc_tclServiceHeatIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclServiceHeatIf();

   // hc_tclServiceHeatIfDeclarations: user specific code start
   // hc_tclServiceHeatIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "hc_tclServiceHeatIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendRealSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List);
   virtual tVoid sendRealSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List);
   virtual tVoid sendAbstractSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List);
   virtual tVoid sendAbstractSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List);
   virtual tVoid sendEmergencyFunctionsStatus(heatctrl_fi_tcl_EmergencyFunctionList List);
   virtual tVoid sendFANControlStatus(heatctrl_fi_tcl_FAN FAN, heatctrl_fi_tcl_FANCtrl FANCtrl);

   virtual tBool onFANControlSet(heatctrl_fi_tcl_FANReq FAN, heatctrl_fi_tcl_FANCtrlReq FANCtrl, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendFI_FC_HEATCTRL_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus);


   virtual tVoid onFI_FC_HEATCTRL_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode);

   virtual void vGetRealSensorTemperaturesMsg(heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& oStatus) {if (_poServerRef) _poServerRef->vGetRealSensorTemperaturesMsg(oStatus);}
   virtual void vGetRealSensorStatesMsg(heatctrl_mainfi_tclMsgRealSensorStatesStatus& oStatus) {if (_poServerRef) _poServerRef->vGetRealSensorStatesMsg(oStatus);}
   virtual void vGetAbstractSensorTemperaturesMsg(heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAbstractSensorTemperaturesMsg(oStatus);}
   virtual void vGetAbstractSensorStatesMsg(heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAbstractSensorStatesMsg(oStatus);}
   virtual void vGetEmergencyFunctionsMsg(heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& oStatus) {if (_poServerRef) _poServerRef->vGetEmergencyFunctionsMsg(oStatus);}
   virtual void vGetFANControlMsg(heatctrl_mainfi_tclMsgFANControlStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFANControlMsg(oStatus);}

private:
   Ihc_tclServiceHeat* _poServerRef;

// hc_tclServiceHeatIfDeclarationsPart2: user specific code start
   // converting sensor id from internal to CCA
   heatctrl_fi_tcl_e8_SensorID::tenType m_aenConvertSensorID[enThermalSensorID_MAX];
   inline heatctrl_fi_tcl_e8_SensorID::tenType enConvertSensorID(tenThermalSensorID enSensorID) const
   {
	   if ((sizeof(m_aenConvertSensorID)/sizeof(m_aenConvertSensorID[0])) > (tU8)enSensorID)
		   return m_aenConvertSensorID[enSensorID];
	   return heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF;
   };
   heatctrl_fi_tcl_e8_SensorID::tenType m_aenConvertAbstractSensorID[enAbstractSensorID_MAX];
   inline heatctrl_fi_tcl_e8_SensorID::tenType enConvertAbstractSensorID(tenAbstractSensorID enSensorID) const
   {
	   if ((sizeof(m_aenConvertAbstractSensorID)/sizeof(m_aenConvertAbstractSensorID[0])) > (tU8)enSensorID)
		   return m_aenConvertAbstractSensorID[enSensorID];
	   return heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF;
   };
   // converting sensor state from internal to CCA
   heatctrl_fi_tcl_e8_SensorState::tenType m_aenConvertSensorState[enThermalState_MAX];
   inline heatctrl_fi_tcl_e8_SensorState::tenType enConvertSensorState(tenThermalState enSensorState) const
   {
	   if ((sizeof(m_aenConvertSensorState)/sizeof(m_aenConvertSensorState[0])) > (tU8)enSensorState)
		   return m_aenConvertSensorState[enSensorState];
	   return heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_UNAVAIL;
   };
   // convert temperature qualifier
   heatctrl_fi_tcl_e8_TemperatureQualityType::tenType m_aenConvertTemperatureQualitfier[enTemperatureQualifier_MAX];
   inline heatctrl_fi_tcl_e8_TemperatureQualityType::tenType enConvertTemperatureQualifier(tenTemperatureQualifier enTemperatureQualifier) const
   {
	   if ((sizeof(m_aenConvertTemperatureQualitfier)/sizeof(m_aenConvertTemperatureQualitfier[0])) > (tU8)enTemperatureQualifier)
		   return m_aenConvertTemperatureQualitfier[enTemperatureQualifier];
	   return heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_INVALID;
   }
   // converting emergency function id from internal to CCA
   heatctrl_fi_tcl_e8_EmergncyFunctionID::tenType m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_MAX];
   inline heatctrl_fi_tcl_e8_EmergncyFunctionID::tenType enConvertEmergencyFunctionID(tenEmergencyFunctionID enFunctionID) const
   {
	   if ((sizeof(m_aenConvertEmergencyFunctionID)/sizeof(m_aenConvertEmergencyFunctionID[0])) > (tU8)enFunctionID)
		   return m_aenConvertEmergencyFunctionID[enFunctionID];
	   return heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_UNDEFINE;
   }
   // converting emergency function state from internal to CCA
   heatctrl_fi_tcl_e8_EmergncyFunctionState::tenType m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_MAX];
   inline heatctrl_fi_tcl_e8_EmergncyFunctionState::tenType enConvertEmergencyFunctionState(tenEmergencyFunctionState enFunctionState) const
   {
	   if ((sizeof(m_aenConvertEmergencyFunctionState)/sizeof(m_aenConvertEmergencyFunctionState[0])) > (tU8)enFunctionState)
		   return m_aenConvertEmergencyFunctionState[enFunctionState];
	   return heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_UNDEFINE;
   }
   // handling of internal messages
   tVoid vHandleMessage_NewSensorState(hc_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_NewSensorTemperature(hc_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_NewAbstractSensorState(hc_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_NewAbstractSensorTemperature(hc_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_UpdateEmergencyFunctionState(hc_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_NewFanControlState(hc_tclBaseIf::TMsg* pMsg);
// hc_tclServiceHeatIfDeclarationsPart2: user specific code end

};

#endif // __hc_ServiceHeatIf__IF__H_


