/*****************************************************************************
* FILE:         hc_ServiceHeatIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// hc_tclServiceHeatIfIncludes: user specific code start
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_STDVISITORS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_FUNCTIONIDS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_ERRORCODES
#include "heatctrl_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
#include "midw_fi_if.h"

#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensorControl.h"
#include "hc_tclAbstractSensorControl.h"
#include "hc_tclEmergencyFunctionControl.h"
#include "hc_tclFANControl.h"
#include "hc_tclFANControl_Types.h"
#include "hc_tclCfgMgr.h"
// hc_tclServiceHeatIfIncludes: user specific code end

#include "hc_ServiceHeatIf.h"
#include "I_hc_ServiceHeat.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_SERVER_HEAT
#include "trcGenProj/Header/hc_ServiceHeatIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclServiceHeatIf::
*             hc_tclServiceHeatIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclServiceHeatIf::hc_tclServiceHeatIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclServiceHeatIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf() entered."));
   _poServerRef = OSAL_NULL;

   // hc_tclServiceHeatIfConstructor: user specific code start
   m_aenConvertSensorID[enThermalSensorID_UNDEF] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF;
   m_aenConvertSensorID[enThermalSensorID_V850] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_V850;
   m_aenConvertSensorID[enThermalSensorID_Panel] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_PANEL;
   m_aenConvertSensorID[enThermalSensorID_CDDRIVE] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_CDDRIVE;
   m_aenConvertSensorID[enThermalSensorID_DVDDRIVE] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DVDDRIVE;
   m_aenConvertSensorID[enThermalSensorID_GPS] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_GPS;
   m_aenConvertSensorID[enThermalSensorID_GYRO] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_GYRO;
   m_aenConvertSensorID[enThermalSensorID_EMMC] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_EMMC;
   m_aenConvertSensorID[enThermalSensorID_AMP] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_AMP;
   m_aenConvertSensorID[enThermalSensorID_IMX] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_IMX;
   m_aenConvertSensorID[enThermalSensorID_HEATSINK] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_HEATSINK;
   m_aenConvertSensorID[enThermalSensorID_BLUERAY] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_BLUERAY;
   m_aenConvertSensorID[enThermalSensorID_XMModule] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_XMMODULE;
   m_aenConvertSensorID[enThermalSensorID_TVModule] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_TVMODULE;
   m_aenConvertSensorID[enThermalSensorID_TVModuleSlave] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_TVMODULESLAVE;
   m_aenConvertSensorID[enThermalSensorID_Panel2] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_PANEL2;

   m_aenConvertAbstractSensorID[enAbstractSensorID_UNDEF] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF;
   m_aenConvertAbstractSensorID[enAbstractSensorID_AMPLIFIER] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_AMPLIFIER;
   m_aenConvertAbstractSensorID[enAbstractSensorID_CPU] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_CPU;
   m_aenConvertAbstractSensorID[enAbstractSensorID_EXPBOARD] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_EXPBOARD;
   m_aenConvertAbstractSensorID[enAbstractSensorID_BOARD] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_BOARD;
   m_aenConvertAbstractSensorID[enAbstractSensorID_DISPLAY] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DISPLAY;
   m_aenConvertAbstractSensorID[enAbstractSensorID_DRIVE] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DRIVE;
   m_aenConvertAbstractSensorID[enAbstractSensorID_SYSTEM] = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_SYSTEM;

   m_aenConvertSensorState[enThermalState_UNAVAILABLE] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_UNAVAIL;
   m_aenConvertSensorState[enThermalState_CONFIGFAILURE] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_CONFIGFAILURE;
   m_aenConvertSensorState[enThermalState_INIT] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_INIT;
   m_aenConvertSensorState[enThermalState_TEMPUNAVAIL] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_TEMPUNAVAIL;
   m_aenConvertSensorState[enThermalState_CRITICALLOW] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_CRITICALLOW;
   m_aenConvertSensorState[enThermalState_LOW] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_LOW;
   m_aenConvertSensorState[enThermalState_COLD] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_COLD;
   m_aenConvertSensorState[enThermalState_NORMAL] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_NORMAL;
   m_aenConvertSensorState[enThermalState_WARM] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_WARM;
   m_aenConvertSensorState[enThermalState_HIGH] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_HIGH;
   m_aenConvertSensorState[enThermalState_EMERGENCYHIGH] = heatctrl_fi_tcl_e8_SensorState::FI_EN_FC_HEATCTRL_EMERGENCYHIGH;

   m_aenConvertTemperatureQualitfier[enTemperatureQualifier_INVALID] = heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_INVALID;
   m_aenConvertTemperatureQualitfier[enTemperatureQualifier_ESTIMATED] = heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_ESTIMATED;
   m_aenConvertTemperatureQualitfier[enTemperatureQualifier_CALCULATED] = heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_CALCULATED;
   m_aenConvertTemperatureQualitfier[enTemperatureQualifier_REAL] = heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_REAL;
   m_aenConvertTemperatureQualitfier[enTemperatureQualifier_UNSUPPORTED] = heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_UNSUPPORTED;

   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_UNDEF] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_UNDEFINE;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_SystemShutdown] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_BacklightOFF] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_BACKLIGHTOFF;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_Attenuation] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_ATTENUATION;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_CDDriveOff] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_CDDRIVEOFF;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_DVDDriveOff] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_DVDDRIVEOFF;
   m_aenConvertEmergencyFunctionID[enEmergencyFunctionID_TVModuleOff] = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_TVMODULEOFF;

   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_DISABLED] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT;
   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_NoResult] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT;
   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_Inactive] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_INACTIVE;
   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_Active] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE;
   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_ActiveHigh] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE;
   m_aenConvertEmergencyFunctionState[enEmergencyFunctionState_ActiveLow] = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE;
   // hc_tclServiceHeatIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclServiceHeatIf::
*             ~hc_tclServiceHeatIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclServiceHeatIf::~hc_tclServiceHeatIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclServiceHeatIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // hc_tclServiceHeatIfDestructor: user specific code start
   // hc_tclServiceHeatIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ServiceHeatIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     HEAT_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ihc_tclServiceHeat*>(_cpoMain->getHandler("Ihc_tclServiceHeat"));

   HC_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclServiceHeatIfvGetReferences: user specific code start
   // initial property information
   vHandleMessage_NewSensorState(OSAL_NULL);
   vHandleMessage_NewSensorTemperature(OSAL_NULL);
   // hc_tclServiceHeatIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::vStartCommunication() entered."));
   // hc_tclServiceHeatIfvStartCommunication: user specific code start
   // hc_tclServiceHeatIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclServiceHeatIfvHandleMessage: user specific code start
   HC_NULL_POINTER_CHECK(pMsg);
   switch (pMsg->eCmd)
   {
   case hc_tclBaseIf::eUpdateSensorState:
	   vHandleMessage_NewSensorState(pMsg);
	   break;
   case hc_tclBaseIf::eUpdateSensorTemperature:
	   vHandleMessage_NewSensorTemperature(pMsg);
	   break;
   case hc_tclBaseIf::eUpdateAbstractSensorState:
	   vHandleMessage_NewAbstractSensorState(pMsg);
	   break;
   case hc_tclBaseIf::eUpdateAbstractSensorTemperature:
	   vHandleMessage_NewAbstractSensorTemperature(pMsg);
	   break;
   case hc_tclBaseIf::eUpdateEmergencyFunctionState:
	   vHandleMessage_UpdateEmergencyFunctionState(pMsg);
	   break;
   case hc_tclBaseIf::eUpdateFanState:
	   vHandleMessage_NewFanControlState(pMsg);
	   break;
   default:
	   break;
   }
   // hc_tclServiceHeatIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclServiceHeatIfvHandleTraceMessage: user specific code start
   // hc_tclServiceHeatIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vTraceInfo()
{
   // hc_tclServiceHeatIfvTraceInfo: user specific code start
   // hc_tclServiceHeatIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclServiceHeatIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::onServiceAvailable() entered."));

   // hc_tclServiceHeatIfvOnServiceAvailable: user specific code start
   // hc_tclServiceHeatIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeatIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclServiceHeatIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::onServiceUnavailable() entered."));

   // hc_tclServiceHeatIfvOnServiceUnavailable: user specific code start
   // hc_tclServiceHeatIfvOnServiceUnavailable: user specific code end
}

tBool hc_tclServiceHeatIf::onFANControlSet(heatctrl_fi_tcl_FANReq FAN, heatctrl_fi_tcl_FANCtrlReq FANCtrl, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onFANControlSet: user specific code start
   ETG_TRACE_USR4(("hc_tclServiceHeatIf::onFANControlSet: FANCtrl-Event is %d, FAN-PwrState is %d, FAN-Speed is %d",
		   FANCtrl.Event.enType, FAN.State.enType, FAN.Speed.u8Value ));

   bPropertyChanged = FALSE;
   u16ErrorCode = HEATCTRL_MAINFI_C_U16_ERROR_UNSPECIFIED;

   I_hc_tclFANControl* _poFanControl = dynamic_cast<I_hc_tclFANControl*>(_cpoMain->getHandler("I_hc_tclFANControl"));
   if (OSAL_NULL == _poFanControl)
   {
	   u16ErrorCode = HEATCTRL_MAINFI_C_U16_ERROR_DISABLED;
   }
   else
   {
	   switch (FANCtrl.Event.enType)
	   {
	   case heatctrl_fi_tcl_e8_FANCtrlEvent::FI_EN_FC_HEATCTRL_FANCTRLEVENT_MANUAL_END:
	   	   {
			   tenFANCtrlModeEvent _enEvent = enFANCtrlModeEvent_MANUAL_END;
			   tenFANPowerState _enPwrState = enFANPowerState_UNDEF;
			   tU8 _u8Speed = FAN.Speed.u8Value;
			   switch (FAN.State.enType)
			   {
			   case heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_OFF:
				   _enPwrState = enFANPowerState_OFF;
				   break;
			   case heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_ON:
				   _enPwrState = enFANPowerState_ON;
				   break;
			   default:
				   if (0 == _u8Speed)
					   _enPwrState = enFANPowerState_OFF;
				   else if (100 >= _u8Speed)
					   _enPwrState = enFANPowerState_ON;
				   break;
			   }
			   if (TRUE == _poFanControl->bSetReqFanControl(_enEvent,_enPwrState,_u8Speed, OSAL_C_U8_MAX))
				   _bResult = TRUE;
			   else
				   u16ErrorCode = HEATCTRL_MAINFI_C_U16_ERROR_INTERNALFAILURE;
	   	   }
		   break;

	   case heatctrl_fi_tcl_e8_FANCtrlEvent::FI_EN_FC_HEATCTRL_FANCTRLEVENT_DONTCARE:
	   	   {
			   // change to fan control mode MANUAL only
			   tenFANCtrlModeEvent _enEvent = enFANCtrlModeEvent_MANUAL_START;
			   tenFANPowerState _enPwrState = enFANPowerState_INIT;
			   tU8 _u8Speed = (100 < FAN.Speed.u8Value) ? 100 : FAN.Speed.u8Value;
			   if (TRUE == _poFanControl->bSetReqFanControl(_enEvent, _enPwrState, _u8Speed, _u8Speed))
				   _bResult = TRUE;
			   else
				   u16ErrorCode = HEATCTRL_MAINFI_C_U16_ERROR_INTERNALFAILURE;
	   	   }
		   break;

	   default:
		   u16ErrorCode = HEATCTRL_MAINFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
		   break;
	   }
   }
   // onFANControlSet: user specific code end
   return _bResult;
}

tVoid hc_tclServiceHeatIf::onFI_FC_HEATCTRL_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) {

   // onFI_FC_HEATCTRL_DEFAULTMStart: user specific code start
   ETG_TRACE_FATAL(("hc_tclServiceHeatIf::onFI_FC_HEATCTRL_DEFAULTMStart: method start with group = %d and mode = %d .",
		   DefaultSettingsGroup, DefaultSettingsMode ));

   tU8 _u8DefaultSettingsStatus = 0xFF;

   if((midw_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE == ((midw_fi_tcl_e8_DefSetGroups::tenType)DefaultSettingsGroup))
      && (midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING == ((midw_fi_tcl_e8_DefSetMode::tenType)DefaultSettingsMode)))
   {
	   I_hc_tclCfgMgr* _poCfgMgr = dynamic_cast<I_hc_tclCfgMgr*>(_cpoMain->getHandler("I_hc_tclCfgMgr"));
	   if (OSAL_NULL != _poCfgMgr)
	   {
		   _poCfgMgr->vOnLoadSettings();
		   _u8DefaultSettingsStatus = 0;
	   }
   }

   sendFI_FC_HEATCTRL_DEFAULTMResult(DefaultSettingsGroup, _u8DefaultSettingsStatus);
   // onFI_FC_HEATCTRL_DEFAULTMStart: user specific code end
}

tVoid hc_tclServiceHeatIf::sendRealSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRealSensorTemperaturesStatus(List);
}

tVoid hc_tclServiceHeatIf::sendRealSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRealSensorStatesStatus(List);
}

tVoid hc_tclServiceHeatIf::sendAbstractSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAbstractSensorTemperaturesStatus(List);
}

tVoid hc_tclServiceHeatIf::sendAbstractSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAbstractSensorStatesStatus(List);
}

tVoid hc_tclServiceHeatIf::sendEmergencyFunctionsStatus(heatctrl_fi_tcl_EmergencyFunctionList List) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendEmergencyFunctionsStatus(List);
}

tVoid hc_tclServiceHeatIf::sendFANControlStatus(heatctrl_fi_tcl_FAN FAN, heatctrl_fi_tcl_FANCtrl FANCtrl) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFANControlStatus(FAN, FANCtrl);
}



tVoid hc_tclServiceHeatIf::sendFI_FC_HEATCTRL_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus) {
    //just forward send request
    HC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFI_FC_HEATCTRL_DEFAULTMResult(DefaultSettingsGroup, DefaultSettingsStatus);
}





// hc_tclServiceHeatIfhc_ServiceHeatIf: user specific code start
/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_NewSensorState()
*
* DESCRIPTION:  handling of new thermal sensor state
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_NewSensorState(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewSensorState(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(_cpoMain);
   I_hc_tclThermalSensorControl* _poThermalSensorControl = dynamic_cast<I_hc_tclThermalSensorControl*>(_cpoMain->getHandler("I_hc_tclThermalSensorControl"));
   HC_NULL_POINTER_CHECK(_poThermalSensorControl);
   heatctrl_fi_tcl_SensorStateList _List;
   // collect all thermal sensor states
   for (tU8 _u8Index=0; (tU8)enThermalSensorID_MAX > _u8Index; ++ _u8Index)
   {
	   tenThermalSensorID _enSensorID = (tenThermalSensorID)_u8Index;
	   heatctrl_fi_tcl_SensorState _SensorState;
	   _SensorState.ID.enType = enConvertSensorID(_enSensorID);
	   _SensorState.State.enType = enConvertSensorState(_poThermalSensorControl->enGetSensorState(_enSensorID));
	   _SensorState.LastValidState.enType = enConvertSensorState(_poThermalSensorControl->enGetSensorStateLastValid(_enSensorID));
	   if (heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF != _SensorState.ID.enType)
		   _List.SensorStateList.push_back(_SensorState);
   }
   // add MAIN thermal state
   heatctrl_fi_tcl_SensorState _SensorState;
   _SensorState.ID.enType = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_MAIN;
   _SensorState.State.enType = enConvertSensorState(_poThermalSensorControl->enGetMainState());
   _SensorState.LastValidState.enType = enConvertSensorState(_poThermalSensorControl->enGetMainState());
   _List.SensorStateList.push_back(_SensorState);
   // send status message
   sendRealSensorStatesStatus(_List);
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_NewSensorTemperature()
*
* DESCRIPTION:  handling of new thermal sensor temperature
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_NewSensorTemperature(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewSensorState(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(_cpoMain);
   I_hc_tclThermalSensorControl* _poThermalSensorControl = dynamic_cast<I_hc_tclThermalSensorControl*>(_cpoMain->getHandler("I_hc_tclThermalSensorControl"));
   HC_NULL_POINTER_CHECK(_poThermalSensorControl);
   heatctrl_fi_tcl_SensorTemperatureList _List;
   // collect all thermal sensor temperatures
   for (tU8 _u8Index=0; (tU8)enThermalSensorID_MAX > _u8Index; ++ _u8Index)
   {
	   tenThermalSensorID _enSensorID = (tenThermalSensorID)_u8Index;
	   heatctrl_fi_tcl_SensorTemperature _SensorTemperature;
	   _SensorTemperature.ID.enType = enConvertSensorID(_enSensorID);
	   _SensorTemperature.Temperature.s16Value = _poThermalSensorControl->tGetTemperature(_enSensorID);
	   _SensorTemperature.Quality.enType = enConvertTemperatureQualifier(_poThermalSensorControl->enGetTemperatureQualifier(_enSensorID));
	   _SensorTemperature.TemperatureMin = _poThermalSensorControl->tGetTemperatureMinStatistics(_enSensorID);
	   _SensorTemperature.TemperatureMax = _poThermalSensorControl->tGetTemperatureMaxStatistics(_enSensorID);
	   if (heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF != _SensorTemperature.ID.enType)
		   _List.SensorTemperatureList.push_back(_SensorTemperature);
   }
   // send status message
   if (FALSE == _List.SensorTemperatureList.empty())
	   sendRealSensorTemperaturesStatus(_List);
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_NewAbstractSensorState()
*
* DESCRIPTION:  handling of new abstract sensor state
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_NewAbstractSensorState(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewAbstractSensorState(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(_cpoMain);
   I_hc_tclThermalSensorControl* _poThermalSensorControl = dynamic_cast<I_hc_tclThermalSensorControl*>(_cpoMain->getHandler("I_hc_tclThermalSensorControl"));
   HC_NULL_POINTER_CHECK(_poThermalSensorControl);
   I_hc_tclAbstractSensorControl* _poSensorControl = dynamic_cast<I_hc_tclAbstractSensorControl*>(_cpoMain->getHandler("I_hc_tclAbstractSensorControl"));
   HC_NULL_POINTER_CHECK(_poSensorControl);
   heatctrl_fi_tcl_SensorStateList _List;
   // collect all thermal sensor states
   for (tU8 _u8Index=0; (tU8)enAbstractSensorID_MAX > _u8Index; ++ _u8Index)
   {
	   tenAbstractSensorID _enSensorID = (tenAbstractSensorID)_u8Index;
	   heatctrl_fi_tcl_SensorState _SensorState;
	   _SensorState.ID.enType = enConvertAbstractSensorID(_enSensorID);
	   _SensorState.State.enType = enConvertSensorState(_poSensorControl->enGetSensorState(_enSensorID));
	   _SensorState.LastValidState.enType = enConvertSensorState(_poSensorControl->enGetSensorStateLastValid(_enSensorID));
	   if (heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF != _SensorState.ID.enType)
		   _List.SensorStateList.push_back(_SensorState);
   }
   // add MAIN thermal state
   heatctrl_fi_tcl_SensorState _SensorState;
   _SensorState.ID.enType = heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_MAIN;
   _SensorState.State.enType = enConvertSensorState(_poThermalSensorControl->enGetMainState());
   _SensorState.LastValidState.enType = enConvertSensorState(_poThermalSensorControl->enGetMainState());
   _List.SensorStateList.push_back(_SensorState);
   // send status message
   if (FALSE == _List.SensorStateList.empty())
	   sendAbstractSensorStatesStatus(_List);
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_NewAbstractSensorTemperature()
*
* DESCRIPTION:  handling of new abstract sensor temperature
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_NewAbstractSensorTemperature(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewAbstractSensorTemperature(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(_cpoMain);
   I_hc_tclAbstractSensorControl* _poSensorControl = dynamic_cast<I_hc_tclAbstractSensorControl*>(_cpoMain->getHandler("I_hc_tclAbstractSensorControl"));
   HC_NULL_POINTER_CHECK(_poSensorControl);
   heatctrl_fi_tcl_SensorTemperatureList _List;
   // collect all thermal sensor temperatures
   for (tU8 _u8Index=0; (tU8)enAbstractSensorID_MAX > _u8Index; ++ _u8Index)
   {
	   tenAbstractSensorID _enSensorID = (tenAbstractSensorID)_u8Index;
	   heatctrl_fi_tcl_SensorTemperature _SensorTemperature;
	   _SensorTemperature.ID.enType = enConvertAbstractSensorID(_enSensorID);
	   _SensorTemperature.Temperature.s16Value = _poSensorControl->tGetTemperature(_enSensorID);
	   _SensorTemperature.Quality.enType = enConvertTemperatureQualifier(_poSensorControl->enGetTemperatureQualifier(_enSensorID));
	   _SensorTemperature.TemperatureMin = _poSensorControl->tGetTemperatureMinStatistics(_enSensorID);
	   _SensorTemperature.TemperatureMax = _poSensorControl->tGetTemperatureMaxStatistics(_enSensorID);
	   if (heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_UNDEF != _SensorTemperature.ID.enType)
		   _List.SensorTemperatureList.push_back(_SensorTemperature);
   }
   // send status message
   if (FALSE == _List.SensorTemperatureList.empty())
	   sendAbstractSensorTemperaturesStatus(_List);
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_UpdateEmergencyFunctionState()
*
* DESCRIPTION:  handling of emergency function state update
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_UpdateEmergencyFunctionState(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_UpdateEmergencyFunctionState(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(pMsg);
   if (enEmergencyFunctionID_MAX != pMsg->u.tEmergencyFunctionState.enFunctionID)
	   return;
   HC_NULL_POINTER_CHECK(_cpoMain);
   I_hc_tclEmergencyFunctionControl* _poEFControl = dynamic_cast<I_hc_tclEmergencyFunctionControl*>(_cpoMain->getHandler("I_hc_tclEmergencyFunctionControl"));
   HC_NULL_POINTER_CHECK(_poEFControl);
   heatctrl_fi_tcl_EmergencyFunctionList _List;
   // collect all emergency function states
   for (tU8 _u8Index=0; (tU8)enEmergencyFunctionID_MAX > _u8Index; ++ _u8Index)
   {
	   tenEmergencyFunctionID _enFunctionID = (tenEmergencyFunctionID)_u8Index;
	   heatctrl_fi_tcl_EmergencyFunction _EmergencyFunction;
	   _EmergencyFunction.ID.enType = enConvertEmergencyFunctionID(_enFunctionID);
	   _EmergencyFunction.State.enType = enConvertEmergencyFunctionState(_poEFControl->enGetFunctionState(_enFunctionID));
	   if (heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_UNDEFINE != _EmergencyFunction.ID.enType)
		   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
	   // emergency function SystemShutdown ... reason high or low temperature
	   if (heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN == _EmergencyFunction.ID.enType)
	   {
		   if ( enEmergencyFunctionState_ActiveLow ==  _poEFControl->enGetFunctionState(_enFunctionID))
		   {
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNHIGHTEMP;
			   _EmergencyFunction.State.enType = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_INACTIVE;
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNLOWTEMP;
			   _EmergencyFunction.State.enType = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE;
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
		   }
		   else if (enEmergencyFunctionState_Active <=  _poEFControl->enGetFunctionState(_enFunctionID))
		   {
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNHIGHTEMP;
			   _EmergencyFunction.State.enType = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE;
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNLOWTEMP;
			   _EmergencyFunction.State.enType = heatctrl_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_INACTIVE;
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
		   }
		   else
		   {
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNHIGHTEMP;
			   _EmergencyFunction.State.enType = enConvertEmergencyFunctionState(_poEFControl->enGetFunctionState(_enFunctionID));
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
			   _EmergencyFunction.ID.enType = heatctrl_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWNLOWTEMP;
			   _EmergencyFunction.State.enType = enConvertEmergencyFunctionState(_poEFControl->enGetFunctionState(_enFunctionID));
			   _List.EmergencyFunctionList.push_back(_EmergencyFunction);
		   }
	   }
   }
   // send status message
   if (FALSE == _List.EmergencyFunctionList.empty())
	   sendEmergencyFunctionsStatus(_List);
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage_NewFanControlState()
*
* DESCRIPTION:  handling of fan control state update
*
* PARAMETER: 	hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclServiceHeatIf::vHandleMessage_NewFanControlState(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewFanControlState(msg: 0x%08x) entered.", pMsg));
   HC_NULL_POINTER_CHECK(pMsg);

   I_hc_tclFANControl* _poFanControl = dynamic_cast<I_hc_tclFANControl*>(_cpoMain->getHandler("I_hc_tclFANControl"));
   HC_NULL_POINTER_CHECK(_poFanControl);

   heatctrl_fi_tcl_FAN _oFAN;
   heatctrl_fi_tcl_FANCtrl _oFANCtrl;
   // fan status
   _oFAN.Current.u16Value = _poFanControl->u16GetFANCurrent();
   _oFAN.Speed.u8Value = _poFanControl->u8GetFANSpeed();
   _oFAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_UNDEF;
   switch (_poFanControl->enGetFANPwrState())
   {
   case enFANPowerState_INIT:
	   _oFAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_INIT;
	   break;
   case enFANPowerState_OFF:
	   _oFAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_OFF;
	   break;
   case enFANPowerState_ON:
	   _oFAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_ON;
	   break;
   default:
	   break;
   }
   // fan control status
   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_UNDEF;
   switch (_poFanControl->enGetFANCtrlMode())
   {
   case enFANCtrlMode_INIT:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_INIT;
	   break;
   case enFANCtrlMode_AUTO:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_AUTO;
	   break;
   case enFANCtrlMode_AUTO_SELFTEST:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_AUTO_SELFTEST;
	   break;
   case enFANCtrlMode_AUTO_MEASURE:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_AUTO_MEASURE;
	   break;
   case enFANCtrlMode_MANUAL:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_MANUAL;
	   break;
   case enFANCtrlMode_STOPPED:
	   _oFANCtrl.Mode.enType = heatctrl_fi_tcl_e8_FANCtrlMode::FI_EN_FC_HEATCTRL_FANCTRLMODE_STOPPED;
	   break;
   default:
	   break;
   }
   // send status message
   sendFANControlStatus(_oFAN, _oFANCtrl);
}
// hc_tclServiceHeatIfhc_ServiceHeatIf: user specific code end

//EOF
