/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          hc_ServiceHeatCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: fc_heatctrl
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __heatctrl_main_fi_CALLBACKIF_H_
#define __heatctrl_main_fi_CALLBACKIF_H_

class hc_tclServiceHeatCallbackIF
{
   public:
       virtual ~hc_tclServiceHeatCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onFANControlSet(heatctrl_fi_tcl_FANReq FAN, heatctrl_fi_tcl_FANCtrlReq FANCtrl, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onFI_FC_HEATCTRL_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) = 0;
};

#endif //__heatctrl_main_fi_CALLBACKIF_H_


