/*****************************************************************************
* FILE:         hc_ServiceHeat.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ServiceHeat_H_
#define __hc_ServiceHeat_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ServiceHeat.h"
#include "hc_AppMain.h"

// hc_tclServiceHeat_Include: user specific code start
// hc_tclServiceHeat_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclServiceHeatCallbackIF;

class hc_tclServiceHeat : public Ihc_tclServiceHeat
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   hc_tclServiceHeat(tVoid); 
   hc_tclServiceHeat(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclServiceHeat();

   virtual tVoid vSetCallbackIf(hc_tclServiceHeatCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclServiceHeatDeclarations: user specific code start
   // hc_tclServiceHeatDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclServiceHeat' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclServiceHeat& operator = (const hc_tclServiceHeat &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "hc_tclServiceHeat"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   hc_tclServiceHeatCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendRealSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List);
   virtual tVoid sendRealSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List);
   virtual tVoid sendAbstractSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List);
   virtual tVoid sendAbstractSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List);
   virtual tVoid sendEmergencyFunctionsStatus(heatctrl_fi_tcl_EmergencyFunctionList List);
   virtual tVoid sendFANControlStatus(heatctrl_fi_tcl_FAN FAN, heatctrl_fi_tcl_FANCtrl FANCtrl);

   virtual tBool onFANControlSet(heatctrl_fi_tcl_FANReq FAN, heatctrl_fi_tcl_FANCtrlReq FANCtrl, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onFI_FC_HEATCTRL_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode);
   virtual tVoid vHandleFI_FC_HEATCTRL_DEFAULTOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendFI_FC_HEATCTRL_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus);

   virtual void vGetRealSensorTemperaturesMsg(heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& oStatus) {
      oStatus.List = _tRealSensorTemperatures_List;
   }
   virtual void vGetRealSensorStatesMsg(heatctrl_mainfi_tclMsgRealSensorStatesStatus& oStatus) {
      oStatus.List = _tRealSensorStates_List;
   }
   virtual void vGetAbstractSensorTemperaturesMsg(heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& oStatus) {
      oStatus.List = _tAbstractSensorTemperatures_List;
   }
   virtual void vGetAbstractSensorStatesMsg(heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& oStatus) {
      oStatus.List = _tAbstractSensorStates_List;
   }
   virtual void vGetEmergencyFunctionsMsg(heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& oStatus) {
      oStatus.List = _tEmergencyFunctions_List;
   }
   virtual void vGetFANControlMsg(heatctrl_mainfi_tclMsgFANControlStatus& oStatus) {
      oStatus.FAN = _tFANControl_FAN;
      oStatus.FANCtrl = _tFANControl_FANCtrl;
   }
   virtual void vGetFI_FC_HEATCTRL_DEFAULTMsg(heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& oMethodStart) {
      oMethodStart.DefaultSettingsGroup = _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsGroup;
      oMethodStart.DefaultSettingsMode = _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsMode;
   }

private:
   // Add status information properties.
   heatctrl_fi_tcl_SensorTemperatureList _tRealSensorTemperatures_List;

   heatctrl_fi_tcl_SensorStateList _tRealSensorStates_List;

   heatctrl_fi_tcl_SensorTemperatureList _tAbstractSensorTemperatures_List;

   heatctrl_fi_tcl_SensorStateList _tAbstractSensorStates_List;

   heatctrl_fi_tcl_EmergencyFunctionList _tEmergencyFunctions_List;

   heatctrl_fi_tcl_FAN _tFANControl_FAN;

   heatctrl_fi_tcl_FANCtrl _tFANControl_FANCtrl;

   tU8 _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsGroup;
   tU8 _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsMode;
   tclMethodResultManager _oMemFI_FC_HEATCTRL_DEFAULT;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclServiceHeat) 

// hc_tclServiceHeatDeclarationsPart2: user specific code start
// hc_tclServiceHeatDeclarationsPart2: user specific code end

};

#endif // __hc_ServiceHeat_H_


