/*****************************************************************************
* FILE:         hc_ServiceHeat.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// hc_tclServiceHeatIncludes: user specific code start
// hc_tclServiceHeatIncludes: user specific code end

#include "hc_ServiceHeat.h"
#include "hc_ServiceHeatCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_SERVER_HEAT
#include "trcGenProj/Header/hc_ServiceHeat.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define HEAT_SERVICE_ID              42
#define HEAT_FI_MAJOR_VERSION        1
#define HEAT_FI_MINOR_VERSION        4

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclServiceHeat, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(HEATCTRL_MAINFI_C_U16_FI_FC_HEATCTRL_DEFAULT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleFI_FC_HEATCTRL_DEFAULTOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclServiceHeat::
*             hc_tclServiceHeat(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclServiceHeat::hc_tclServiceHeat(hc_tclAppMain* poMainAppl) : 
Ihc_tclServiceHeat(poMainAppl, HEAT_SERVICE_ID, HEAT_FI_MAJOR_VERSION, HEAT_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclServiceHeat() entered."));
   _poCallbackIf = OSAL_NULL;

   _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsGroup = 0;
   _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsMode = 0;

   // hc_tclServiceHeatConstructor: user specific code start
   // hc_tclServiceHeatConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclServiceHeat::
*             ~hc_tclServiceHeat(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclServiceHeat::~hc_tclServiceHeat(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclServiceHeat() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // hc_tclServiceHeatDestructor: user specific code start
   // hc_tclServiceHeatDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ServiceHeat.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     HEAT_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeat::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclServiceHeat::vGetReferences() entered."));
   // hc_tclServiceHeatvGetReferences: user specific code start
   // hc_tclServiceHeatvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeat::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclServiceHeat::vStartCommunication() entered."));
   // hc_tclServiceHeatvStartCommunication: user specific code start
   // hc_tclServiceHeatvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeat::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclServiceHeat::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclServiceHeatvHandleMessage: user specific code start
   // hc_tclServiceHeatvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeat::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclServiceHeat::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclServiceHeatvHandleTraceMessage: user specific code start
   // hc_tclServiceHeatvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclServiceHeat::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      RealSensorTemperatures (HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      RealSensorStates (HEATCTRL_MAINFI_C_U16_REALSENSORSTATES) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AbstractSensorTemperatures (HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AbstractSensorStates (HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      EmergencyFunctions (HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FANControl (HEATCTRL_MAINFI_C_U16_FANCONTROL) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      FI_FC_HEATCTRL_DEFAULT (HEATCTRL_MAINFI_C_U16_FI_FC_HEATCTRL_DEFAULT) -> Opcode: MethodStart, MethodResult, "));

   // hc_tclServiceHeatvTraceInfo: user specific code start
   // hc_tclServiceHeatvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclServiceHeat::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclServiceHeatvOnServiceAvailable: user specific code start
   // hc_tclServiceHeatvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclServiceHeat::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclServiceHeat::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclServiceHeatvOnServiceUnavailable: user specific code start
   // hc_tclServiceHeatvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool hc_tclServiceHeat
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool hc_tclServiceHeat
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("hc_tclServiceHeat:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES:
      {
         heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus oStatus;

         oStatus.List = _tRealSensorTemperatures_List;

         // CaseRealSensorTemperaturesStatus_Pre: user specific code start
         // CaseRealSensorTemperaturesStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseRealSensorTemperaturesStatus: user specific code start
         // CaseRealSensorTemperaturesStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case HEATCTRL_MAINFI_C_U16_REALSENSORSTATES:
      {
         heatctrl_mainfi_tclMsgRealSensorStatesStatus oStatus;

         oStatus.List = _tRealSensorStates_List;

         // CaseRealSensorStatesStatus_Pre: user specific code start
         // CaseRealSensorStatesStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseRealSensorStatesStatus: user specific code start
         // CaseRealSensorStatesStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES:
      {
         heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus oStatus;

         oStatus.List = _tAbstractSensorTemperatures_List;

         // CaseAbstractSensorTemperaturesStatus_Pre: user specific code start
         // CaseAbstractSensorTemperaturesStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseAbstractSensorTemperaturesStatus: user specific code start
         // CaseAbstractSensorTemperaturesStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES:
      {
         heatctrl_mainfi_tclMsgAbstractSensorStatesStatus oStatus;

         oStatus.List = _tAbstractSensorStates_List;

         // CaseAbstractSensorStatesStatus_Pre: user specific code start
         // CaseAbstractSensorStatesStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseAbstractSensorStatesStatus: user specific code start
         // CaseAbstractSensorStatesStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS:
      {
         heatctrl_mainfi_tclMsgEmergencyFunctionsStatus oStatus;

         oStatus.List = _tEmergencyFunctions_List;

         // CaseEmergencyFunctionsStatus_Pre: user specific code start
         // CaseEmergencyFunctionsStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseEmergencyFunctionsStatus: user specific code start
         // CaseEmergencyFunctionsStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case HEATCTRL_MAINFI_C_U16_FANCONTROL:
      {
         heatctrl_mainfi_tclMsgFANControlStatus oStatus;

         oStatus.FAN = _tFANControl_FAN;
         oStatus.FANCtrl = _tFANControl_FANCtrl;

         // CaseFANControlStatus_Pre: user specific code start
         // CaseFANControlStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, HEAT_FI_MAJOR_VERSION);

         // CaseFANControlStatus: user specific code start
         // CaseFANControlStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool hc_tclServiceHeat
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool hc_tclServiceHeat
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("hc_tclServiceHeat:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case HEATCTRL_MAINFI_C_U16_FANCONTROL:
      {
         heatctrl_mainfi_tclMsgFANControlSet oSet;

         if (oVisitorMsg.s32GetData(oSet, HEAT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onFANControlSet(oSet.FAN, oSet.FANCtrl, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onFANControlSet(oSet.FAN, oSet.FANCtrl, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseFANControlSet: user specific code start
         // CaseFANControlSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid hc_tclServiceHeat::sendRealSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List)
{

   _tRealSensorTemperatures_List = List;


   ETG_TRACE_USR4(("sendRealSensorTemperaturesStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES);
}
tVoid hc_tclServiceHeat::sendRealSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List)
{

   _tRealSensorStates_List = List;


   ETG_TRACE_USR4(("sendRealSensorStatesStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_REALSENSORSTATES);
}
tVoid hc_tclServiceHeat::sendAbstractSensorTemperaturesStatus(heatctrl_fi_tcl_SensorTemperatureList List)
{

   _tAbstractSensorTemperatures_List = List;


   ETG_TRACE_USR4(("sendAbstractSensorTemperaturesStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES);
}
tVoid hc_tclServiceHeat::sendAbstractSensorStatesStatus(heatctrl_fi_tcl_SensorStateList List)
{

   _tAbstractSensorStates_List = List;


   ETG_TRACE_USR4(("sendAbstractSensorStatesStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES);
}
tVoid hc_tclServiceHeat::sendEmergencyFunctionsStatus(heatctrl_fi_tcl_EmergencyFunctionList List)
{

   _tEmergencyFunctions_List = List;


   ETG_TRACE_USR4(("sendEmergencyFunctionsStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS);
}
tVoid hc_tclServiceHeat::sendFANControlStatus(heatctrl_fi_tcl_FAN FAN, heatctrl_fi_tcl_FANCtrl FANCtrl)
{

   _tFANControl_FAN = FAN;
   _tFANControl_FANCtrl = FANCtrl;


   ETG_TRACE_USR4(("sendFANControlStatus() called."));
   eUpdateClients(HEATCTRL_MAINFI_C_U16_FANCONTROL);
}

tBool hc_tclServiceHeat::onFANControlSet(heatctrl_fi_tcl_FANReq FAN, heatctrl_fi_tcl_FANCtrlReq FANCtrl, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)FAN; (tVoid)FANCtrl;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onFANControlSet: user specific code start
   // onFANControlSet: user specific code end
   return _bResult;
}


tVoid hc_tclServiceHeat::vHandleFI_FC_HEATCTRL_DEFAULTOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, HEAT_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsGroup = oMStart.DefaultSettingsGroup;
            _tFI_FC_HEATCTRL_DEFAULT_DefaultSettingsMode = oMStart.DefaultSettingsMode;



            // Remember that we have to send an answer to this request
            _oMemFI_FC_HEATCTRL_DEFAULT.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onFI_FC_HEATCTRL_DEFAULTMStart(oMStart.DefaultSettingsGroup, oMStart.DefaultSettingsMode);
            if (_poCallbackIf) _poCallbackIf->onFI_FC_HEATCTRL_DEFAULTMStart(oMStart.DefaultSettingsGroup, oMStart.DefaultSettingsMode);
            // vHandleFI_FC_HEATCTRL_DEFAULTOpMStart: user specific code start
            // vHandleFI_FC_HEATCTRL_DEFAULTOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleFI_FC_HEATCTRL_DEFAULTOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid hc_tclServiceHeat::onFI_FC_HEATCTRL_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) {

   // onFI_FC_HEATCTRL_DEFAULTMStart: user specific code start
	(tVoid)DefaultSettingsGroup;
	(tVoid)DefaultSettingsMode;
   // onFI_FC_HEATCTRL_DEFAULTMStart: user specific code end
}
tVoid hc_tclServiceHeat::sendFI_FC_HEATCTRL_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus) {
   if (_oMemFI_FC_HEATCTRL_DEFAULT.bIsPending() == TRUE) {
      heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult  oMResult;
      //the data content

      oMResult.DefaultSettingsGroup = DefaultSettingsGroup;
      oMResult.DefaultSettingsStatus = DefaultSettingsStatus;


      _oMemFI_FC_HEATCTRL_DEFAULT.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemFI_FC_HEATCTRL_DEFAULT.u16GetSourceAppID(), 
         _oMemFI_FC_HEATCTRL_DEFAULT.u16GetRegisterID(), 
         _oMemFI_FC_HEATCTRL_DEFAULT.u16GetCMDCounter(), 
         (tU16) HEATCTRL_MAINFI_C_U16_FI_FC_HEATCTRL_DEFAULT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendFI_FC_HEATCTRL_DEFAULTMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", HEATCTRL_MAINFI_C_U16_FI_FC_HEATCTRL_DEFAULT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// hc_tclServiceHeathc_ServiceHeat: user specific code start
// hc_tclServiceHeathc_ServiceHeat: user specific code end

//EOF
