/*****************************************************************************
* FILE:         hc_ClientThermalIncAdaptor.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     incAdaptor.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _THERMALINCADAPTOR_H_
#define _THERMALINCADAPTOR_H_


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "I_hc_ClientThermalIncAdaptor.h"

class ThermalIncCallbackIf;

class hc_tclClientThermalIncAdaptor : public I_hc_tclClientThermalIncAdaptor
{
private: 
    DatagramSocket*          _poDatagramSocket;
    ThermalIncCallbackIf*   _poCallbackIf;
public:
    hc_tclClientThermalIncAdaptor(hc_tclAppMain* poMainAppl);
    virtual ~hc_tclClientThermalIncAdaptor();

    virtual const tChar* getName() const { return "hc_tclClientThermalIncAdaptor"; };
   
    virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tVoid vSetCallbackIf(ThermalIncCallbackIf* poCallback) {
      _poCallbackIf = poCallback;
    }

    virtual tBool sendMessage(tU8* u8buf, tU32 ulen);

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
    virtual tBool sendREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
    virtual tBool sendGET_STATE();
    virtual tBool sendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState);
    virtual tBool sendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent);
    virtual tBool sendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID);
    virtual tBool sendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
    virtual tBool sendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
    virtual tBool sendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent);

private:

    virtual void onNewDatagramMessage(void* data, size_t length);
    virtual void vDispatchMessage(void* data, size_t length);
    
    // hc_THERMALAdaptorAddClassPart: user specific code start
    // hc_THERMALAdaptorAddClassPart: user specific code end

};

#endif // _THERMALINCADAPTOR_H_

