/*****************************************************************************
* FILE:         hc_ClientThermalIncAdaptor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     incAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

//include base class
#include "hc_AppMain.h"

#include "Thermal_incCallbackIf.h"
#include "hc_ClientThermalIncAdaptor.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <dirent.h>
#include <mntent.h>

#include "inc.h"
#include "inc_ports.h"
#include "dgram_service.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL
#include "trcGenProj/Header/hc_ClientThermalIncAdaptor.cpp.trc.h"
#endif

// hc_tclClientThermalIncAdaptorIncludes: user specific code start
// hc_tclClientThermalIncAdaptorIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

hc_tclClientThermalIncAdaptor::hc_tclClientThermalIncAdaptor(hc_tclAppMain* poMainAppl) : 
I_hc_tclClientThermalIncAdaptor(poMainAppl)
{

    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::hc_tclClientThermalIncAdaptor(): Called.... ."));

   _poDatagramSocket = new DatagramSocket(this, 8000, 100, THERMAL_MANAGEMENT_PORT, AF_BOSCH_INC_AUTOSAR, TRUE);
   _poCallbackIf     = OSAL_NULL;
   
   // hc_tclClientThermalIncAdaptor::hc_tclClientThermalIncAdaptor: user specific code start
   // hc_tclClientThermalIncAdaptor::hc_tclClientThermalIncAdaptor: user specific code end   
}

hc_tclClientThermalIncAdaptor::~hc_tclClientThermalIncAdaptor()
{

   ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::~hc_tclClientThermalIncAdaptor(): Called.... ."));

   if( OSAL_NULL != _poDatagramSocket) {
      OSAL_DELETE _poDatagramSocket;
   }
   
   _poDatagramSocket = OSAL_NULL;
   _poCallbackIf     = OSAL_NULL;
}

tVoid hc_tclClientThermalIncAdaptor::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == hc_tclBaseIf::eCmdIncMsgReceived) {
       vDispatchMessage(pMsg->u.au8Data, HCINTERNAL_MSG_LEN);
   }
   // hc_tclClientThermalIncAdaptor::vHandleMessage: user specific code start
   // hc_tclClientThermalIncAdaptor::vHandleMessage: user specific code end
}

tVoid hc_tclClientThermalIncAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
    HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientThermalIncAdaptor::vHandleTraceMessage: user specific code start
   // hc_tclClientThermalIncAdaptor::vHandleTraceMessage: user specific code end
}

tVoid hc_tclClientThermalIncAdaptor::vGetReferences() {
   // hc_tclClientThermalIncAdaptor::vGetReferences: user specific code start
   // hc_tclClientThermalIncAdaptor::vGetReferences: user specific code end
}


tVoid hc_tclClientThermalIncAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::vTraceInfo() entered."));
   // hc_tclClientThermalIncAdaptor::vTraceInfo: user specific code start
   // hc_tclClientThermalIncAdaptor::vTraceInfo: user specific code end

}


tVoid hc_tclClientThermalIncAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::vStartCommunication() entered."));
   // hc_tclClientThermalIncAdaptor::vStartCommunication: user specific code start
   // hc_tclClientThermalIncAdaptor::vStartCommunication: user specific code end
}

tBool hc_tclClientThermalIncAdaptor::sendMessage(tU8* u8buf, tU32 ulen) {

    tBool bRet = FALSE;
    ETG_TRACE_USR1(("hc_tclClientThermalIncAdaptor::sendMessage(): Called.... ."));
    if (_poDatagramSocket) {
        ETG_TRACE_USR1(("hc_tclClientThermalIncAdaptor::sendMessage():  Send message ID: %02x, datalen %d.", (tU8)u8buf[0], ulen));

        if (0 != _poDatagramSocket->sendMessage((void*)u8buf, ulen)) {
            bRet = TRUE;
        }
    }
    return bRet;
}

void hc_tclClientThermalIncAdaptor::onNewDatagramMessage(void* data, size_t length)
{
    hc_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = hc_tclBaseIf::eCmdIncMsgReceived;
    memset(oMsg.strClassName, 0, 50);
    OSAL_szStringNCopy(oMsg.strClassName, "I_hc_tclClientThermalIncAdaptor", strlen("I_hc_tclClientThermalIncAdaptor"));

    if (length <= HCINTERNAL_MSG_LEN) {
        (tVoid)OSAL_pvMemoryCopy(oMsg.u.au8Data, data, length);
        _cpoMain->theServer()->vPostInternalMessage(&oMsg);
    } else {
        ETG_TRACE_FATAL(("hc_tclClientThermalIncAdaptor::onNewDatagramMessage(): message too long."));
        // hc_tclClientThermalIncAdaptor::onNewDatagramMessage: user specific code start
        // hc_tclClientThermalIncAdaptor::onNewDatagramMessage: user specific code end        
    }

}

void hc_tclClientThermalIncAdaptor::vDispatchMessage(void* data, size_t length)
{
   tU8* pu8Data = (tU8*)data;
   ETG_TRACE_USR1(("hc_tclClientThermalIncAdaptor::vDispatchMessage() entered -> data: %*x", ETG_LIST_LEN(length), ETG_LIST_PTR_T8((tU8*)data)));

   // hc_tclClientThermalIncAdaptor::vDispatchMessage: user specific code start
   // hc_tclClientThermalIncAdaptor::vDispatchMessage: user specific code end

   switch (pu8Data[0]) {
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_COMPONENT_STATUS:
           if (_poCallbackIf) {
               _poCallbackIf->onCOMPONENT_STATUS((::thermal_management_inc_fi::EApplicationStatus)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_REJECT:
           if (_poCallbackIf) {
               _poCallbackIf->onREJECT((::thermal_management_inc_fi::ERejectReason)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_GET_STATE:
           if (_poCallbackIf) {
               _poCallbackIf->onGET_STATE((::thermal_management_inc_fi::EModuleState)pu8Data[1]);
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_SET_STATE:
           if (_poCallbackIf) {
               _poCallbackIf->onSET_STATE((::thermal_management_inc_fi::EModuleID)pu8Data[1], (::thermal_management_inc_fi::EModuleState)pu8Data[2]);
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_REQ_FAN:
           if (_poCallbackIf) {
               _poCallbackIf->onREQ_FAN((::thermal_management_inc_fi::EModuleID)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_GET_TEMP:
           if (_poCallbackIf) {
               _poCallbackIf->onGET_TEMP((::thermal_management_inc_fi::EModuleID)pu8Data[1], (tS16)((tU16)pu8Data[3]<<8)|((tU16)pu8Data[2]));
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_SET_TEMP:
           if (_poCallbackIf) {
               _poCallbackIf->onSET_TEMP((::thermal_management_inc_fi::EModuleID)pu8Data[1], (tS16)((tU16)pu8Data[3]<<8)|((tU16)pu8Data[2]));
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_SET_TEST_TEMP:
           if (_poCallbackIf) {
               _poCallbackIf->onSET_TEST_TEMP((::thermal_management_inc_fi::EModuleID)pu8Data[1], (tS16)((tU16)pu8Data[3]<<8)|((tU16)pu8Data[2]));
           }
           break;
       case (tU8) ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_R_SET_TEST_FAN:
           if (_poCallbackIf) {
               _poCallbackIf->onSET_TEST_FAN((::thermal_management_inc_fi::EFanID)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       default:
           break;
   }
}

tBool hc_tclClientThermalIncAdaptor::sendCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_COMPONENT_STATUS, (tU8)ApplicationStatus, (tU8)ApplicationVersion};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendCOMPONENT_STATUS(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendCOMPONENT_STATUS: user specific code start
    // hc_tclClientThermalIncAdaptor::sendCOMPONENT_STATUS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_REJECT, (tU8)RejectReason, (tU8)RejectedMsgID};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendREJECT(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendREJECT: user specific code start
    // hc_tclClientThermalIncAdaptor::sendREJECT: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendGET_STATE() {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_GET_STATE};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendGET_STATE(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendGET_STATE: user specific code start
    // hc_tclClientThermalIncAdaptor::sendGET_STATE: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_STATE, (tU8)ModuleID, (tU8)ModuleState};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendSET_STATE(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendSET_STATE: user specific code start
    // hc_tclClientThermalIncAdaptor::sendSET_STATE: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_REQ_FAN, (tU8)ModuleID, (tU8)Percent};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendREQ_FAN(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendREQ_FAN: user specific code start
    // hc_tclClientThermalIncAdaptor::sendREQ_FAN: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_GET_TEMP, (tU8)ModuleID};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendGET_TEMP(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendGET_TEMP: user specific code start
    // hc_tclClientThermalIncAdaptor::sendGET_TEMP: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEMP, (tU8)ModuleID, (tU8)((0x00FF & ((tU16)Temperature)) >> 0), (tU8)((0xFF00 & ((tU16)Temperature)) >> 8)};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendSET_TEMP(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendSET_TEMP: user specific code start
    // hc_tclClientThermalIncAdaptor::sendSET_TEMP: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEST_TEMP, (tU8)ModuleID, (tU8)((0x00FF & ((tU16)Temperature)) >> 0), (tU8)((0xFF00 & ((tU16)Temperature)) >> 8)};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendSET_TEST_TEMP(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendSET_TEST_TEMP: user specific code start
    // hc_tclClientThermalIncAdaptor::sendSET_TEST_TEMP: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool hc_tclClientThermalIncAdaptor::sendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent) {
    tU8 au8Data[] = {(tU8)::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEST_FAN, (tU8)FanID, (tU8)Percent};
    ETG_TRACE_USR4(("hc_tclClientThermalIncAdaptor::sendSET_TEST_FAN(): INC interface is valid. Send now."));
    // hc_tclClientThermalIncAdaptor::sendSET_TEST_FAN: user specific code start
    // hc_tclClientThermalIncAdaptor::sendSET_TEST_FAN: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}

// hc_THERMALAdaptorAddClassPart: user specific code start
// hc_THERMALAdaptorAddClassPart: user specific code end
