#ifndef _I_THERMALINCADAPTOR_H_
#define _I_THERMALINCADAPTOR_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          I_hc_ClientThermalIncAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: fc_heatctrl
  * @Template:     IincAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "DatagramSocket.h"
#include "DatagramSocketCallbackIf.h"

//include base class
#include "hc_AppMain.h"

#include "hc_ClientThermalIncFiDef.h"

class ThermalIncCallbackIf;

class I_hc_tclClientThermalIncAdaptor : public DatagramSocketCallbackIf,  public hc_tclBaseIf
{
public:
    I_hc_tclClientThermalIncAdaptor(hc_tclAppMain* poMainAppl): hc_tclBaseIf(poMainAppl) {;}
    virtual ~I_hc_tclClientThermalIncAdaptor(){}

    virtual const tChar* getIfName() const { return "I_hc_tclClientThermalIncAdaptor"; };

    virtual tVoid vSetCallbackIf(ThermalIncCallbackIf* poCallback) = 0;

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
    virtual tBool sendREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
    virtual tBool sendGET_STATE() = 0;
    virtual tBool sendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState) = 0;
    virtual tBool sendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent) = 0;
    virtual tBool sendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID) = 0;
    virtual tBool sendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) = 0;
    virtual tBool sendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) = 0;
    virtual tBool sendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent) = 0;

    // I_hc_tclClientThermalIncAdaptor_AddClassPart: user specific code start
    // I_hc_tclClientThermalIncAdaptor_AddClassPart: user specific code end
};

#endif // _I_THERMALINCADAPTOR_H_

