/*****************************************************************************
* FILE:         hc_ClientSpm.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientSpm_H_
#define __hc_ClientSpm_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientSpm.h"
#include "hc_AppMain.h"

// hc_tclClientSpm_Include: user specific code start
// hc_tclClientSpm_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientSpmCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientSpm : public Ihc_tclClientSpm
{

public:
   virtual const tChar* getName() const { return "hc_tclClientSpm"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientSpm(tVoid); 
   hc_tclClientSpm(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientSpm();

   virtual tVoid vSetCallbackIf(hc_tclClientSpmCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientSpmDeclarations: user specific code start
   // hc_tclClientSpmDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientSpm' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientSpm& operator = (const hc_tclClientSpm &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientSpmCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData);

   // This method is used to send onoff trigger status of each substate
   virtual tBool sendOnOffTriggerMethodStart(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData);

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState) {
      rSubState             = _SubState_SubStatesStatus;
      rHwSubState           = _HwSubState_SubStatesStatus;
      rInternSubState       = _InternSubState_SubStatesStatus;
   }

   virtual tBool sendSubStatesGet();
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent) {
      rCvmEvent             = _CvmEvent_CvmEventStatus;
   }

   virtual tBool sendCvmEventGet();


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleSubStatesOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleCvmEventOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);

   // This method provides the list of all active substatetype
   virtual tVoid vHandleActiveOnOffTriggerStatus(amt_tclServiceData* poMessage);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tU32                                     _SubState_SubStatesStatus;
   tU32                                     _HwSubState_SubStatesStatus;
   tU32                                     _InternSubState_SubStatesStatus;
   spm_fi_tcl_SPM_e32_CVM_EVENT             _CvmEvent_CvmEventStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientSpm) 

// hc_tclClientSpmDeclarationsPart2: user specific code start
// hc_tclClientSpmDeclarationsPart2: user specific code end

};

#endif // __hc_ClientSpm_H_


