

/*****************************************************************************
* FILE:         hc_ClientSpm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientSpmIncludes: user specific code start
// hc_tclClientSpmIncludes: user specific code end

#include "hc_ClientSpm.h"
#include "hc_ClientSpmCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_SPM
#include "trcGenProj/Header/hc_ClientSpm.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SPM_SERVICE_ID              256
#define SPM_FI_MAJOR_VERSION        1
#define SPM_FI_MINOR_VERSION        4

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientSpm, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SUBSTATES, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSubStatesOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleCvmEventOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleActiveOnOffTriggerStatus )

   // hc_tclClientSpm_MsgMap: user specific code start
   // hc_tclClientSpm_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientSpm::
*             hc_tclClientSpm(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSpm::hc_tclClientSpm(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientSpm(poMainAppl, SPM_SERVICE_ID, SPM_FI_MAJOR_VERSION, SPM_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;
   _SubState_SubStatesStatus = 0;
   _HwSubState_SubStatesStatus = 0;
   _InternSubState_SubStatesStatus = 0;
   
   // hc_tclClientSpmConstructor: user specific code start
   // hc_tclClientSpmConstructor: user specific code end
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SUBSTATES);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_CVMEVENT);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientSpm::
*             ~hc_tclClientSpm(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSpm::~hc_tclClientSpm(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientSpmDestructor: user specific code start
   // hc_tclClientSpmDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientSpm.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpm::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSpm::vGetReferences() entered."));
   
   // hc_tclClientSpmvGetReferences: user specific code start
   // hc_tclClientSpmvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpm::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSpm::vStartCommunication() entered."));
   // hc_tclClientSpmvStartCommunication: user specific code start
   // hc_tclClientSpmvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpm::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientSpm::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientSpmvHandleMessage: user specific code start
   // hc_tclClientSpmvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpm::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientSpm::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientSpmvHandleTraceMessage: user specific code start
   // hc_tclClientSpmvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpm::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SubStates (SPM_COREFI_C_U16_SUBSTATES) -> Opcode: Set, Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Property support:      CvmEvent (SPM_COREFI_C_U16_CVMEVENT) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));

   // hc_tclClientSpmvTraceInfo: user specific code start
   // hc_tclClientSpmvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientSpm::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientSpmvOnServiceAvailable: user specific code start
   // hc_tclClientSpmvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpm::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientSpm::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientSpmvOnServiceUnavailable: user specific code start
   // hc_tclClientSpmvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_SUBSTATES
*******************************************************************************/

tVoid hc_tclClientSpm::vHandleSubStatesOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgSubStatesStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _SubState_SubStatesStatus = oStatus.SubState;
            _HwSubState_SubStatesStatus = oStatus.HwSubState;
            _InternSubState_SubStatesStatus = oStatus.InternSubState;

            ETG_TRACE_USR1(("hc_tclClientSpm::vHandleSubStatesOpStatus(): Status update message received for 'SPM_COREFI_C_U16_SUBSTATES' (FID: 0x000f)!"));

            onSubStatesStatus(oStatus.SubState, oStatus.HwSubState, oStatus.InternSubState);

            // vHandleSubStatesOpStatus: user specific code start
            // vHandleSubStatesOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientSpm::vHandleSubStatesOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientSpm::vHandleActiveOnOffTriggerStatus(amt_tclServiceData* poMessage) {
	   if (poMessage != NULL) {
	      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
	         fi_tclVisitorMessage            oInMsg( poMessage );
	         spm_corefi_tclMsgActiveOnOffTriggerStatus  oStatus;

	         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {


	            ETG_TRACE_USR1(("hc_tclClientSpm::vHandleActiveOnOffTriggerStatus(): Status update message received for 'SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER' (FID: 0x110f)!"));

	           // onSubStatesStatus(oStatus.SubState, oStatus.HwSubState, oStatus.InternSubState);

	            std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > mOnOffTriggerList = oStatus.tOnOffTriggerList;
	            ETG_TRACE_USR1(("hc_tclClientSpm::vHandleActiveOnOffTriggerStatus(): active components are "));

	            std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> >::iterator it = (oStatus.tOnOffTriggerList ).begin();
	            for ( ;it != (oStatus.tOnOffTriggerList ).end(); it++  )
	            {
	            	//ETG_TRACE_USR1((" \t [ Active Trigger : %u ]" , ETG_CENUM(spm_fi_tcl_SPM_e32_SubStateType , (tU32)*it) ));
	            }

	            // vHandleSubStatesOpStatus: user specific code start
	            // vHandleSubStatesOpStatus: user specific code end
	         } else {
	            ETG_TRACE_ERR(("hc_tclClientSpm::vHandleSubStatesOpStatus: Received message is invalid!"));
	         }

	         oStatus.vDestroy();
	      }
	   }
}


tVoid hc_tclClientSpm::onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState) {

   if (_poCallbackIf) _poCallbackIf->onSubStatesStatus(SubState, HwSubState, InternSubState); 

   // onSubStatesStatus: user specific code start
   // onSubStatesStatus: user specific code end

}

/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_CVMEVENT
*******************************************************************************/

tVoid hc_tclClientSpm::vHandleCvmEventOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgCvmEventStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _CvmEvent_CvmEventStatus = oStatus.CvmEvent;

            ETG_TRACE_USR1(("hc_tclClientSpm::vHandleCvmEventOpStatus(): Status update message received for 'SPM_COREFI_C_U16_CVMEVENT' (FID: 0x38)!"));

            onCvmEventStatus(oStatus.CvmEvent);

            // vHandleCvmEventOpStatus: user specific code start
            // vHandleCvmEventOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientSpm::vHandleCvmEventOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientSpm::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {

   if (_poCallbackIf) _poCallbackIf->onCvmEventStatus(CvmEvent); 

   // onCvmEventStatus: user specific code start
   // onCvmEventStatus: user specific code end

}



tBool hc_tclClientSpm::sendOnOffTriggerMethodStart(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) {

	ETG_TRACE_USR4(("sendOnOffTriggerMethodStart() entered."));
	tBool bRetVal = FALSE;
	   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {

		   spm_corefi_tclMsgOnOffTriggerMethodStart  oMethodStart;
		   oMethodStart.eSwitchOnTrigger =  SubStateType;
		   oMethodStart.bState 			 =  SubStateData;

		   fi_tclVisitorMessage oOutMessage(oMethodStart);
		   vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_ONOFFTRIGGER, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

		   ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

		   if (enResult != AIL_EN_N_NO_ERROR) {
		         // Error situation:
		         ETG_TRACE_ERR(( "hc_tclClientSpm::sendOnOffTriggerMethodStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, (tU32)enResult));
		      }
		  else
		      {
		         bRetVal = TRUE;
		      }

		   oMethodStart.vDestroy();
	   }
	   ETG_TRACE_USR4(("sendOnOffTriggerMethodStart() exit."));
}


tBool hc_tclClientSpm::sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgSubStatesSet  oSet;
      //the data content
      oSet.SubStateType = SubStateType;
      oSet.SubStateData = SubStateData;


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_SUBSTATES, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientSpm::sendSubStatesSet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_SUBSTATES, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}

tBool hc_tclClientSpm::sendSubStatesGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgSubStatesGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_SUBSTATES, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientSpm::sendSubStatesGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_SUBSTATES, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool hc_tclClientSpm::sendCvmEventGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgCvmEventGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_CVMEVENT, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientSpm::sendCvmEventGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_CVMEVENT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// hc_tclClientSpmhc_ClientSpm: user specific code start
// hc_tclClientSpmhc_ClientSpm: user specific code end

//EOF
