/*****************************************************************************
* FILE:         hc_ClientSensor.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientSensor_H_
#define __hc_ClientSensor_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientSensor.h"
#include "hc_AppMain.h"

// hc_tclClientSensor_Include: user specific code start
// hc_tclClientSensor_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientSensorCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientSensor : public Ihc_tclClientSensor
{

public:
   virtual const tChar* getName() const { return "hc_tclClientSensor"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientSensor(tVoid); 
   hc_tclClientSensor(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientSensor();

   virtual tVoid vSetCallbackIf(hc_tclClientSensorCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientSensorDeclarations: user specific code start
   // hc_tclClientSensorDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientSensor' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientSensor& operator = (const hc_tclClientSensor &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientSensorCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendGyroTemperatureGet();
   virtual tVoid getGyroTemperatureStatus(tF32& rGyroTemperature) {
      rGyroTemperature      = _GyroTemperature_GyroTemperatureStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleGyroTemperatureOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onGyroTemperatureStatus(tF32 GyroTemperature);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tF32                                     _GyroTemperature_GyroTemperatureStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientSensor) 

// hc_tclClientSensorDeclarationsPart2: user specific code start
// hc_tclClientSensorDeclarationsPart2: user specific code end

};

#endif // __hc_ClientSensor_H_


