

/*****************************************************************************
* FILE:         hc_ClientSensor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientSensorIncludes: user specific code start
// hc_tclClientSensorIncludes: user specific code end

#include "hc_ClientSensor.h"
#include "hc_ClientSensorCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_SENSOR
#include "trcGenProj/Header/hc_ClientSensor.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SENSOR_SERVICE_ID              176
#define SENSOR_FI_MAJOR_VERSION        1
#define SENSOR_FI_MINOR_VERSION        2

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientSensor, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleGyroTemperatureOpStatus)
   // hc_tclClientSensor_MsgMap: user specific code start
   // hc_tclClientSensor_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientSensor::
*             hc_tclClientSensor(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSensor::hc_tclClientSensor(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientSensor(poMainAppl, SENSOR_SERVICE_ID, SENSOR_FI_MAJOR_VERSION, SENSOR_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientSensor() entered."));
   _poCallbackIf = OSAL_NULL;
   _GyroTemperature_GyroTemperatureStatus = 0.0;
   
   // hc_tclClientSensorConstructor: user specific code start
   // hc_tclClientSensorConstructor: user specific code end
   vAddAutoRegisterForProperty(SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientSensor::
*             ~hc_tclClientSensor(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSensor::~hc_tclClientSensor(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientSensor() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientSensorDestructor: user specific code start
   // hc_tclClientSensorDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientSensor.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     SENSOR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensor::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSensor::vGetReferences() entered."));
   
   // hc_tclClientSensorvGetReferences: user specific code start
   // hc_tclClientSensorvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSensor::vStartCommunication() entered."));
   // hc_tclClientSensorvStartCommunication: user specific code start
   // hc_tclClientSensorvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensor::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientSensor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientSensorvHandleMessage: user specific code start
   // hc_tclClientSensorvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensor::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientSensor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientSensorvHandleTraceMessage: user specific code start
   // hc_tclClientSensorvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensor::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      GyroTemperature (SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE) -> Opcode: Get, UpReg, RelUpReg, Status, Error, "));

   // hc_tclClientSensorvTraceInfo: user specific code start
   // hc_tclClientSensorvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientSensor::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientSensorvOnServiceAvailable: user specific code start
   // hc_tclClientSensorvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensor::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientSensor::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientSensorvOnServiceUnavailable: user specific code start
   // hc_tclClientSensorvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE
*******************************************************************************/

tVoid hc_tclClientSensor::vHandleGyroTemperatureOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sensor_locationfi_tclMsgGyroTemperatureStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SENSOR_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _GyroTemperature_GyroTemperatureStatus = oStatus.GyroTemperature;

            ETG_TRACE_USR1(("hc_tclClientSensor::vHandleGyroTemperatureOpStatus(): Status update message received for 'SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE' (FID: 0x44)!"));

            onGyroTemperatureStatus(oStatus.GyroTemperature);

            // vHandleGyroTemperatureOpStatus: user specific code start
            // vHandleGyroTemperatureOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientSensor::vHandleGyroTemperatureOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientSensor::onGyroTemperatureStatus(tF32 GyroTemperature) {

   if (_poCallbackIf) _poCallbackIf->onGyroTemperatureStatus(GyroTemperature); 

   // onGyroTemperatureStatus: user specific code start
   // onGyroTemperatureStatus: user specific code end

}






tBool hc_tclClientSensor::sendGyroTemperatureGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sensor_locationfi_tclMsgGyroTemperatureGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientSensor::sendGyroTemperatureGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SENSOR_LOCATIONFI_C_U16_GYROTEMPERATURE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// hc_tclClientSensorhc_ClientSensor: user specific code start
// hc_tclClientSensorhc_ClientSensor: user specific code end

//EOF
