

/*****************************************************************************
* FILE:         hc_ClientMediaManager.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientMediaManagerIncludes: user specific code start
// hc_tclClientMediaManagerIncludes: user specific code end

#include "hc_ClientMediaManager.h"
#include "hc_ClientMediaManagerCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_MEDIAMANAGER
#include "trcGenProj/Header/hc_ClientMediaManager.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define MEDIAMANAGER_SERVICE_ID              385
#define MEDIAMANAGER_FI_MAJOR_VERSION        1
#define MEDIAMANAGER_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientMediaManager, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MPLAY_MMGRFI_C_U16_CDTEMP, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleCDTempOpStatus)
   // hc_tclClientMediaManager_MsgMap: user specific code start
   // hc_tclClientMediaManager_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaManager::
*             hc_tclClientMediaManager(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaManager::hc_tclClientMediaManager(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientMediaManager(poMainAppl, MEDIAMANAGER_SERVICE_ID, MEDIAMANAGER_FI_MAJOR_VERSION, MEDIAMANAGER_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientMediaManager() entered."));
   _poCallbackIf = OSAL_NULL;
   _CDTemp_CDTempStatus = 0;
   
   // hc_tclClientMediaManagerConstructor: user specific code start
   // hc_tclClientMediaManagerConstructor: user specific code end
   vAddAutoRegisterForProperty(MPLAY_MMGRFI_C_U16_CDTEMP);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaManager::
*             ~hc_tclClientMediaManager(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaManager::~hc_tclClientMediaManager(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientMediaManager() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientMediaManagerDestructor: user specific code start
   // hc_tclClientMediaManagerDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientMediaManager.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     MEDIAMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManager::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManager::vGetReferences() entered."));
   
   // hc_tclClientMediaManagervGetReferences: user specific code start
   // hc_tclClientMediaManagervGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManager::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManager::vStartCommunication() entered."));
   // hc_tclClientMediaManagervStartCommunication: user specific code start
   // hc_tclClientMediaManagervStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManager::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManager::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientMediaManagervHandleMessage: user specific code start
   // hc_tclClientMediaManagervHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManager::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientMediaManager::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientMediaManagervHandleTraceMessage: user specific code start
   // hc_tclClientMediaManagervHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManager::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      CDTemp (MPLAY_MMGRFI_C_U16_CDTEMP) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));

   // hc_tclClientMediaManagervTraceInfo: user specific code start
   // hc_tclClientMediaManagervTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientMediaManager::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientMediaManagervOnServiceAvailable: user specific code start
   // hc_tclClientMediaManagervOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManager::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientMediaManager::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientMediaManagervOnServiceUnavailable: user specific code start
   // hc_tclClientMediaManagervOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MPLAY_MMGRFI_C_U16_CDTEMP
*******************************************************************************/

tVoid hc_tclClientMediaManager::vHandleCDTempOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         mplay_mmgrfi_tclMsgCDTempStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, MEDIAMANAGER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _CDTemp_CDTempStatus = oStatus.CDTemp;
            _Status_CDTempStatus = oStatus.Status;

            ETG_TRACE_USR1(("hc_tclClientMediaManager::vHandleCDTempOpStatus(): Status update message received for 'MPLAY_MMGRFI_C_U16_CDTEMP' (FID: 0xC25)!"));

            onCDTempStatus(oStatus.CDTemp, oStatus.Status);

            // vHandleCDTempOpStatus: user specific code start
            // vHandleCDTempOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientMediaManager::vHandleCDTempOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientMediaManager::onCDTempStatus(tS16 CDTemp, mplay_fi_tcl_e8DriveTempSensorStatus Status) {

   if (_poCallbackIf) _poCallbackIf->onCDTempStatus(CDTemp, Status); 

   // onCDTempStatus: user specific code start
   // onCDTempStatus: user specific code end

}






tBool hc_tclClientMediaManager::sendCDTempGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mplay_mmgrfi_tclMsgCDTempGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MPLAY_MMGRFI_C_U16_CDTEMP, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientMediaManager::sendCDTempGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MPLAY_MMGRFI_C_U16_CDTEMP, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// hc_tclClientMediaManagerhc_ClientMediaManager: user specific code start
// hc_tclClientMediaManagerhc_ClientMediaManager: user specific code end

//EOF
