/*****************************************************************************
* FILE:         fc_heatctrl_Starter.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     appl_ClientStarter.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Create application specific objects here
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "hc_AppMain.h"

// AsfClientStarterIncludeTop: user specific code start
// AsfClientStarterIncludeTop: user specific code end

#include "hc_ServiceHeat.h"
#include "hc_ServiceHeatIf.h"
#include "hc_ClientSpm.h"
#include "hc_ClientSpmIf.h"
#include "hc_ClientDiaglog.h"
#include "hc_ClientDiaglogIf.h"
#include "hc_ClientAudioFunction.h"
#include "hc_ClientAudioFunctionIf.h"
#include "hc_ClientDimming.h"
#include "hc_ClientDimmingIf.h"
#include "hc_ClientSensor.h"
#include "hc_ClientSensorIf.h"
#include "hc_ClientDeviceManager.h"
#include "hc_ClientDeviceManagerIf.h"
#include "hc_ClientMediaManager.h"
#include "hc_ClientMediaManagerIf.h"
#include "hc_ClientMediaPlayer.h"
#include "hc_ClientMediaPlayerIf.h"
#include "hc_ClientThermal.h"
#include "hc_ClientThermalIncAdaptor.h"


// AsfClientStarterInclude: user specific code start
// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

#include "hc_tclSimuMode.h"
#include "hc_tclThermalSensorControl.h"
#include "hc_tclAbstractSensorControl.h"
#include "hc_ClientiMXtemp.h"
#include "hc_tclEmergencyFunctionControl.h"
#include "hc_tclITCControl.h"
#include "hc_tclFANControl.h"
#include "hc_tclCfgMgr.h"
#include "hc_tclDiagnosisListener.h"
#include "hc_tclClientTVMODULEtemp.h"
// AsfClientStarterInclude: user specific code end

void vAppProxyStarter(hc_tclAppMain *poServer){

    {
        // AsfClientStarterhc_tclServiceHeat: user specific code start
        // AsfClientStarterhc_tclServiceHeat: user specific code end
        {
            hc_tclServiceHeat *poCcaProxy = new hc_tclServiceHeat(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclServiceHeatIf *poCcaProxy = new hc_tclServiceHeatIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientSpm: user specific code start
        // AsfClientStarterhc_tclClientSpm: user specific code end
        {
            hc_tclClientSpm *poCcaProxy = new hc_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientSpmIf *poCcaProxy = new hc_tclClientSpmIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientDiaglog: user specific code start
        // AsfClientStarterhc_tclClientDiaglog: user specific code end
        {
            hc_tclClientDiaglog *poCcaProxy = new hc_tclClientDiaglog(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientDiaglogIf *poCcaProxy = new hc_tclClientDiaglogIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientAudioFunction: user specific code start
        // AsfClientStarterhc_tclClientAudioFunction: user specific code end
        {
            hc_tclClientAudioFunction *poCcaProxy = new hc_tclClientAudioFunction(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientAudioFunctionIf *poCcaProxy = new hc_tclClientAudioFunctionIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientDimming: user specific code start
        // AsfClientStarterhc_tclClientDimming: user specific code end
        {
            hc_tclClientDimming *poCcaProxy = new hc_tclClientDimming(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientDimmingIf *poCcaProxy = new hc_tclClientDimmingIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientSensor: user specific code start
        // AsfClientStarterhc_tclClientSensor: user specific code end
        {
            hc_tclClientSensor *poCcaProxy = new hc_tclClientSensor(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientSensorIf *poCcaProxy = new hc_tclClientSensorIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientDeviceManager: user specific code start
        // AsfClientStarterhc_tclClientDeviceManager: user specific code end
        {
            hc_tclClientDeviceManager *poCcaProxy = new hc_tclClientDeviceManager(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientDeviceManagerIf *poCcaProxy = new hc_tclClientDeviceManagerIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientMediaManager: user specific code start
        // AsfClientStarterhc_tclClientMediaManager: user specific code end
        {
            hc_tclClientMediaManager *poCcaProxy = new hc_tclClientMediaManager(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientMediaManagerIf *poCcaProxy = new hc_tclClientMediaManagerIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientMediaPlayer: user specific code start
        // AsfClientStarterhc_tclClientMediaPlayer: user specific code end
        {
            hc_tclClientMediaPlayer *poCcaProxy = new hc_tclClientMediaPlayer(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientMediaPlayerIf *poCcaProxy = new hc_tclClientMediaPlayerIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterhc_tclClientThermalIncAdaptor: user specific code start
        // AsfClientStarterhc_tclClientThermalIncAdaptor: user specific code end
        {
            hc_tclClientThermalIncAdaptor *poIncAdaptor = new hc_tclClientThermalIncAdaptor(poServer);
            poServer->vAddObj(poIncAdaptor);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            hc_tclClientThermal *poIncProxy = new hc_tclClientThermal(poServer);
            poServer->vAddObj(poIncProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
    }

    // AsfClientProxyStarter: user specific code start
    {
    	{
            poServer->vAddObj(new hc_tclSimuMode(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclCfgMgr(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclThermalSensorControl(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclAbstractSensorControl(poServer));
    	}
    	{
            poServer->vAddObj(new hc_ClientiMXtemp(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclEmergencyFunctionControl(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclITCControl(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclFANControl(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclDiagnosisListener(poServer));
    	}
    	{
            poServer->vAddObj(new hc_tclClientTVMODULEtemp(poServer));
    	}
    }
    // AsfClientProxyStarter: user specific code end
}
