/*****************************************************************************
* FILE:         hc_ClientThermal.cpp
* PROJECT:      CMD project
* SW-COMPONENT: fc_heatctrl
* Template:     incProxy.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "hc_ClientThermal.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL
#include "trcGenProj/Header/hc_ClientThermal.cpp.trc.h"
#endif

// Thermal_incProxy_tclMainIncludes: user specific code start
#include "I_hc_tclSimuMode.h"
#include "I_hc_tclThermalSensorControl.h"
// Thermal_incProxy_tclMainIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

hc_tclClientThermal::hc_tclClientThermal(hc_tclAppMain* poMainAppl):I_hc_tclClientThermal(poMainAppl)
{
   _bAvailable = FALSE;
   _poThermalInc = OSAL_NULL;

   // hc_tclClientThermal::hc_tclClientThermal: user specific code start
   // COMPONENT_STATUS handling
   m_bWait4Response_COMPONENT_STATUS = FALSE;
   m_u32RetryCount_Wait4Response_COMPONENT_STATUS = 0;
   m_enRequested_ApplicationStatus = ::thermal_management_inc_fi::eACTIVE;
   m_enReceived_ApplicationStatus = (::thermal_management_inc_fi::EApplicationStatus)0xFF;
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // thermal sensor control
   m_poThermalSensorControl = OSAL_NULL;
   // converter config
   (tVoid)memset((tVoid*)m_aenConvertSensorID, OSAL_NULL, sizeof(m_aenConvertSensorID));
   m_aenConvertSensorID[enThermalSensorID_Panel] = ::thermal_management_inc_fi::eDisplay;
   m_aenConvertSensorID[enThermalSensorID_CDDRIVE] = ::thermal_management_inc_fi::eCDDRIVE;
   m_aenConvertSensorID[enThermalSensorID_DVDDRIVE] = ::thermal_management_inc_fi::eDVDDRIVE;
   m_aenConvertSensorID[enThermalSensorID_GPS] = ::thermal_management_inc_fi::eGPS;
   m_aenConvertSensorID[enThermalSensorID_GYRO] = ::thermal_management_inc_fi::eGYRO;
   m_aenConvertSensorID[enThermalSensorID_EMMC] = ::thermal_management_inc_fi::eEMMC;
   m_aenConvertSensorID[enThermalSensorID_AMP] = ::thermal_management_inc_fi::ePower_Amp;
   m_aenConvertSensorID[enThermalSensorID_IMX] = ::thermal_management_inc_fi::eIMxIntel;
   m_aenConvertSensorID[enThermalSensorID_HEATSINK] = ::thermal_management_inc_fi::eAmpHeatSink;
   m_aenConvertSensorID[enThermalSensorID_BLUERAY] = ::thermal_management_inc_fi::eBlueRayDrive;
   m_aenConvertSensorID[enThermalSensorID_XMModule] = ::thermal_management_inc_fi::eXM;
   m_aenConvertSensorID[enThermalSensorID_TVModule] = ::thermal_management_inc_fi::eTV;
   m_aenConvertSensorID[enThermalSensorID_TVModuleSlave] = ::thermal_management_inc_fi::eTV_SLAVE;
   m_aenConvertSensorID[enThermalSensorID_Panel2] = ::thermal_management_inc_fi::eDISPLAY_2;

   m_aenConvertSensorState[enThermalState_UNAVAILABLE] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_CONFIGFAILURE] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_INIT] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_TEMPUNAVAIL] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_CRITICALLOW] = ::thermal_management_inc_fi::ePOOR;
   m_aenConvertSensorState[enThermalState_LOW] = ::thermal_management_inc_fi::eBAD;
   m_aenConvertSensorState[enThermalState_COLD] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_NORMAL] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_WARM] = ::thermal_management_inc_fi::eGOOD;
   m_aenConvertSensorState[enThermalState_HIGH] = ::thermal_management_inc_fi::eBAD;
   m_aenConvertSensorState[enThermalState_EMERGENCYHIGH] = ::thermal_management_inc_fi::ePOOR;
   // prepare local and remote hosted flag
   (tVoid)memset((tVoid*)m_bLocalHosted, OSAL_NULL, sizeof(m_bLocalHosted));
   m_bLocalHosted[::thermal_management_inc_fi::eIMxIntel] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eBlueRayDrive] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eCDDRIVE] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eGYRO] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::ePower_Amp] = TRUE;
#ifdef VARIANT_S_FTR_ENABLE_ONLY_PIVI_OF_AIVI
   m_bLocalHosted[::thermal_management_inc_fi::eDisplay] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eXM] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eTV] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eTV_SLAVE] = TRUE;
   m_bLocalHosted[::thermal_management_inc_fi::eDISPLAY_2] = TRUE;
#else
#endif //#ifdef VARIANT_S_FTR_ENABLE_ONLY_PIVI_OF_AIVI
   (tVoid)memset((tVoid*)m_bRemoteHosted, OSAL_NULL, sizeof(m_bRemoteHosted));
#ifdef VARIANT_S_FTR_ENABLE_ONLY_PIVI_OF_AIVI
   m_bRemoteHosted[::thermal_management_inc_fi::eXM] = TRUE;
#else
   m_bRemoteHosted[::thermal_management_inc_fi::eDisplay] = TRUE;
#endif //#ifndef VARIANT_S_FTR_ENABLE_ONLY_PIVI_OF_AIVI
   m_bRemoteHosted[::thermal_management_inc_fi::eEMMC] = TRUE;
   m_bRemoteHosted[::thermal_management_inc_fi::eAmpHeatSink] = TRUE;
   // prepare response supervision
   m_bResponseTimerActive = FALSE;
   (tVoid)memset((tVoid*)m_tResponseTimer, OSAL_NULL, sizeof(m_tResponseTimer));
   (tVoid)memset((tVoid*)&m_oINCResponseTimeout, OSAL_NULL, sizeof(m_oINCResponseTimeout));
   m_oINCResponseTimeout.eCmd = hc_tclBaseIf::eTriggerINCResponseTomeout;
   (tVoid)OSAL_szStringNCopy(m_oINCResponseTimeout.strClassName, "I_hc_tclClientThermal", sizeof(m_oINCResponseTimeout.strClassName)-1);
   if (OSAL_OK != OSAL_s32TimerCreate( (OSAL_tpfCallback)cb_vResponseTimer, (tVoid*)this, &m_hResponseTimer))
   {
	   ETG_TRACE_FATAL(("hc_tclClientThermal::hc_tclClientThermal: couldn't create response supervision timer!"));
	   m_hResponseTimer = OSAL_NULL;
   }
   else
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hResponseTimer, 0, 0);
   }
   // prepare pending C_SET_STATE requests for all local hosted sensors
   (tVoid)memset((tVoid*)m_bPending_C_SET_STATE, OSAL_NULL, sizeof(m_bPending_C_SET_STATE));
   (tVoid)memset((tVoid*)&m_enModuleID_C_SET_STATE, OSAL_NULL, sizeof(m_enModuleID_C_SET_STATE));
   // prepare pending C_REQ_FAN requests for all local hosted sensors
   (tVoid)memset((tVoid*)m_bPending_C_REQ_FAN, OSAL_NULL, sizeof(m_bPending_C_REQ_FAN));
   (tVoid)memset((tVoid*)&m_enModuleID_C_REQ_FAN, OSAL_NULL, sizeof(m_enModuleID_C_REQ_FAN));
   // prepare pending C_GET_TEMP requests for all local hosted sensors
   (tVoid)memset((tVoid*)m_bPending_C_GET_TEMP, OSAL_NULL, sizeof(m_bPending_C_GET_TEMP));
   (tVoid)memset((tVoid*)&m_enModuleID_C_GET_TEMP, OSAL_NULL, sizeof(m_enModuleID_C_GET_TEMP));
   // prepare pending C_SET_TEMP requests for all local hosted sensors
   (tVoid)memset((tVoid*)m_bPending_C_SET_TEMP, OSAL_NULL, sizeof(m_bPending_C_SET_TEMP));
   (tVoid)memset((tVoid*)&m_enModuleID_C_SET_TEMP, OSAL_NULL, sizeof(m_enModuleID_C_SET_TEMP));
   // prepare pending C_SET_TEST_TEMP requests for all local hosted sensors
   (tVoid)memset((tVoid*)m_bPending_C_SET_TEST_TEMP, OSAL_NULL, sizeof(m_bPending_C_SET_TEST_TEMP));
   (tVoid)memset((tVoid*)&m_enModuleID_C_SET_TEST_TEMP, OSAL_NULL, sizeof(m_enModuleID_C_SET_TEST_TEMP));
   // prepare pending C_SET_TEST_FAN requests for all local hosted sensors
   (tVoid)memset((tVoid*)&m_u8FanTestSpeedPercent, OSAL_NULL, sizeof(m_u8FanTestSpeedPercent));
   (tVoid)memset((tVoid*)m_bPending_C_SET_TEST_FAN, OSAL_NULL, sizeof(m_bPending_C_SET_TEST_FAN));
   m_enFanID_C_SET_TEST_FAN = ::thermal_management_inc_fi::eFanIDMax;
   // prepare internal messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
	   m_aoThermalInfo[_u16Index].eCmd = hc_tclBaseIf::eNewThermalInfo_AUTOSAR;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u16Index].strClassName)-1);
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateSupported = TRUE;
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName,
			   "I_hc_tclClientThermal", sizeof(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName)-1);
	   switch(_u16Index)
	   {
	   case (tU16)::thermal_management_inc_fi::eIMxIntel:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_IMX;
		   break;
	   case (tU16)::thermal_management_inc_fi::eBlueRayDrive:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_BLUERAY;
		   break;
	   case (tU16)::thermal_management_inc_fi::eDisplay:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_Panel;
		   break;
	   case (tU16)::thermal_management_inc_fi::eEMMC:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_EMMC;
		   break;
	   case (tU16)::thermal_management_inc_fi::eCDDRIVE:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_CDDRIVE;
		   break;
	   case (tU16)::thermal_management_inc_fi::eDVDDRIVE:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_DVDDRIVE;
		   break;
	   case (tU16)::thermal_management_inc_fi::eGPS:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_GPS;
		   break;
	   case (tU16)::thermal_management_inc_fi::eGYRO:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_GYRO;
		   break;
	   case (tU16)::thermal_management_inc_fi::eAmpHeatSink:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_HEATSINK;
		   break;
	   case (tU16)::thermal_management_inc_fi::ePower_Amp:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_AMP;
		   break;
	   default:
		   {
			   if((tU16)eModuleID_OVERALL == _u16Index)
			   {
				   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_V850;
				   m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureSupported = FALSE;
			   }
		   }
		   break;
	   }
   }
   // hc_tclClientThermal::hc_tclClientThermal: user specific code end
   
   return;
}

hc_tclClientThermal::~hc_tclClientThermal(tVoid)
{
   _poThermalInc = OSAL_NULL;

   // hc_tclClientThermal::~hc_tclClientThermal: user specific code start

   // stop response supervision timer
   m_bResponseTimerActive = FALSE;
   if (OSAL_NULL != m_hResponseTimer)
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hResponseTimer, 0, 0);
	   (tVoid)OSAL_s32TimerDelete(m_hResponseTimer);
   }
   // reset all references
   m_poThermalSensorControl = OSAL_NULL;
   m_poSimuMode = OSAL_NULL;

   // hc_tclClientThermal::~hc_tclClientThermal: user specific code end
}

tVoid hc_tclClientThermal::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientThermal::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientThermal::vHandleMessage: user specific code start
   HC_NULL_POINTER_CHECK(pMsg);
   switch(pMsg->eCmd)
   {
	case hc_tclBaseIf::eUpdateSimuMode:

		if (FALSE == pMsg->u.UpdateSimuMode.bState)
 		{
 		   for (tU32 _u32Index = 0; eModuleID_MAX > _u32Index; ++_u32Index)
 		   {
 		   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
 		        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
 		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
 		   }
 		}
	   	break;
   case hc_tclBaseIf::eUpdateSensorState:
	   {
			::thermal_management_inc_fi::EModuleID _enModuleID = enConvertSensorID(pMsg->u.tThermalSensorInfo.enSensorID);
			::thermal_management_inc_fi::EModuleState _enModuleState = enConvertSensorState(pMsg->u.tThermalSensorInfo.enSensorStateLastValid);
			if (TRUE == IsValidModuleID(_enModuleID))
			{
				if (FALSE == m_bLocalHosted[_enModuleID] && FALSE == m_bRemoteHosted[_enModuleID])
					m_bLocalHosted[_enModuleID] = TRUE;
				if (TRUE == m_bLocalHosted[_enModuleID])
					(tVoid)qsendSET_STATE(_enModuleID, _enModuleState);
			}
	   }
	   break;
   case hc_tclBaseIf::eUpdateSensorTemperature:
	   {
		   ::thermal_management_inc_fi::EModuleID _enModuleID = enConvertSensorID(pMsg->u.tThermalSensorInfo.enSensorID);
			if (TRUE == IsValidModuleID(_enModuleID))
			{
				tS16 _s16Temperature = (TRUE == pMsg->u.tThermalSensorInfo.bTemperatureValid)?((tS16)pMsg->u.tThermalSensorInfo.tTemperature):0;
				if (FALSE == m_bLocalHosted[_enModuleID] && FALSE == m_bRemoteHosted[_enModuleID])
					m_bLocalHosted[_enModuleID] = TRUE;
				if (TRUE == m_bLocalHosted[_enModuleID] && TRUE == pMsg->u.tThermalSensorInfo.bTemperatureValid)
					(tVoid)qsendSET_TEMP(_enModuleID,_s16Temperature);
			}
	   }
	   break;
   case hc_tclBaseIf::eUpdateFanSpeed:
	   {
		   ::thermal_management_inc_fi::EModuleID _enModuleID = enConvertSensorID(pMsg->u.tFANSpeed.enSensorID);
		   if (TRUE == IsValidModuleID(_enModuleID))
		   {
			   if (FALSE == m_bLocalHosted[_enModuleID] && FALSE == m_bRemoteHosted[_enModuleID])
				   m_bLocalHosted[_enModuleID] = TRUE;
			   if (TRUE == m_bLocalHosted[_enModuleID])
				   (tVoid)qsendREQ_FAN(_enModuleID,pMsg->u.tFANSpeed.u8Speed);
		   }
	   }
	   break;
   case hc_tclBaseIf::eUpdateFanTestSpeed:
	   {
		   ::thermal_management_inc_fi::EFanID _enFanID = (::thermal_management_inc_fi::EFanID)pMsg->u.tFANTestSpeed.u8FanID;
		   if (TRUE == IsValidFanID(_enFanID))
		   {
			   (tVoid)qsendSET_TEST_FAN(_enFanID,pMsg->u.tFANTestSpeed.u8Speed);
		   }
	   }
	   break;
   case hc_tclBaseIf::eTriggerINCResponseTomeout:
	   {
		   vHandle_ResponsTimer();
	   }
	   break;
   default:
	   break;
   }
   // hc_tclClientThermal::vHandleMessage: user specific code end

}

tVoid hc_tclClientThermal::vGetReferences()
{
   ETG_TRACE_USR4(("hc_tclClientThermal::vGetReferences() entered."));

   _poThermalInc = dynamic_cast<I_hc_tclClientThermalIncAdaptor*>(_cpoMain->getHandler("I_hc_tclClientThermalIncAdaptor"));
   HC_NULL_POINTER_CHECK(_poThermalInc);
   _poThermalInc->vSetCallbackIf(this);

   // hc_tclClientThermal::vGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));
   m_poThermalSensorControl = dynamic_cast<I_hc_tclThermalSensorControl*>(_cpoMain->getHandler("I_hc_tclThermalSensorControl"));
   // hc_tclClientThermal::vGetReferences: user specific code end
}


tVoid hc_tclClientThermal::vTraceInfo()
{
   ETG_TRACE_USR4(("hc_tclClientThermal::vTraceInfo() entered."));
   // hc_tclClientThermal::vTraceInfo: user specific code start
   // hc_tclClientThermal::vTraceInfo: user specific code end
}


tVoid hc_tclClientThermal::vStartCommunication(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vStartCommunication() entered."));
    if (sendCOMPONENT_STATUS() == FALSE) {
        ETG_TRACE_FATAL(("hc_tclClientThermal::vStartCommunication(): Failed to send component state!!!"));
    }

    // hc_tclClientThermal::vStartCommunication: user specific code start

    // COMPONENT_STATUS handling
    m_enRequested_ApplicationStatus = ::thermal_management_inc_fi::eACTIVE;
    m_bWait4Response_COMPONENT_STATUS = TRUE;
    ETG_TRACE_USR1(("vStartCommunication: COMPONENT_STATUS ... requested %u, received %u, waiting %d",
    		ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enRequested_ApplicationStatus),
			ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enReceived_ApplicationStatus),
			ETG_ENUM(HC_Bool, bWait4Response_COMPONENT_STATUS()) ));

    // start response supervision
    m_bResponseTimerActive = TRUE;
    if (OSAL_NULL != m_hResponseTimer)
    {
       (tVoid)OSAL_s32TimerSetTime(m_hResponseTimer, HC_TCLCLIENTTHERMAL_RESPONSE_TIMEOUT_MS, 0);
    }

    // hc_tclClientThermal::vStartCommunication: user specific code end
}

void hc_tclClientThermal::onCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onCOMPONENT_STATUS():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_COMPONENT_STATUS: ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));

    if (ApplicationStatus == ::thermal_management_inc_fi::eACTIVE) {
        _bAvailable = TRUE;
    }    

    // hc_tclClientThermal_onCOMPONENT_STATUS: user specific code start
    vHandle_Response_COMPONENT_STATUS(ApplicationStatus);

    if (ApplicationStatus != ::thermal_management_inc_fi::eACTIVE) {
        _bAvailable = FALSE;
    }
    else
    {
		// ... inform SCC about local hosted sensor states
		if (OSAL_NULL != m_poThermalSensorControl)
		{
			for (tU32 _u32Idx = 0; (tU32)enThermalSensorID_MAX > _u32Idx; ++_u32Idx)
			{
				::thermal_management_inc_fi::EModuleID _enModuleID = enConvertSensorID((tenThermalSensorID)_u32Idx);
				::thermal_management_inc_fi::EModuleState _enState = enConvertSensorState(
						m_poThermalSensorControl->enGetSensorStateLastValid((tenThermalSensorID)_u32Idx) );
				if (TRUE == m_bLocalHosted[_enModuleID])
					(tVoid)qsendSET_STATE(_enModuleID, _enState);
			}
			vHandlePending_C_SET_TEMP();
		}
    }
    // ... send all available thermal informations
    for (tU32 _u32Index = 0; eModuleID_MAX > _u32Index; ++_u32Index)
    {
    	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = _bAvailable;
    	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
            || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
    		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
    			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
    }
    // hc_tclClientThermal_onCOMPONENT_STATUS: user specific code end
}
void hc_tclClientThermal::onREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onREJECT():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u, RejectedMsgID: %d", ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), RejectedMsgID));

    // hc_tclClientThermal_onREJECT: user specific code start
    switch (RejectedMsgID)
    {
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_STATE:
		{
		    qrejectSET_STATE(RejectReason);
		}
		break;
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_REQ_FAN:
		{
		    qrejectREQ_FAN(RejectReason);
		}
		break;
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_GET_TEMP:
		{
		    qrejectGET_TEMP(RejectReason);
		}
		break;
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEMP:
		{
		    qrejectSET_TEMP(RejectReason);
		}
		break;
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEST_TEMP:
		{
		    qrejectSET_TEST_TEMP(RejectReason);
		}
		break;
    case ::thermal_management_inc_fi::eSCC_THERMAL_MANAGEMENT_C_SET_TEST_FAN:
		{
		    qrejectSET_TEST_FAN(RejectReason);
		}
		break;
    default:
		{
		    ETG_TRACE_FATAL(("hc_tclClientThermal::onREJECT():  unhandled eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for RejectedMsgID: %u",
		    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MSG_ID, RejectedMsgID)));
		}
		break;
    }
    // hc_tclClientThermal_onREJECT: user specific code end
}
void hc_tclClientThermal::onGET_STATE(::thermal_management_inc_fi::EModuleState ModuleState) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onGET_STATE():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_GET_STATE: ModuleState: %u", ETG_ENUM(HC_THERMAL_MODULESTATE, ModuleState)));

    // hc_tclClientThermal_onGET_STATE: user specific code start
	m_aoThermalInfo[eModuleID_OVERALL].u.tThermalInfo.bSensorStateReceived = TRUE;
	m_aoThermalInfo[eModuleID_OVERALL].u.tThermalInfo.uSensorState.enAUTOSAR = ModuleState;
	m_bRemoteHosted[eModuleID_OVERALL] = TRUE;
	if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eModuleID_OVERALL]);
    // hc_tclClientThermal_onGET_STATE: user specific code end
}
void hc_tclClientThermal::onSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onSET_STATE():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_STATE: ModuleID: %u, ModuleState: %u", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), ETG_ENUM(HC_THERMAL_MODULESTATE, ModuleState)));

    // hc_tclClientThermal_onSET_STATE: user specific code start
    qonSET_STATE( ModuleID, ModuleState);
    if (TRUE == IsValidModuleID(ModuleID))
    {
        if (FALSE == m_bLocalHosted[ModuleID])
        {
        	m_aoThermalInfo[ModuleID].u.tThermalInfo.bSensorStateReceived = TRUE;
        	m_aoThermalInfo[ModuleID].u.tThermalInfo.uSensorState.enAUTOSAR = ModuleState;
        	if (FALSE == m_bLocalHosted[ModuleID] && FALSE == m_bRemoteHosted[ModuleID])
        		m_bRemoteHosted[ModuleID] = TRUE;
        	if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
        		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[ModuleID]);
        }
    }
    // hc_tclClientThermal_onSET_STATE: user specific code end
}
void hc_tclClientThermal::onREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onREQ_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REQ_FAN: ModuleID: %u, Percent: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Percent));

    // hc_tclClientThermal_onREQ_FAN: user specific code start
    qonREQ_FAN(ModuleID,Percent);
    // hc_tclClientThermal_onREQ_FAN: user specific code end
}
void hc_tclClientThermal::onGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onGET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_GET_TEMP: ModuleID: %u, Temperature: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature));

    // hc_tclClientThermal_onGET_TEMP: user specific code start
    qonGET_TEMP(ModuleID,Temperature);
    if (((tU32)eModuleID_MAX > (tU32)ModuleID) && (FALSE == m_bLocalHosted[ModuleID]))
    {
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.bTemperatureReceived = TRUE;
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.tTemperature = (tS16Temperature)Temperature;
    	if (FALSE == m_bLocalHosted[ModuleID] && FALSE == m_bRemoteHosted[ModuleID])
    		m_bRemoteHosted[ModuleID] = TRUE;
    	if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
    		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[ModuleID]);
    }
    // hc_tclClientThermal_onGET_TEMP: user specific code end
}
void hc_tclClientThermal::onSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onSET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEMP: ModuleID: %u, Temperature: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature));

    // hc_tclClientThermal_onSET_TEMP: user specific code start
    qonSET_TEMP( ModuleID, Temperature);
    if (TRUE == IsValidModuleID(ModuleID))
    {
        if (FALSE == m_bLocalHosted[ModuleID])
        {
        	m_aoThermalInfo[ModuleID].u.tThermalInfo.bTemperatureReceived = TRUE;
        	m_aoThermalInfo[ModuleID].u.tThermalInfo.tTemperature = (tS16Temperature)Temperature;
        	if (FALSE == m_bLocalHosted[ModuleID] && FALSE == m_bRemoteHosted[ModuleID])
        		m_bRemoteHosted[ModuleID] = TRUE;
        	if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
        		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[ModuleID]);
        }
    }
    // hc_tclClientThermal_onSET_TEMP: user specific code end
}
void hc_tclClientThermal::onSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onSET_TEST_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEST_TEMP: ModuleID: %u, Temperature: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature));

    // hc_tclClientThermal_onSET_TEST_TEMP: user specific code start
    qonSET_TEST_TEMP( ModuleID, Temperature);
    // hc_tclClientThermal_onSET_TEST_TEMP: user specific code end
}
void hc_tclClientThermal::onSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Persent) {
    ETG_TRACE_USR1(("hc_tclClientThermal::onSET_TEST_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEST_FAN: FanID: %u, Persent: %d", ETG_ENUM(HC_THERMAL_FANID, FanID), Persent));

    // hc_tclClientThermal_onSET_TEST_FAN: user specific code start
    qonSET_TEST_FAN(FanID, Persent);
    // hc_tclClientThermal_onSET_TEST_FAN: user specific code end
}

tBool hc_tclClientThermal::sendCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendCOMPONENT_STATUS():  ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));
    if (_poThermalInc) {
        return _poThermalInc->sendCOMPONENT_STATUS(ApplicationStatus, ApplicationVersion);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendREJECT():  RejectReason: %u, RejectedMsgID: %d", ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), RejectedMsgID));
    if (_poThermalInc) {
        return _poThermalInc->sendREJECT(RejectReason, RejectedMsgID);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendGET_STATE() {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendGET_STATE():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendGET_STATE();
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendSET_STATE():  ModuleID: %u, ModuleState: %u", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), ETG_ENUM(HC_THERMAL_MODULESTATE, ModuleState)));
    if (_poThermalInc) {
        return _poThermalInc->sendSET_STATE(ModuleID, ModuleState);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendREQ_FAN():  ModuleID: %u, Percent: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Percent));
    if (_poThermalInc) {
        return _poThermalInc->sendREQ_FAN(ModuleID, Percent);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendGET_TEMP():  ModuleID: %u", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID)));
    if (_poThermalInc) {
        return _poThermalInc->sendGET_TEMP(ModuleID);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendSET_TEMP():  ModuleID: %u, Temperature: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature));
    if (_poThermalInc) {
        return _poThermalInc->sendSET_TEMP(ModuleID, Temperature);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendSET_TEST_TEMP():  ModuleID: %u, Temperature: %d", ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature));
    if (_poThermalInc) {
        return _poThermalInc->sendSET_TEST_TEMP(ModuleID, Temperature);
    }
    return FALSE;
}
tBool hc_tclClientThermal::sendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent) {
    ETG_TRACE_USR1(("hc_tclClientThermal::sendSET_TEST_FAN():  FanID: %u, Percent: %d", ETG_ENUM(HC_THERMAL_FANID, FanID), Percent));
    if (_poThermalInc) {
        return _poThermalInc->sendSET_TEST_FAN(FanID, Percent);
    }
    return FALSE;
}

// hc_tclClientThermalAddClassPart: user specific code start
/*******************************************************************************
*
* FUNCTION:    u8SetFANSpeed()
*
* DESCRIPTION: set the speed of specified fan
*
* PARAMETER:   tenFANID 				enFanID
*              tU8 u8Speed 				fan speed in percent
*
* RETURNVALUE: tU8                      set fan speed
*
*******************************************************************************/
tU8 hc_tclClientThermal::u8SetFANSpeed(tenFANID enFanID, tU8 u8Speed)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::u8SetFANSpeed():  speed: %u", u8Speed ));

    ::thermal_management_inc_fi::EFanID FanID = enConvertFanID(enFanID);
    if (TRUE == qsendSET_TEST_FAN(FanID, u8Speed))
    {
    	return u8Speed;
    }
    return 0;
}

/*******************************************************************************
*
* FUNCTION:    u8SetFANSpeed()
*
* DESCRIPTION: set the FAN speed of specified thermal sensor
*
* PARAMETER:   tenThermalSensorID enSensorID
*              tU8 u8Speed 				fan speed in percent
*
* RETURNVALUE: tU8                      set fan speed
*
*******************************************************************************/
tU8 hc_tclClientThermal::u8SetFANSpeed(tenThermalSensorID enSensorID, tU8 u8Speed)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::u8SetFANSpeed():  sensor: %u speed: %u",
    		ETG_ENUM(HC_SensorID, enSensorID), u8Speed ));

    ::thermal_management_inc_fi::EModuleID _enModuleID = enConvertSensorID(enSensorID);
    if (TRUE == qsendREQ_FAN(_enModuleID, u8Speed))
    {
    	return u8Speed;
    }
    return 0;
}

/*******************************************************************************
*
* FUNCTION:    u8GetFANSpeed()
*
* DESCRIPTION: get the FAN speed
*
* PARAMETER:   none
*
* RETURNVALUE: tU8                      fan speed in percent
*
*******************************************************************************/
tU8 hc_tclClientThermal::u8GetFANSpeed(tVoid) const
{
    ETG_TRACE_USR1(("hc_tclClientThermal::u8GetFANSpeed(): enter" ));

    if (100 >= m_u8FanTestSpeedPercent[::thermal_management_inc_fi::eFAN_1])
    {
    	return m_u8FanTestSpeedPercent[::thermal_management_inc_fi::eFAN_1];
    }
    return 0;
}

/*******************************************************************************
*
* FUNCTION:    qsendSET_STATE()
*
* DESCRIPTION: queue C_SET_STATE request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              ::thermal_management_inc_fi::EModuleState ModuleState
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID,
		::thermal_management_inc_fi::EModuleState ModuleState)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendSET_STATE():  ModuleID: %u, ModuleState: %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), ETG_ENUM(HC_THERMAL_MODULESTATE, ModuleState)));
    if (TRUE == IsValidModuleID(ModuleID))
    {
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.uSensorState.enAUTOSAR = ModuleState;
    	m_bPending_C_SET_STATE[ModuleID] = TRUE;
    	vHandlePending_C_SET_STATE();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonSET_STATE()
*
* DESCRIPTION: handle active queued C_SET_STATE request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              ::thermal_management_inc_fi::EModuleState ModuleState
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID,
		::thermal_management_inc_fi::EModuleState ModuleState)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonSET_STATE():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_STATE: ModuleID: %u, ModuleState: %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), ETG_ENUM(HC_THERMAL_MODULESTATE, ModuleState)));

	if (m_enModuleID_C_SET_STATE == ModuleID
		&& TRUE == IsValidModuleID(ModuleID))
	{
		// reset active queued Request C_SET_STATE
		m_enModuleID_C_SET_STATE = (::thermal_management_inc_fi::EModuleID)0;
		// stop timer of C_Set_State response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_STATE);
	}
	vHandlePending_C_SET_STATE();
}

/*******************************************************************************
*
* FUNCTION:    qrejectSET_STATE()
*
* DESCRIPTION: handle active queued C_SET_STATE request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectSET_STATE(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectSET_STATE():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for module %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE) ));

	m_enModuleID_C_SET_STATE = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_STATE response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_STATE);
	vHandlePending_C_SET_STATE();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutSET_STATE()
*
* DESCRIPTION: handle timeout of active queued C_SET_STATE request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutSET_STATE(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutSET_STATE():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE) ));

	m_enModuleID_C_SET_STATE = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_STATE response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_STATE);
	vHandlePending_C_SET_STATE();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_SET_STATE()
*
* DESCRIPTION: handle pending request C_SET_STATE
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_SET_STATE(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_SET_STATE():  entered."));
	if (FALSE == IsValidModuleID(m_enModuleID_C_SET_STATE) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_SET_STATE response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_STATE);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (tU32)eModuleID_MAX > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_SET_STATE[_u32Idx])
			{
				m_enModuleID_C_SET_STATE = (::thermal_management_inc_fi::EModuleID)_u32Idx;
				if (FALSE == sendSET_STATE( m_enModuleID_C_SET_STATE, m_aoThermalInfo[_u32Idx].u.tThermalInfo.uSensorState.enAUTOSAR))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_SET_STATE(): sendSET_STATE failed for module %u and state %u",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE),
				    		ETG_ENUM(HC_THERMAL_MODULESTATE, m_aoThermalInfo[_u32Idx].u.tThermalInfo.uSensorState.enAUTOSAR) ));
				    m_enModuleID_C_SET_STATE = ::thermal_management_inc_fi::eModuleIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR2(("hc_tclClientThermal::vHandlePending_C_SET_STATE(): sendSET_STATE successful for module %u and state %u",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE),
				    		ETG_ENUM(HC_THERMAL_MODULESTATE, m_aoThermalInfo[_u32Idx].u.tThermalInfo.uSensorState.enAUTOSAR) ));
				    m_bPending_C_SET_STATE[_u32Idx] = FALSE;
				    // start timer of C_SET_STATE response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_SET_STATE);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION:    qsendREQ_FAN()
*
* DESCRIPTION: queue C_REQ_FAN request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tU8 Percent
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendREQ_FAN():  ModuleID: %u, Percent: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Percent ));
    if (TRUE == IsValidModuleID(ModuleID))
    {
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.u8FanSpeedPercent = Percent;
    	m_bPending_C_REQ_FAN[ModuleID] = TRUE;
    	vHandlePending_C_REQ_FAN();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonREQ_FAN()
*
* DESCRIPTION: handle active queued C_REQ_FAN request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              ::thermal_management_inc_fi::EModuleState ModuleState
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonREQ_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REQ_FAN: ModuleID: %u, Percent: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Percent ));

	if (m_enModuleID_C_REQ_FAN == ModuleID
		&& TRUE == IsValidModuleID(ModuleID))
	{
		// reset active queued Request C_SetState
		m_enModuleID_C_REQ_FAN = (::thermal_management_inc_fi::EModuleID)0;
		// stop timer of C_REQ_FAN response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_REQ_FAN);
	}
	vHandlePending_C_REQ_FAN();
}

/*******************************************************************************
*
* FUNCTION:    qrejectREQ_FAN()
*
* DESCRIPTION: handle active queued C_REQ_FAN request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectREQ_FAN(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectREQ_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for module %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_REQ_FAN) ));

    m_enModuleID_C_REQ_FAN = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_REQ_FAN response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_REQ_FAN);
	vHandlePending_C_REQ_FAN();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutREQ_FAN()
*
* DESCRIPTION: handle timeout of active queued C_REQ_FAN request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutREQ_FAN(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutREQ_FAN():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_REQ_FAN) ));

    m_enModuleID_C_REQ_FAN = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_REQ_FAN response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_REQ_FAN);
	vHandlePending_C_REQ_FAN();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_REQ_FAN()
*
* DESCRIPTION: handle pending request C_REQ_FAN
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_REQ_FAN(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_REQ_FAN():  entered."));
	if (FALSE == IsValidModuleID(m_enModuleID_C_REQ_FAN) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_REQ_FAN response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_REQ_FAN);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (tU32)eModuleID_MAX > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_REQ_FAN[_u32Idx])
			{
				m_enModuleID_C_REQ_FAN = (::thermal_management_inc_fi::EModuleID)_u32Idx;
				if (FALSE == sendREQ_FAN( m_enModuleID_C_REQ_FAN, m_aoThermalInfo[_u32Idx].u.tThermalInfo.u8FanSpeedPercent))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_REQ_FAN(): sendREQ_FAN failed for module %u and percent %d",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE),
				    		m_aoThermalInfo[_u32Idx].u.tThermalInfo.u8FanSpeedPercent ));
				    m_enModuleID_C_REQ_FAN = ::thermal_management_inc_fi::eModuleIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR2(("hc_tclClientThermal::vHandlePending_C_REQ_FAN(): sendREQ_FAN successful for module %u and percent %d",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_STATE),
				    		m_aoThermalInfo[_u32Idx].u.tThermalInfo.u8FanSpeedPercent ));
				    m_bPending_C_REQ_FAN[_u32Idx] = FALSE;
				    // start timer of C_REQ_FAN response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_REQ_FAN);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION:    qsendGET_TEMP()
*
* DESCRIPTION: queue C_GET_TEMP request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendGET_TEMP():  ModuleID: %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID) ));
    if (TRUE == IsValidModuleID(ModuleID))
    {
    	m_bPending_C_GET_TEMP[ModuleID] = TRUE;
    	vHandlePending_C_GET_TEMP();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonGET_TEMP()
*
* DESCRIPTION: handle active queued C_GET_TEMP request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tS16 Temperature
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID,
		tS16 Temperature)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonGET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_GET_TEMP: ModuleID: %u, Temperature: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature ));

	if (m_enModuleID_C_GET_TEMP == ModuleID
		&& TRUE == IsValidModuleID(ModuleID))
	{
		// reset active queued Request C_GET_TEMP
		m_enModuleID_C_GET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
		// stop timer of C_GET_TEMP response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_GET_TEMP);
	}
	vHandlePending_C_GET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qrejectGET_TEMP()
*
* DESCRIPTION: handle active queued C_GET_TEMP request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectGET_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectGET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for module %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_GET_TEMP) ));

	m_enModuleID_C_GET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_GET_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_GET_TEMP);
	vHandlePending_C_GET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutGET_TEMP()
*
* DESCRIPTION: handle timeout of active queued C_GET_TEMP request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutGET_TEMP(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutGET_TEMP():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_GET_TEMP) ));

	m_enModuleID_C_GET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_GET_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_GET_TEMP);
	vHandlePending_C_GET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_GET_TEMP()
*
* DESCRIPTION: handle pending request C_GET_TEMP
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_GET_TEMP(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_GET_TEMP():  entered."));
	if (FALSE == IsValidModuleID(m_enModuleID_C_GET_TEMP) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_GET_TEMP response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_GET_TEMP);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (tU32)eModuleID_MAX > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_GET_TEMP[_u32Idx])
			{
				m_enModuleID_C_GET_TEMP = (::thermal_management_inc_fi::EModuleID)_u32Idx;
				if (FALSE == sendGET_TEMP( m_enModuleID_C_GET_TEMP))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_GET_TEMP(): sendGET_TEMP failed for module %u",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_GET_TEMP) ));
				    m_enModuleID_C_GET_TEMP = ::thermal_management_inc_fi::eModuleIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR2(("hc_tclClientThermal::vHandlePending_C_GET_TEMP(): sendGET_TEMP successful for module %u",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_GET_TEMP) ));
				    m_bPending_C_GET_TEMP[_u32Idx] = FALSE;
				    // start timer of C_GET_TEMP response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_GET_TEMP);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION:    qsendSET_TEMP()
*
* DESCRIPTION: queue C_SET_TEMP request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tS16 Temperature
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID,
		tS16 Temperature)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendSET_TEMP():  ModuleID: %u, Temperature: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature ));
    if (TRUE == IsValidModuleID(ModuleID))
    {
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.tTemperature = (tS16Temperature)Temperature;
    	m_bPending_C_SET_TEMP[ModuleID] = TRUE;
    	vHandlePending_C_SET_TEMP();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonSET_TEMP()
*
* DESCRIPTION: handle active queued C_SET_TEMP request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tS16 Temperature
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID,
		tS16 Temperature)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonSET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEMP: ModuleID: %u, Temperature: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature ));

	if (m_enModuleID_C_SET_TEMP == ModuleID
		&& TRUE == IsValidModuleID(ModuleID))
	{
		// reset active queued Request C_SET_TEMP
		m_enModuleID_C_SET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
		// stop timer of C_SET_TEMP response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEMP);
	}
	vHandlePending_C_SET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qrejectSET_TEMP()
*
* DESCRIPTION: handle active queued C_Set_Temp request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectSET_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectSET_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for module %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEMP) ));

	m_enModuleID_C_SET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEMP);
	vHandlePending_C_SET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutSET_TEMP()
*
* DESCRIPTION: handle timeout of active queued C_SET_TEMP request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutSET_TEMP(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutSET_TEMP():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEMP) ));

	m_enModuleID_C_SET_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEMP);
	vHandlePending_C_SET_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_SET_TEMP()
*
* DESCRIPTION: handle pending request C_SET_TEMP
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_SET_TEMP(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_SET_TEMP():  entered."));
	if (FALSE == IsValidModuleID(m_enModuleID_C_SET_TEMP) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_SET_TEMP response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEMP);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (tU32)eModuleID_MAX > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_SET_TEMP[_u32Idx])
			{
				m_enModuleID_C_SET_TEMP = (::thermal_management_inc_fi::EModuleID)_u32Idx;
				if (FALSE == sendSET_TEMP( m_enModuleID_C_SET_TEMP, (tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTemperature))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_SET_TEMP(): sendSET_TEMP failed for module %u and temperature %d dC",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEMP),
				    		(tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTemperature ));
				    m_enModuleID_C_SET_TEMP = ::thermal_management_inc_fi::eModuleIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR2(("hc_tclClientThermal::vHandlePending_C_SET_TEMP(): sendSET_TEMP successful for module %u and temperature %d dC",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEMP),
				    		(tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTemperature ));
				    m_bPending_C_SET_TEMP[_u32Idx] = FALSE;
				    // start timer of C_SET_TEMP response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_SET_TEMP);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION:    qsendSET_TEST_TEMP()
*
* DESCRIPTION: queue C_SET_TEST_TEMP request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tS16 Temperature
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID,
		tS16 Temperature)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendSET_TEST_TEMP():  ModuleID: %u, Temperature: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature ));
    if (TRUE == IsValidModuleID(ModuleID))
    {
    	m_aoThermalInfo[ModuleID].u.tThermalInfo.tTestTemperature = (tS16Temperature)Temperature;
    	m_bPending_C_SET_TEST_TEMP[ModuleID] = TRUE;
    	vHandlePending_C_SET_TEST_TEMP();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonSET_TEST_TEMP()
*
* DESCRIPTION: handle active queued C_SET_TEST_TEMP request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EModuleID ModuleID
*              tS16 Temperature
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID,
		tS16 Temperature)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonSET_TEST_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEST_TEMP: ModuleID: %u, Temperature: %d",
    		ETG_ENUM(HC_THERMAL_MODULEID, ModuleID), Temperature ));

	if (m_enModuleID_C_SET_TEST_TEMP == ModuleID
		&& TRUE == IsValidModuleID(ModuleID))
	{
		// reset active queued Request C_SetState
		m_enModuleID_C_SET_TEST_TEMP = (::thermal_management_inc_fi::EModuleID)0;
		// stop timer of C_SET_TEST_TEMP response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_TEMP);
	}
	vHandlePending_C_SET_TEST_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qrejectSET_TEST_TEMP()
*
* DESCRIPTION: handle active queued C_SET_TEST_TEMP request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectSET_TEST_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectSET_TEST_TEMP():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for module %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEST_TEMP) ));

	m_enModuleID_C_SET_TEST_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_TEST_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_TEMP);
	vHandlePending_C_SET_TEST_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutSET_TEST_TEMP()
*
* DESCRIPTION: handle timeout of active queued C_SET_TEST_TEMP request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutSET_TEST_TEMP(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutSET_TEST_TEMP():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEST_TEMP) ));

	m_enModuleID_C_SET_TEST_TEMP = (::thermal_management_inc_fi::EModuleID)0;
	// stop timer of C_SET_TEST_TEMP response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_TEMP);
	vHandlePending_C_SET_TEST_TEMP();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_SET_TEST_TEMP()
*
* DESCRIPTION: handle pending request C_SET_TEST_TEMP
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_SET_TEST_TEMP(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_SET_TEST_TEMP():  entered."));
	if (FALSE == IsValidModuleID(m_enModuleID_C_SET_TEST_TEMP) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_Set_State response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_TEMP);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (tU32)eModuleID_MAX > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_SET_TEST_TEMP[_u32Idx])
			{
				m_enModuleID_C_SET_TEST_TEMP = (::thermal_management_inc_fi::EModuleID)_u32Idx;
				if (FALSE == sendSET_TEST_TEMP( m_enModuleID_C_SET_TEST_TEMP, (tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTestTemperature))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_SET_TEST_TEMP(): sendSET_TEST_TEMP failed for module %u and temperature %d dC",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEST_TEMP),
				    		(tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTestTemperature ));
				    m_enModuleID_C_SET_TEST_TEMP = ::thermal_management_inc_fi::eModuleIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR2(("hc_tclClientThermal::vHandlePending_C_SET_TEST_TEMP(): sendSET_TEST_TEMP successful for module %u and temperature %d dC",
				    		ETG_ENUM(HC_THERMAL_MODULEID, m_enModuleID_C_SET_TEST_TEMP),
				    		(tS16)m_aoThermalInfo[_u32Idx].u.tThermalInfo.tTestTemperature ));
				    m_bPending_C_SET_TEST_TEMP[_u32Idx] = FALSE;
				    // start timer of C_Set_TEST_TEMP response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_SET_TEST_TEMP);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION:    qsendSET_TEST_FAN()
*
* DESCRIPTION: queue C_SET_TEST_FAN request and handle pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EFanID FanID
*              tU8 Percent
*
* RETURNVALUE: tBool		{TRUE - successful | else - failed}
*
*******************************************************************************/
tBool hc_tclClientThermal::qsendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qsendSET_TEST_FAN():  FanID: %u, Percent: %d",
    		ETG_ENUM(HC_THERMAL_FANID, FanID), Percent ));
    if (TRUE == IsValidFanID(FanID))
    {
    	m_u8FanTestSpeedPercent[FanID] = Percent;
    	m_bPending_C_SET_TEST_FAN[FanID] = TRUE;
    	vHandlePending_C_SET_TEST_FAN();
    	return TRUE;
    }
    return FALSE;
}

/*******************************************************************************
*
* FUNCTION:    qonSET_TEST_FAN()
*
* DESCRIPTION: handle active queued C_SET_TEST_FAN request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::EFanID FanID
*              tU8 Percent
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qonSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qonSET_TEST_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_SET_TEST_FAN: FanID: %u, Percent: %d",
    		ETG_ENUM(HC_THERMAL_FANID, FanID), Percent ));

	if (m_enFanID_C_SET_TEST_FAN == FanID
		&& TRUE == IsValidFanID(FanID))
	{
		// reset active queued Request C_SET_TEST_FAN
		m_enFanID_C_SET_TEST_FAN = (::thermal_management_inc_fi::EFanID)OSAL_C_U8_MAX;
		// stop timer of C_SET_TEST_FAN response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_FAN);
	}
	vHandlePending_C_SET_TEST_FAN();
}

/*******************************************************************************
*
* FUNCTION:    qrejectSET_TEST_FAN()
*
* DESCRIPTION: handle active queued C_SET_TEST_FAN request and handle next pending request
*
* PARAMETER:   ::thermal_management_inc_fi::ERejectReason RejectReason
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qrejectSET_TEST_FAN(::thermal_management_inc_fi::ERejectReason RejectReason)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qrejectSET_TEST_FAN():  Incomming msg: eSCC_THERMAL_MANAGEMENT_R_REJECT: RejectReason: %u for fanid %u",
    		ETG_ENUM(HC_THERMAL_REJECTREASON, RejectReason), ETG_ENUM(HC_THERMAL_FANID, m_enFanID_C_SET_TEST_FAN) ));

    m_enFanID_C_SET_TEST_FAN = (::thermal_management_inc_fi::EFanID)OSAL_C_U8_MAX;
	// stop timer of C_SET_TEST_FAN response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_FAN);
	vHandlePending_C_SET_TEST_FAN();
}

/*******************************************************************************
*
* FUNCTION:    qtimeoutSET_TEST_FAN()
*
* DESCRIPTION: handle timeout of active queued C_SET_TEST_FAN request and handle next pending request
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::qtimeoutSET_TEST_FAN(tVoid)
{
    ETG_TRACE_USR1(("hc_tclClientThermal::qtimeoutSET_TEST_FAN():  timeout for module %u",
    		ETG_ENUM(HC_THERMAL_FANID, m_enFanID_C_SET_TEST_FAN) ));

	m_enFanID_C_SET_TEST_FAN = (::thermal_management_inc_fi::EFanID)OSAL_C_U8_MAX;
	// stop timer of C_SET_TEST_FAN response timeout
	(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_FAN);
	vHandlePending_C_SET_TEST_FAN();
}

/*******************************************************************************
*
* FUNCTION:    vHandlePending_C_SET_TEST_FAN()
*
* DESCRIPTION: handle pending request C_SET_TEST_FAN
*
* PARAMETER:   None
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandlePending_C_SET_TEST_FAN(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandlePending_C_SET_TEST_FAN():  entered."));
	if (FALSE == IsValidFanID(m_enFanID_C_SET_TEST_FAN) && (TRUE == bIsServiceAvailable()))
	{
		// stop timer of C_SET_TEST_FAN response timeout
		(tVoid)s32StopResponseTimer(eResponseTimer_C_SET_TEST_FAN);
		// no active transition ... send pending information
		for (tU32 _u32Idx = 0; (sizeof(m_bPending_C_SET_TEST_FAN)/sizeof(m_bPending_C_SET_TEST_FAN[0])) > _u32Idx; ++_u32Idx)
		{
			if (TRUE == m_bPending_C_SET_TEST_FAN[_u32Idx])
			{
				m_enFanID_C_SET_TEST_FAN = (::thermal_management_inc_fi::EFanID)_u32Idx;
				if (FALSE == sendSET_TEST_FAN( m_enFanID_C_SET_TEST_FAN, m_u8FanTestSpeedPercent[_u32Idx]))
				{
					// send failed ... retry in the next handling
				    ETG_TRACE_FATAL(("hc_tclClientThermal::vHandlePending_C_SET_TEST_FAN(): sendSET_TEST_FAN failed for fanid %u and percent %d",
				    		ETG_ENUM(HC_THERMAL_FANID, m_enFanID_C_SET_TEST_FAN),
				    		m_u8FanTestSpeedPercent[_u32Idx] ));
				    m_enFanID_C_SET_TEST_FAN = ::thermal_management_inc_fi::eFanIDMax;
				}
				else
				{
					// send successful ... wait for response
				    ETG_TRACE_USR3(("hc_tclClientThermal::vHandlePending_C_SET_TEST_FAN(): sendSET_TEST_FAN successful for fanid %u and percent %d",
				    		ETG_ENUM(HC_THERMAL_FANID, m_enFanID_C_SET_TEST_FAN),
				    		m_u8FanTestSpeedPercent[_u32Idx] ));
				    m_bPending_C_SET_TEST_FAN[_u32Idx] = FALSE;
				    // start timer of C_SET_TEST_FAN response timeout
				    (tVoid)s32StartResponseTimer(eResponseTimer_C_SET_TEST_FAN);
				    // break loop
				    return;
				}
			}
		}
	}
}

/*******************************************************************************
*
* FUNCTION: 	cb_vResponseTimer()
*
* DESCRIPTION: 	timer callback for response supervision
*
* PARAMETER: 	tVoid* pArg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
OSAL_tpfCallback hc_tclClientThermal::cb_vResponseTimer(tVoid* pArg)
{
   ETG_TRACE_USR4(("hc_tclClientThermal::cb_vResponseTimer(pArg 0x%08x) entered.", pArg ));

   hc_tclClientThermal* _poClientThermal = (hc_tclClientThermal*)pArg;
   hc_tclAppMain* _poApp = hc_tclAppMain::theServer();

   if ((OSAL_NULL != _poClientThermal) && (OSAL_NULL != _poApp))
   {
	   _poApp->vPostInternalMessage(&_poClientThermal->m_oINCResponseTimeout);
   }

   ETG_TRACE_USR4(("hc_tclClientThermal::cb_vResponseTimer(pArg 0x%08x) exit.", pArg ));

   return OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION: 	s32StartResponseTimer()
*
* DESCRIPTION: 	starting of specified response supervision timer
*
* PARAMETER: 	EResponseTimer eTimerID
*
* RETURNVALUE: 	tS32      {OSAL_OK - successful | else - failed}
*
*******************************************************************************/
tS32 hc_tclClientThermal::s32StartResponseTimer(EResponseTimer eTimerID)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::s32StartResponseTimer(TimerID %d) entered.", eTimerID ));
	if (eResponseTimer_UNDEF < eTimerID && eResponseTimer_MAX > eTimerID)
	{
		if (0 == m_tResponseTimer[eTimerID])
		{
			m_tResponseTimer[eTimerID] = OSAL_ClockGetElapsedTime() + HC_TCLCLIENTTHERMAL_RESPONSE_TIMEOUT_MS;
			return m_tResponseTimer[eTimerID];
		}
	}
	return OSAL_ERROR;
}

/*******************************************************************************
*
* FUNCTION: 	s32StopResponseTimer()
*
* DESCRIPTION: 	stopping of specified response supervision timer
*
* PARAMETER: 	EResponseTimer eTimerID
*
* RETURNVALUE: 	tS32      { 0< - successful | else - failed}
*
*******************************************************************************/
tS32 hc_tclClientThermal::s32StopResponseTimer(EResponseTimer eTimerID)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::s32StopResponseTimer(TimerID %d) entered.", eTimerID ));
	if (eResponseTimer_UNDEF < eTimerID && eResponseTimer_MAX > eTimerID)
	{
		m_tResponseTimer[eTimerID] = 0;
		return m_tResponseTimer[eTimerID];
	}
	return OSAL_ERROR;
}

/*******************************************************************************
*
* FUNCTION: 	vHandle_ResponsTimer()
*
* DESCRIPTION: 	stopping of specified response supervision timer
*
* PARAMETER: 	none
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandle_ResponsTimer(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandle_ResponsTimer() entered." ));

    OSAL_tMSecond _tTime = HC_TCLCLIENTTHERMAL_CYCLETIME_MS;
    if (TRUE == m_bResponseTimerActive)
    {
 	   OSAL_tMSecond _tCurTime = OSAL_ClockGetElapsedTime();
 	   // handle all active timer depending of communication state
 	   if (TRUE == bWait4Response_COMPONENT_STATUS())
 	   {
 		  _tTime = HC_TCLCLIENTTHERMAL_RESPONSE_TIMEOUT_MS;
 		   // COMPONENT_STATUS handling
 		   vHandleTimeout_Wait4Response_COMPONENT_STATUS();
 	   }
 	   else
 	   {
 		   // COMPONENT_STATUS received -> handle pending requests
 		   for (tU16 _u16Idx = 0; HC_C_U16_ARRAYELEMENTS(m_tResponseTimer) > _u16Idx; ++_u16Idx)
 		   {
 			   OSAL_tMSecond _ResponseTimer = m_tResponseTimer[_u16Idx];
 			   if (0 == _ResponseTimer)
 			   {
 				   // inactive ... do nothing
 			   }
 			   else if (_tCurTime < _ResponseTimer)
 			   {
 				   // waiting ... do nothing
 			   }
 			   else
 			   {
 				   // call time out handler
 				   switch (_u16Idx)
 				   {
 				   case eResponseTimer_C_SET_STATE:
 					   {
 						   qtimeoutSET_STATE();
 					   }
 					   break;
 				   case eResponseTimer_C_REQ_FAN:
 					   {
 						   qtimeoutREQ_FAN();
 					   }
 					   break;
 				   case eResponseTimer_C_GET_TEMP:
 					   {
 						   qtimeoutGET_TEMP();
 					   }
 					   break;
 				   case eResponseTimer_C_SET_TEMP:
 					   {
 						   qtimeoutSET_TEMP();
 					   }
 					   break;
 				   case eResponseTimer_C_SET_TEST_TEMP:
 					   {
 						   qtimeoutSET_TEST_TEMP();
 					   }
 					   break;
 				   case eResponseTimer_C_SET_TEST_FAN:
 					   {
 						   qtimeoutSET_TEST_FAN();
 					   }
 					   break;
 				   case eResponseTimer_UNDEF:
 				   default:
 					   {
 						   ETG_TRACE_FATAL(("hc_tclClientThermal::vHandle_ResponsTimer(): unhandled response timer %d at %ds!", _u16Idx, _tCurTime ));
 					   }
 					   break;
 				   }
 				   _ResponseTimer = 0;
 			   }
 			   m_tResponseTimer[_u16Idx] = _ResponseTimer;
 		   }
 	   }
 	   // restart timer
 	   if (OSAL_NULL != m_hResponseTimer)
 	   {
 		   (tVoid)OSAL_s32TimerSetTime(m_hResponseTimer, _tTime, 0);
 	   }
    }
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTimeout_Wait4Response_COMPONENT_STATUS()
*
* DESCRIPTION: 	handle response timeout for COMPONENT_STATUS
*
* PARAMETER: 	none
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandleTimeout_Wait4Response_COMPONENT_STATUS(tVoid)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandleTimeout_Wait4Response_COMPONENT_STATUS() entered." ));
    if (TRUE == bWait4Response_COMPONENT_STATUS())
    {
        ++m_u32RetryCount_Wait4Response_COMPONENT_STATUS;
        if (FALSE == sendCOMPONENT_STATUS(m_enRequested_ApplicationStatus))
        {
            ETG_TRACE_FATAL(("vHandleTimeout_Wait4Response_COMPONENT_STATUS: sendCOMPONENT_STATUS with %u failed!",
            		ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enRequested_ApplicationStatus) ));
        }
        m_bWait4Response_COMPONENT_STATUS = TRUE;
        ETG_TRACE_ERRMEM(("HEATCTRL: INC-THM COMPONENT_STATUS response timeout ... requested %d, received %d, waiting %d for %d , cycles %d",
        		m_enRequested_ApplicationStatus, m_enReceived_ApplicationStatus,
				bWait4Response_COMPONENT_STATUS(), HC_TCLCLIENTTHERMAL_RESPONSE_TIMEOUT_MS,
				m_u32RetryCount_Wait4Response_COMPONENT_STATUS ));
    }
    ETG_TRACE_USR1(("vHandleTimeout_Wait4Response_COMPONENT_STATUS: requested %u, received %u, waiting %d, cycles %d",
    		ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enRequested_ApplicationStatus),
			ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enReceived_ApplicationStatus),
			ETG_ENUM(HC_Bool, bWait4Response_COMPONENT_STATUS()), m_u32RetryCount_Wait4Response_COMPONENT_STATUS ));
}

/*******************************************************************************
*
* FUNCTION: 	vHandle_Response_COMPONENT_STATUS()
*
* DESCRIPTION: 	handle response for COMPONENT_STATUS
*
* PARAMETER: 	::thermal_management_inc_fi::EApplicationStatus enApplicationStatus
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclClientThermal::vHandle_Response_COMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus enApplicationStatus)
{
    ETG_TRACE_USR4(("hc_tclClientThermal::vHandle_Response_COMPONENT_STATUS(%u) entered.", ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, enApplicationStatus) ));

    m_enReceived_ApplicationStatus = enApplicationStatus;
    if (m_enReceived_ApplicationStatus == m_enRequested_ApplicationStatus)
    {
    	m_bWait4Response_COMPONENT_STATUS = FALSE;
    }
    else
    {
        if (FALSE == sendCOMPONENT_STATUS(m_enRequested_ApplicationStatus))
        {
            ETG_TRACE_FATAL(("vHandle_Response_COMPONENT_STATUS: sendCOMPONENT_STATUS with %u failed!",
            		ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enRequested_ApplicationStatus) ));
        }
        m_bWait4Response_COMPONENT_STATUS = TRUE;
    }
    ETG_TRACE_USR1(("vHandle_Response_COMPONENT_STATUS: requested %u, received %u, waiting %d, cycles %d",
    		ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enRequested_ApplicationStatus),
			ETG_ENUM(HC_THERMAL_APPLICATIONSTATUS, m_enReceived_ApplicationStatus),
			ETG_ENUM(HC_Bool, bWait4Response_COMPONENT_STATUS()), m_u32RetryCount_Wait4Response_COMPONENT_STATUS ));
}

// hc_tclClientThermalAddClassPart: user specific code end

//EOF
