/*****************************************************************************
* FILE:         hc_ClientSensorIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientSensorIf__IF__H_
#define __hc_ClientSensorIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientSensorIf.h"
#include "hc_AppMain.h"
#include "hc_ClientSensorCallbackIf.h"

// hc_tclClientSensorIf_Include: user specific code start
class I_hc_tclSimuMode;
// hc_tclClientSensorIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientSensor;

class hc_tclClientSensorIf : public Ihc_tclClientSensorIf, public hc_tclClientSensorCallbackIF
{
public:

   hc_tclClientSensorIf(tVoid); 
   hc_tclClientSensorIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientSensorIf();

   virtual const tChar* getName() const { return "hc_tclClientSensorIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendGyroTemperatureGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendGyroTemperatureGet();
   }
   virtual tVoid getGyroTemperatureStatus(tF32& rGyroTemperature){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getGyroTemperatureStatus(rGyroTemperature);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onGyroTemperatureStatus(tF32 GyroTemperature);


   // hc_tclClientSensorIfDeclarations: user specific code start
   // hc_tclClientSensorIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientSensor* _poClientRef;

// hc_tclClientSensorIfDeclarationsPart2: user specific code start
   enum {
	   eSensorLocation_SensorID_GYRO = 0,
	   eSensorLocation_SensorID_MAX
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eSensorLocation_SensorID_MAX];
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
// hc_tclClientSensorIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientSensorIf__IF__H_


