
/*****************************************************************************
* FILE:         hc_ClientSensorIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientSensorIfIncludes: user specific code start
#include "hc_tclThermalSensor_Types.h"
#include "I_hc_tclSimuMode.h"
// hc_tclClientSensorIfIncludes: user specific code end

#include "hc_ClientSensorIf.h"
#include "Ihc_ClientSensor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_SENSOR
#include "trcGenProj/Header/hc_ClientSensorIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientSensorIf::
*             hc_tclClientSensorIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSensorIf::hc_tclClientSensorIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientSensorIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientSensorIfConstructor: user specific code start
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // prepare thermal info messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU32 _u32Index = 0; eSensorLocation_SensorID_MAX > _u32Index; ++_u32Index)
   {
	   m_aoThermalInfo[_u32Index].eCmd = hc_tclBaseIf::eNewThermalInfo_STANDARD;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u32Index].strClassName)-1);
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateSupported = FALSE;
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName,
			   "Ihc_tclClientSensorIf", sizeof(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName)-1);
	   switch(_u32Index)
	   {
	   case eSensorLocation_SensorID_GYRO:
		   m_aoThermalInfo[_u32Index].u.tThermalInfo.enSensorID = enThermalSensorID_GYRO;
		   break;
	   default:
		   break;
	   }
   }
   // hc_tclClientSensorIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientSensorIf::
*             ~hc_tclClientSensorIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSensorIf::~hc_tclClientSensorIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientSensorIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientSensorIfDestructor: user specific code start
   m_poSimuMode = OSAL_NULL;
   // hc_tclClientSensorIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientSensorIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     SENSOR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensorIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientSensor*>(_cpoMain->getHandler("Ihc_tclClientSensor"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientSensorIfvGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));
   // hc_tclClientSensorIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensorIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf::vStartCommunication() entered."));
   // hc_tclClientSensorIfvStartCommunication: user specific code start
   // hc_tclClientSensorIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensorIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientSensorIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateSimuMode:
		if (FALSE == pMsg->u.UpdateSimuMode.bState)
  		{
  		   for (tU32 _u32Index = 0; eSensorLocation_SensorID_MAX > _u32Index; ++_u32Index)
  		   {
  		   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
  		        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
  		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
  		   }
  		}
	   	break;
	default:
		break;
	}
   // hc_tclClientSensorIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensorIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientSensorIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientSensorIfvHandleTraceMessage: user specific code start
   // hc_tclClientSensorIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSensorIf::vTraceInfo()
{
   // hc_tclClientSensorIfvTraceInfo: user specific code start
   // hc_tclClientSensorIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientSensorIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf::onServiceAvailable() entered."));

   // hc_tclClientSensorIfvOnServiceAvailable: user specific code start
   for (tU32 _u32Index = 0; eSensorLocation_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = TRUE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientSensorIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSensorIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientSensorIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientSensorIf::onServiceUnavailable() entered."));

   // hc_tclClientSensorIfvOnServiceUnavailable: user specific code start
   for (tU32 _u32Index = 0; eSensorLocation_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = FALSE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientSensorIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientSensorIf::onGyroTemperatureStatus(tF32 GyroTemperature) {
   ETG_TRACE_USR1( ( "hc_tclClientSensorIf::onGyroTemperatureStatus(): CALLED" ) );

   // onGyroTemperatureStatus: user specific code start
   tS16Temperature _tTemperature = (tS16Temperature)(GyroTemperature *10) - 2731;
   m_aoThermalInfo[eSensorLocation_SensorID_GYRO].u.tThermalInfo.bTemperatureReceived = TRUE;
   m_aoThermalInfo[eSensorLocation_SensorID_GYRO].u.tThermalInfo.tTemperature = _tTemperature;
   if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eSensorLocation_SensorID_GYRO]);
   // onGyroTemperatureStatus: user specific code end
}




// hc_tclClientSensorIfhc_ClientSensorIf: user specific code start
// hc_tclClientSensorIfhc_ClientSensorIf: user specific code end

//EOF
