/*****************************************************************************
* FILE:         hc_ClientDimmingIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientDimmingIf__IF__H_
#define __hc_ClientDimmingIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientDimmingIf.h"
#include "hc_AppMain.h"
#include "hc_ClientDimmingCallbackIf.h"

// hc_tclClientDimmingIf_Include: user specific code start
class I_hc_tclSimuMode;
// hc_tclClientDimmingIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientDimming;

class hc_tclClientDimmingIf : public Ihc_tclClientDimmingIf, public hc_tclClientDimmingCallbackIF
{
public:

   hc_tclClientDimmingIf(tVoid); 
   hc_tclClientDimmingIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientDimmingIf();

   virtual const tChar* getName() const { return "hc_tclClientDimmingIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendDIM_DISP_PanelTemperatureGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDIM_DISP_PanelTemperatureGet();
   }
   virtual tVoid getDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature& rTemperature){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getDIM_DISP_PanelTemperatureStatus(rTemperature);
   }


   virtual tBool sendDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDIM_DISP_SwitchBacklightMStart(SwitchBacklight);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature);

   virtual tVoid onDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);

   // hc_tclClientDimmingIfDeclarations: user specific code start
   // hc_tclClientDimmingIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientDimming* _poClientRef;

// hc_tclClientDimmingIfDeclarationsPart2: user specific code start
   virtual tVoid vHandle_BacklightOFF(tBool bActive);
   enum {
	   eDimming_SensorID_PANEL = 0,
	   eDimming_SensorID_MAX
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eDimming_SensorID_MAX];
   // backlight status
   tBool m_bBacklightOFF;
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
// hc_tclClientDimmingIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientDimmingIf__IF__H_


