
/*****************************************************************************
* FILE:         hc_ClientDimmingIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientDimmingIfIncludes: user specific code start
#include "I_hc_tclSimuMode.h"
#include "hc_tclEmergencyFunction_Types.h"
// hc_tclClientDimmingIfIncludes: user specific code end

#include "hc_ClientDimmingIf.h"
#include "Ihc_ClientDimming.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_DIMMING
#include "trcGenProj/Header/hc_ClientDimmingIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientDimmingIf::
*             hc_tclClientDimmingIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDimmingIf::hc_tclClientDimmingIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientDimmingIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDimmingIfConstructor: user specific code start
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // prepare thermal infor messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU32 _u32Index = 0; eDimming_SensorID_MAX > _u32Index; ++_u32Index)
   {
	   m_aoThermalInfo[_u32Index].eCmd = hc_tclBaseIf::eNewThermalInfo_STANDARD;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u32Index].strClassName)-1);
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateSupported = FALSE;
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName,
			   "Ihc_tclClientDimmingIf", sizeof(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName)-1);
	   switch(_u32Index)
	   {
	   case eDimming_SensorID_PANEL:
		   m_aoThermalInfo[_u32Index].u.tThermalInfo.enSensorID = enThermalSensorID_Panel;
		   break;
	   default:
		   break;
	   }
   }
   m_bBacklightOFF = FALSE;
   // hc_tclClientDimmingIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientDimmingIf::
*             ~hc_tclClientDimmingIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDimmingIf::~hc_tclClientDimmingIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientDimmingIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDimmingIfDestructor: user specific code start
   m_poSimuMode = OSAL_NULL;
   // hc_tclClientDimmingIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientDimmingIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     DIMMING_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientDimming*>(_cpoMain->getHandler("Ihc_tclClientDimming"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientDimmingIfvGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));
   // hc_tclClientDimmingIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::vStartCommunication() entered."));
   // hc_tclClientDimmingIfvStartCommunication: user specific code start
   // hc_tclClientDimmingIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientDimmingIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateSimuMode:
		if (FALSE == pMsg->u.UpdateSimuMode.bState)
   		{
   		   for (tU32 _u32Index = 0; eDimming_SensorID_MAX > _u32Index; ++_u32Index)
   		   {
   		   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
   		        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   		   }
   		}
	   	break;
	case eUpdateEmergencyFunctionState:
		if (enEmergencyFunctionID_BacklightOFF == pMsg->u.tEmergencyFunctionState.enFunctionID)
		{
			tBool _bActive = ((enEmergencyFunctionState_Active <= pMsg->u.tEmergencyFunctionState.enFunctionState)
					&& (enEmergencyFunctionState_ActiveLow >= pMsg->u.tEmergencyFunctionState.enFunctionState));
			vHandle_BacklightOFF(_bActive);
		}
		break;
	default:
		break;
	}
   // hc_tclClientDimmingIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientDimmingIfvHandleTraceMessage: user specific code start
   // hc_tclClientDimmingIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vTraceInfo()
{
   // hc_tclClientDimmingIfvTraceInfo: user specific code start
   // hc_tclClientDimmingIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientDimmingIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::onServiceAvailable() entered."));

   // hc_tclClientDimmingIfvOnServiceAvailable: user specific code start
   for (tU32 _u32Index = 0; eDimming_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = TRUE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientDimmingIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimmingIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientDimmingIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientDimmingIf::onServiceUnavailable() entered."));

   // hc_tclClientDimmingIfvOnServiceUnavailable: user specific code start
   for (tU32 _u32Index = 0; eDimming_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = FALSE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientDimmingIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientDimmingIf::onDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature) {
   ETG_TRACE_USR1( ( "hc_tclClientDimmingIf::onDIM_DISP_PanelTemperatureStatus(): CALLED" ) );

   // onDIM_DISP_PanelTemperatureStatus: user specific code start
   tS16Temperature _tTemperature = (tS16Temperature)(Temperature.s16Value);
   if ((TRUE == m_aoThermalInfo[eDimming_SensorID_PANEL].u.tThermalInfo.bTemperatureReceived)
	   || (HC_TEMP_INVALID_VALUE < Temperature.s16Value))
   {
	   (tVoid)_tTemperature;
	   /* TODO: do not set and send received temperature
	   m_aoThermalInfo[eDimming_SensorID_PANEL].u.tThermalInfo.bTemperatureReceived = TRUE;
	   m_aoThermalInfo[eDimming_SensorID_PANEL].u.tThermalInfo.tTemperature = _tTemperature;
	   if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
		   hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eDimming_SensorID_PANEL]);
	   */
   }
   // onDIM_DISP_PanelTemperatureStatus: user specific code end
}

tVoid hc_tclClientDimmingIf::onDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {
   ETG_TRACE_USR1( ( "hc_tclClientDimmingIf::onDIM_DISP_SwitchBacklightMResult(): CALLED" ) );

   // onDIM_DISP_SwitchBacklightMResult: user specific code start
   (tVoid)SwitchBacklight;
   // onDIM_DISP_SwitchBacklightMResult: user specific code end
}



// hc_tclClientDimmingIfhc_ClientDimmingIf: user specific code start
/*******************************************************************************
*
* FUNCTION:    vHandle_BacklightOFF()
*
* DESCRIPTION: handle new BACKLIGHTOFF status
*
* PARAMETER:   tBool bActive
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclClientDimmingIf::vHandle_BacklightOFF(tBool bActive)
{
   ETG_TRACE_USR4( ( "hc_tclClientAudioFunctionIf::vHandle_BacklightOFF(active: %d): CALLED", bActive ) );

	dimming_fi_tcl_e8_DIM_Status _oStatus;
	_oStatus.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_ON_BY_HEATCTRL;
	if (TRUE == bActive)
		_oStatus.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_OFF_BY_HEATCTRL;
	sendDIM_DISP_SwitchBacklightMStart( _oStatus );
   // save new values
	m_bBacklightOFF = bActive;
}
// hc_tclClientDimmingIfhc_ClientDimmingIf: user specific code end

//EOF
