/*****************************************************************************
* FILE:         hc_ClientDeviceManagerIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientDeviceManagerIf__IF__H_
#define __hc_ClientDeviceManagerIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientDeviceManagerIf.h"
#include "hc_AppMain.h"
#include "hc_ClientDeviceManagerCallbackIf.h"

// hc_tclClientDeviceManagerIf_Include: user specific code start
// hc_tclClientDeviceManagerIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientDeviceManager;

class hc_tclClientDeviceManagerIf : public Ihc_tclClientDeviceManagerIf, public hc_tclClientDeviceManagerCallbackIF
{
public:

   hc_tclClientDeviceManagerIf(tVoid); 
   hc_tclClientDeviceManagerIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientDeviceManagerIf();

   virtual const tChar* getName() const { return "hc_tclClientDeviceManagerIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendDevManagerOverTempCDSet(tBool OverTemperature) {
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDevManagerOverTempCDSet(OverTemperature);
   }


   virtual tBool sendDevManagerOverTempCDGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDevManagerOverTempCDGet();
   }
   virtual tVoid getDevManagerOverTempCDStatus(tBool& rOverTemperature){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getDevManagerOverTempCDStatus(rOverTemperature);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onDevManagerOverTempCDStatus(tBool OverTemperature);


   // hc_tclClientDeviceManagerIfDeclarations: user specific code start
   // hc_tclClientDeviceManagerIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientDeviceManager* _poClientRef;

// hc_tclClientDeviceManagerIfDeclarationsPart2: user specific code start
   inline tBool bGetOverTemp_Request(tVoid) const {return m_bRequest_OverTemp;};
   inline tBool bGetOverTemp_Response(tVoid) const {return m_bResponse_OverTemp;};
   inline tBool bGetOverTemp_Send(tVoid) const {return m_bSend_OverTemp;};

   virtual tVoid vHandle_CDDriveOverTemp(tBool bOVERTEMP);
   virtual tVoid vHandle_DVDDriveOverTemp(tBool bOVERTEMP);

   tBool m_bAvailable : 1;
   tBool m_bRequest_OverTemp : 1;
   tBool m_bResponse_OverTemp : 1;
   tBool m_bSend_OverTemp : 1;
// hc_tclClientDeviceManagerIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientDeviceManagerIf__IF__H_


