
/*****************************************************************************
* FILE:         hc_ClientDeviceManagerIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientDeviceManagerIfIncludes: user specific code start
#include "hc_tclEmergencyFunction_Types.h"
// hc_tclClientDeviceManagerIfIncludes: user specific code end

#include "hc_ClientDeviceManagerIf.h"
#include "Ihc_ClientDeviceManager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_DEVICEMANAGER
#include "trcGenProj/Header/hc_ClientDeviceManagerIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientDeviceManagerIf::
*             hc_tclClientDeviceManagerIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDeviceManagerIf::hc_tclClientDeviceManagerIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientDeviceManagerIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDeviceManagerIfConstructor: user specific code start
   m_bAvailable = FALSE;
   m_bRequest_OverTemp = FALSE;
   m_bResponse_OverTemp = FALSE;
   m_bSend_OverTemp = FALSE;
   // hc_tclClientDeviceManagerIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientDeviceManagerIf::
*             ~hc_tclClientDeviceManagerIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDeviceManagerIf::~hc_tclClientDeviceManagerIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientDeviceManagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDeviceManagerIfDestructor: user specific code start
   // hc_tclClientDeviceManagerIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientDeviceManagerIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     DEVICEMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientDeviceManager*>(_cpoMain->getHandler("Ihc_tclClientDeviceManager"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientDeviceManagerIfvGetReferences: user specific code start
   // hc_tclClientDeviceManagerIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::vStartCommunication() entered."));
   // hc_tclClientDeviceManagerIfvStartCommunication: user specific code start
   // hc_tclClientDeviceManagerIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientDeviceManagerIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case eUpdateEmergencyFunctionState:
		if (enEmergencyFunctionID_CDDriveOff == pMsg->u.tEmergencyFunctionState.enFunctionID)
		{
			tBool _bActive = ((enEmergencyFunctionState_Active <= pMsg->u.tEmergencyFunctionState.enFunctionState)
					&& (enEmergencyFunctionState_ActiveLow >= pMsg->u.tEmergencyFunctionState.enFunctionState));
			vHandle_CDDriveOverTemp( _bActive );
		}
		else if (enEmergencyFunctionID_DVDDriveOff == pMsg->u.tEmergencyFunctionState.enFunctionID)
		{
			tBool _bActive = ((enEmergencyFunctionState_Active <= pMsg->u.tEmergencyFunctionState.enFunctionState)
					&& (enEmergencyFunctionState_ActiveLow >= pMsg->u.tEmergencyFunctionState.enFunctionState));
			vHandle_DVDDriveOverTemp( _bActive );
		}
		break;
	default:
		break;
	}
   // hc_tclClientDeviceManagerIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientDeviceManagerIfvHandleTraceMessage: user specific code start
   // hc_tclClientDeviceManagerIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vTraceInfo()
{
   // hc_tclClientDeviceManagerIfvTraceInfo: user specific code start
   // hc_tclClientDeviceManagerIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::onServiceAvailable() entered."));

   // hc_tclClientDeviceManagerIfvOnServiceAvailable: user specific code start
   m_bAvailable = TRUE;
   // hc_tclClientDeviceManagerIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManagerIf::onServiceUnavailable() entered."));

   // hc_tclClientDeviceManagerIfvOnServiceUnavailable: user specific code start
   m_bAvailable = FALSE;
   // hc_tclClientDeviceManagerIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientDeviceManagerIf::onDevManagerOverTempCDStatus(tBool OverTemperature) {
   ETG_TRACE_USR1( ( "hc_tclClientDeviceManagerIf::onDevManagerOverTempCDStatus(): CALLED" ) );

   // onDevManagerOverTempCDStatus: user specific code start
   m_bResponse_OverTemp = OverTemperature;
   if (bGetOverTemp_Request() != bGetOverTemp_Response())
   {
	   vHandle_CDDriveOverTemp(bGetOverTemp_Request());
   }
   else
   {
	   ETG_TRACE_USR1( ( "hc_tclClientDeviceManagerIf::onDevManagerOverTempCDStatus(): requested = %d, response = %d",
			   bGetOverTemp_Request(), bGetOverTemp_Response() ));
   }
   // onDevManagerOverTempCDStatus: user specific code end
}




// hc_tclClientDeviceManagerIfhc_ClientDeviceManagerIf: user specific code start
/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vHandle_CDDriveOverTemp()
*
* DESCRIPTION: handle CD drive over temperature
*
* PARAMETER:   tBool bOVERTEMP
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vHandle_CDDriveOverTemp(tBool bOVERTEMP)
{
   ETG_TRACE_USR1( ( "hc_tclClientDeviceManagerIf::vHandle_CDDriveOverTemp(overtemp = %d): CALLED", bOVERTEMP ));
   if (bGetOverTemp_Request() != bOVERTEMP || FALSE == bGetOverTemp_Send())
   {
	   m_bRequest_OverTemp = bOVERTEMP;
	   if (FALSE == m_bAvailable)
	   {
		   m_bSend_OverTemp = FALSE;
	   }
	   else if (FALSE == sendDevManagerOverTempCDSet(bGetOverTemp_Request()))
	   {
		   ETG_TRACE_FATAL( ( "hc_tclClientDeviceManagerIf::vHandle_CDDriveOverTemp(overtemp = %d): couldn't send message!",
				   bOVERTEMP ));
		   m_bSend_OverTemp = TRUE;
	   }
	   else
	   {
		   m_bSend_OverTemp = FALSE;
	   }
   }

}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManagerIf::vHandle_DVDDriveOverTemp()
*
* DESCRIPTION: handle DVD drive over temperature
*
* PARAMETER:   tBool bOVERTEMP
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManagerIf::vHandle_DVDDriveOverTemp(tBool bOVERTEMP)
{
   ETG_TRACE_USR1( ( "hc_tclClientDeviceManagerIf::vHandle_DVDDriveOverTemp(overtemp = %d): CALLED", bOVERTEMP ));

   vHandle_CDDriveOverTemp(bOVERTEMP);
}
// hc_tclClientDeviceManagerIfhc_ClientDeviceManagerIf: user specific code end

//EOF
