/************************************************************************
* FILE:        hc_tclThermalSensor_Statistics.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of thermal sensors statistics
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclThermalSensor_Statistics.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensor_Statistics.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    hc_tclThermalSensor_Statistics()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclThermalSensor_Statistics::hc_tclThermalSensor_Statistics()
: hc_tclThermalSensor_SM()
{
   ETG_TRACE_USR4(("hc_tclThermalSensor_Statistics() entered."));

   m_s16TempMinStepSize = HC_TS_STATISTICS_TEMPERATURECHANGE_STEPSIZE;
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensor_Statistics()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclThermalSensor_Statistics::~hc_tclThermalSensor_Statistics()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensor_Statistics() entered."));
}

/*******************************************************************************
*
* FUNCTION:    bResetStatistics()
*
* DESCRIPTION: reset statistics
*
* PARAMETER:   none
*
* RETURNVALUE: tBool
*
*******************************************************************************/
tBool hc_tclThermalSensor_Statistics::bResetStatistics()
{
   ETG_TRACE_USR4(("bResetStatistics() entered."));

   tBool _bReturn = bSetTempMin(HC_TS_STATISTICS_UNMEASURED_TEMPERATURE);
   _bReturn |= bSetTempMax(HC_TS_STATISTICS_UNMEASURED_TEMPERATURE);
   return _bReturn;
}

/*******************************************************************************
*
* FUNCTION:    bSaveMeaguredTemp()
*
* DESCRIPTION: save new measured temperature
*
* PARAMETER:   tS16 s16Temperature
*
* RETURNVALUE: tBool
*
*******************************************************************************/
tBool hc_tclThermalSensor_Statistics::bSaveMeaguredTemp(tS16 s16Temperature)
{
   ETG_TRACE_USR4(("bSaveMeaguredTemp(%d dC) entered.", s16Temperature ));

   tBool _bReturn = FALSE;
   // lowest temperature
   tS16 _s16LastTemp = s16GetTempMin();
   if((tS16)HC_TS_STATISTICS_UNMEASURED_TEMPERATURE >= _s16LastTemp)
      _bReturn |= bSetTempMin(s16Temperature);
   else if((_s16LastTemp - s16GetTempMinStepSize()) >= s16Temperature)
      _bReturn |= bSetTempMin(s16Temperature);
   // highest temperature
   _s16LastTemp = s16GetTempMax();
   if((tS16)HC_TS_STATISTICS_UNMEASURED_TEMPERATURE >= _s16LastTemp)
      _bReturn |= bSetTempMax(s16Temperature);
   else if((_s16LastTemp + s16GetTempMinStepSize()) <= s16Temperature)
      _bReturn |= bSetTempMax(s16Temperature);
   return _bReturn;
}

/*******************************************************************************
*
* FUNCTION: 	vUpdate_Statistics()
*
* DESCRIPTION: 	update sensor statistics
*
* PARAMETER:   	none
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclThermalSensor_Statistics::vUpdate_Statistics()
{
   ETG_TRACE_USR4(("vUpdate_Statistics() entered."));
   if ((enTemperatureQualifier_ESTIMATED == enGetTemperatureQualifier())
       || (enTemperatureQualifier_CALCULATED == enGetTemperatureQualifier())
       || (enTemperatureQualifier_REAL == enGetTemperatureQualifier()))
      (tVoid)bSaveMeaguredTemp(tGetTemperature());
}

/*******************************************************************************
*
* FUNCTION: 	vTraceInfo_Statistics()
*
* DESCRIPTION: 	trace statistic status information
*
* PARAMETER:   	const char* strIdentifier		trace identifier
*                                               like "HC_APPL.TSEN.GYRO_.ATTR_"
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclThermalSensor_Statistics::vTraceInfo_Statistics(const char* strIdentifier)
{
   ETG_TRACE_USR4(("vTraceInfo_Statistics() entered."));

   ETG_TRACE_USR2(("%26s: %30s=%d [dC] ", strIdentifier, "       STAT_TEMP_MIN",
		   tGetTemperatureMinStatistics() ));
   ETG_TRACE_USR2(("%26s: %30s=%d [dC] ", strIdentifier, "       STAT_TEMP_MAX",
		   tGetTemperatureMaxStatistics() ));
}
