/************************************************************************
* FILE:        hc_tclThermalSensor_FAN.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of thermal sensor fan control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 10.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_FAN_H_
#define HC_TCLTHERMALSENSOR_FAN_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_SM.h"
#include "hc_tclFANControl_Types.h"

class hc_tclThermalSensor_FAN
: virtual public hc_tclThermalSensor_Config
, virtual public hc_tclThermalSensor_SM
{
public:
   // constructors and destructors
   hc_tclThermalSensor_FAN();
   virtual ~hc_tclThermalSensor_FAN();

   tVoid vUpdate_FANSpeed(tBool &bChanged);

   inline tU8 u8GetFANSpeed(tVoid) const {return u8GetFANSpeed(enFANID_SYSTEM);};
   inline tU8 u8GetFANSpeed(tenFANID enFANID) const {
	   if (enFANID_MAX > enFANID)
		   return m_au8FANSpeed[enFANID_SYSTEM];
	   return 0;
   };
protected:
   // trace status info
   virtual tVoid vTraceInfo_FAN(const char* strIdentifier);
   inline tU8 u8SetFANSpeed(tU8 u8Speed) {m_au8FANSpeed[enFANID_SYSTEM] = u8Speed; return u8GetFANSpeed();};
   tU8 m_au8FANSpeed[enFANID_MAX];
};

#endif /* HC_TCLTHERMALSENSOR_FAN_H_ */
