/************************************************************************
* FILE:        hc_tclThermalSensor_FAN.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of thermal sensor fan control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 10.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclThermalSensor_FAN.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensor_FAN.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    hc_tclThermalSensor_FAN()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclThermalSensor_FAN::hc_tclThermalSensor_FAN()
{
   ETG_TRACE_USR4(("hc_tclThermalSensor_FAN() entered."));
   (tVoid)memset((tVoid*)m_au8FANSpeed, OSAL_NULL, sizeof(m_au8FANSpeed));
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensor_FAN()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclThermalSensor_FAN::~hc_tclThermalSensor_FAN()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensor_FAN() entered."));
}

/*******************************************************************************
*
* FUNCTION:    vUpdate_FANSpeed()
*
* DESCRIPTION: update fan speed depending of configuration and current thermal state
*
* PARAMETER:   tBool &bChanged [out]
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclThermalSensor_FAN::vUpdate_FANSpeed(tBool &bChanged)
{
   ETG_TRACE_USR4(("vUpdate_FANSpeed() entered."));

   tS16 _tTemp = (tS16)tGetTemperature();
   tenThermalState _enState = enGetSensorStateLastValid();

   switch (enGetTemperatureQualifier())
   {
	   case enTemperatureQualifier_ESTIMATED:
	   case enTemperatureQualifier_CALCULATED:
	   case enTemperatureQualifier_REAL:
	   {
		   for (tU16 _u16FanId = 0; HC_C_U16_ARRAYELEMENTS(m_au8FANSpeed) > _u16FanId; ++_u16FanId)
		   {
			   tU8 _u8FANSpeed = u8GetFANSpeed((tenFANID)_u16FanId);
			   if (_u8FANSpeed != u8SetFANSpeed(u8GetConfigFANSpeed4Temp((tenFANID)_u16FanId, _tTemp)))
				   bChanged = TRUE;
		   }
	   }
	   break;
   default:
	   {
		   // invalid temperature ... use configured fan speed depending of current last valid thermal state
		   for (tU16 _u16FanId = 0; HC_C_U16_ARRAYELEMENTS(m_au8FANSpeed) > _u16FanId; ++_u16FanId)
		   {
			   tU8 _u8FANSpeed = u8GetFANSpeed((tenFANID)_u16FanId);
			   if (_u8FANSpeed != u8SetFANSpeed(u8GetConfigFANSpeed(_enState)))
				   bChanged = TRUE;
		   }
	   }
	   break;
   }
}

/*******************************************************************************
*
* FUNCTION: 	vTraceInfo_FAN()
*
* DESCRIPTION: 	trace fan status information
*
* PARAMETER:   	const char* strIdentifier		trace identifier
*                                               like "HC_APPL.TSEN.GYRO_.ATTR_"
*
* RETURNVALUE: 	none
*
*******************************************************************************/
tVoid hc_tclThermalSensor_FAN::vTraceInfo_FAN(const char* strIdentifier)
{
   ETG_TRACE_USR4(( "vTraceInfo_FAN() entered." ));

   char _strAttrName[60] = {0};

   for (tU16 _u16Idx = 0; (tU16)enFANID_MAX > _u16Idx; ++_u16Idx)
   {
	   sprintf(_strAttrName, "         FAN_SPEED_%01u", _u16Idx);
	   ETG_TRACE_USR2(("%26s: %30s=%d [perc] ", strIdentifier, _strAttrName,
			   u8GetFANSpeed((tenFANID)_u16Idx) ));
   }
}
