/************************************************************************
* FILE:        hc_tclThermalSensorXMMODULE.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor XM Module temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 07.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORXMMODULE_H_
#define HC_TCLTHERMALSENSORXMMODULE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPXMMODULE_AVAIL, dp_tclHeatCtrlDPXMMODULE_AVAIL_Develop,
		dp_tclHeatCtrlDPXMMODULE_MinTemp,
		dp_tclHeatCtrlDPXMMODULE_MaxTemp,
		dp_tclHeatCtrlDPXMMODULE_EmergencyHighTemp, dp_tclHeatCtrlDPXMMODULE_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPXMMODULE_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_HighTemp, dp_tclHeatCtrlDPXMMODULE_HighTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_High2WarmTemp, dp_tclHeatCtrlDPXMMODULE_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_WarmTemp, dp_tclHeatCtrlDPXMMODULE_WarmTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_Warm2NormalTemp, dp_tclHeatCtrlDPXMMODULE_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_Cold2NormalTemp, dp_tclHeatCtrlDPXMMODULE_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_ColdTemp, dp_tclHeatCtrlDPXMMODULE_ColdTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_Low2ColdTemp, dp_tclHeatCtrlDPXMMODULE_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_LowTemp, dp_tclHeatCtrlDPXMMODULE_LowTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_CriticalLow2LowTemp, dp_tclHeatCtrlDPXMMODULE_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_CriticalLowTemp, dp_tclHeatCtrlDPXMMODULE_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPXMMODULE_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPXMMODULE_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPXMMODULE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop >
hc_tclThermalSensorXMMODULE_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPXMMODULE_Statistics_MinTemp,
		dp_tclHeatCtrlDPXMMODULE_Statistics_MaxTemp>
hc_tclThermalSensorXMMODULE_Statistics;

class hc_tclThermalSensorXMMODULE
: public hc_tclThermalSensor
, public hc_tclThermalSensorXMMODULE_Config
, public hc_tclThermalSensorXMMODULE_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorXMMODULE();
	virtual ~hc_tclThermalSensorXMMODULE();
};

#endif /* HC_TCLTHERMALSENSORXMMODULE_H_ */
