/************************************************************************
* FILE:        hc_tclThermalSensorV850.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display V850 temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORV850_H_
#define HC_TCLTHERMALSENSORV850_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPV850_AVAIL, dp_tclHeatCtrlDPV850_AVAIL_Develop,
		dp_tclHeatCtrlDPV850_MinTemp,
		dp_tclHeatCtrlDPV850_MaxTemp,
		dp_tclHeatCtrlDPV850_EmergencyHighTemp, dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPV850_HighTemp, dp_tclHeatCtrlDPV850_HighTemp_Develop,
		dp_tclHeatCtrlDPV850_High2WarmTemp, dp_tclHeatCtrlDPV850_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPV850_WarmTemp, dp_tclHeatCtrlDPV850_WarmTemp_Develop,
		dp_tclHeatCtrlDPV850_Warm2NormalTemp, dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPV850_Cold2NormalTemp, dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPV850_ColdTemp, dp_tclHeatCtrlDPV850_ColdTemp_Develop,
		dp_tclHeatCtrlDPV850_Low2ColdTemp, dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPV850_LowTemp, dp_tclHeatCtrlDPV850_LowTemp_Develop,
		dp_tclHeatCtrlDPV850_CriticalLow2LowTemp, dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPV850_CriticalLowTemp, dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop
		>
hc_tclThermalSensorV850_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPV850_Statistics_MinTemp,
		dp_tclHeatCtrlDPV850_Statistics_MaxTemp>
hc_tclThermalSensorV850_Statistics;

class hc_tclThermalSensorV850
: public hc_tclThermalSensor
, public hc_tclThermalSensorV850_Config
, public hc_tclThermalSensorV850_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorV850();
	virtual ~hc_tclThermalSensorV850();
};

#endif /* HC_TCLTHERMALSENSORV850_H_ */
