/************************************************************************
* FILE:        hc_tclThermalSensorTVMODULESLAVE.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: slave thermal sensor TV Module temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 07.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORTVMODULESLAVE_H_
#define HC_TCLTHERMALSENSORTVMODULESLAVE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPTVMODULESLAVE_AVAIL, dp_tclHeatCtrlDPTVMODULESLAVE_AVAIL_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_MinTemp,
		dp_tclHeatCtrlDPTVMODULESLAVE_MaxTemp,
		dp_tclHeatCtrlDPTVMODULESLAVE_EmergencyHighTemp, dp_tclHeatCtrlDPTVMODULESLAVE_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPTVMODULESLAVE_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_HighTemp, dp_tclHeatCtrlDPTVMODULESLAVE_HighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_High2WarmTemp, dp_tclHeatCtrlDPTVMODULESLAVE_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_WarmTemp, dp_tclHeatCtrlDPTVMODULESLAVE_WarmTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_Warm2NormalTemp, dp_tclHeatCtrlDPTVMODULESLAVE_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_Cold2NormalTemp, dp_tclHeatCtrlDPTVMODULESLAVE_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_ColdTemp, dp_tclHeatCtrlDPTVMODULESLAVE_ColdTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_Low2ColdTemp, dp_tclHeatCtrlDPTVMODULESLAVE_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_LowTemp, dp_tclHeatCtrlDPTVMODULESLAVE_LowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_CriticalLow2LowTemp, dp_tclHeatCtrlDPTVMODULESLAVE_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_CriticalLowTemp, dp_tclHeatCtrlDPTVMODULESLAVE_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPTVMODULESLAVE_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULESLAVE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop >
hc_tclThermalSensorTVMODULESLAVE_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPTVMODULESLAVE_Statistics_MinTemp,
		dp_tclHeatCtrlDPTVMODULESLAVE_Statistics_MaxTemp>
hc_tclThermalSensorTVMODULESLAVE_Statistics;

class hc_tclThermalSensorTVMODULESLAVE
: public hc_tclThermalSensor
, public hc_tclThermalSensorTVMODULESLAVE_Config
, public hc_tclThermalSensorTVMODULESLAVE_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorTVMODULESLAVE();
	virtual ~hc_tclThermalSensorTVMODULESLAVE();
};

#endif /* HC_TCLTHERMALSENSORTVMODULESLAVE_H_ */
